/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.mystcraft;

import dan200.computer.api.IComputerAccess;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import openmods.utils.BlockUtils;
import openmods.utils.InventoryUtils;
import openperipheral.api.Arg;
import openperipheral.api.IPeripheralAdapter;
import openperipheral.api.LuaMethod;
import openperipheral.api.LuaType;
import openperipheral.integration.mystcraft.NotebookIInventoryWrapper;
import openperipheral.integration.vanilla.AdapterInventory;
import openperipheral.util.CallWrapper;
import openperipheral.util.ReflectionHelper;

public class AdapterWritingDesk
implements IPeripheralAdapter {
    private static final Class<?> DESK_CLAZZ = ReflectionHelper.getClass("com.xcompwiz.mystcraft.tileentity.TileEntityDesk");

    @Override
    public Class<?> getTargetClass() {
        return DESK_CLAZZ;
    }

    @LuaMethod(description="Get the maximum number of notebooks this desk can store", returnType=LuaType.NUMBER)
    public int getMaxNotebookCount(IComputerAccess computer, Object tileEntityDesk) {
        return (Integer)new CallWrapper().call(tileEntityDesk, "getMaxNotebookCount", new Object[0]);
    }

    @LuaMethod(description="Get the name of a notebook", returnType=LuaType.STRING, args={@Arg(name="slot", type=LuaType.NUMBER, description="The writing desk slot you are interested in")})
    public String getNotebookName(IComputerAccess computer, Object tileEntityDesk, int number) throws Exception {
        NotebookWrapper notebookWrapper = new NotebookWrapper(tileEntityDesk, number);
        return (String)notebookWrapper.callStatic("getName", new Object[0]);
    }

    @LuaMethod(description="Get the number of pages in a notebook", returnType=LuaType.NUMBER, args={@Arg(name="slot", type=LuaType.NUMBER, description="The writing desk slot you are interested in")})
    public Integer getNotebookSize(IComputerAccess computer, Object tileEntityDesk, int number) throws Exception {
        NotebookWrapper notebookWrapper = new NotebookWrapper(tileEntityDesk, number);
        return (Integer)notebookWrapper.callStatic("getItemCount", new Object[0]);
    }

    @LuaMethod(description="Get the contents of a slot in a notebook", returnType=LuaType.NUMBER, args={@Arg(name="deskSlot", type=LuaType.NUMBER, description="The writing desk slot you are interested in"), @Arg(name="notebookSlot", type=LuaType.NUMBER, description="The notebook slot you are interested in")})
    public ItemStack getNotebookStackInSlot(IComputerAccess computer, Object tileEntityDesk, int deskSlot, int notebookSlot) throws Exception {
        NotebookWrapper notebookWrapper = new NotebookWrapper(tileEntityDesk, deskSlot);
        return (ItemStack)notebookWrapper.callStatic("getItem", notebookSlot - 1);
    }

    @LuaMethod(description="Get the last slot index in a notebook", returnType=LuaType.NUMBER, args={@Arg(name="slot", type=LuaType.NUMBER, description="The writing desk slot you are interested in")})
    public Integer getLastNotebookSlot(IComputerAccess computer, Object tileEntityDesk, int number) throws Exception {
        NotebookWrapper notebookWrapper = new NotebookWrapper(tileEntityDesk, number);
        return (Integer)notebookWrapper.callStatic("getLargestSlotId", new Object[0]) + 1;
    }

    @LuaMethod(description="Swap notebook slots", returnType=LuaType.BOOLEAN, args={@Arg(name="deskSlot", type=LuaType.NUMBER, description="The writing desk slot you are interested in"), @Arg(type=LuaType.NUMBER, name="from", description="The first slot"), @Arg(type=LuaType.NUMBER, name="to", description="The other slot")})
    public boolean swapNotebookPages(IComputerAccess computer, Object tileEntityDesk, int deskSlot, int from, int to) throws Exception {
        NotebookWrapper notebookWrapper = new NotebookWrapper(deskSlot, deskSlot);
        return new AdapterInventory().swapStacks(computer, notebookWrapper.getinventoryWrapper(), from, to);
    }

    @LuaMethod(returnType=LuaType.NUMBER, description="Push a page from the current inventory into a specific slot in the other one. Returns the amount of items moved", args={@Arg(type=LuaType.NUMBER, name="deskSlot", description="The writing desk slot you are interested in"), @Arg(type=LuaType.STRING, name="direction", description="The direction of the other inventory. (north, south, east, west, up or down)"), @Arg(type=LuaType.NUMBER, name="fromSlot", description="The slot in the current inventory that you're pushing from"), @Arg(type=LuaType.NUMBER, name="maxAmount", description="The maximum amount of items you want to push"), @Arg(type=LuaType.NUMBER, name="intoSlot", description="The slot in the other inventory that you want to push into")})
    public int pushNotebookPageIntoSlot(IComputerAccess computer, Object tileEntityDesk, int deskSlot, ForgeDirection direction, int fromSlot, int maxAmount, int intoSlot) throws Exception {
        NotebookWrapper notebookWrapper = new NotebookWrapper(tileEntityDesk, deskSlot);
        return InventoryUtils.moveItemInto((IInventory)notebookWrapper.getinventoryWrapper(), (int)(fromSlot - 1), (Object)notebookWrapper.getTargetTile(direction), (int)(intoSlot - 1), (int)maxAmount, (ForgeDirection)direction.getOpposite(), (boolean)true);
    }

    @LuaMethod(returnType=LuaType.NUMBER, description="Push an item from the current inventory into any slot on the other one. Returns the amount of items moved", args={@Arg(type=LuaType.NUMBER, name="deskSlot", description="The writing desk slot you are interested in"), @Arg(type=LuaType.STRING, name="direction", description="The direction of the other inventory. (north, south, east, west, up or down)"), @Arg(type=LuaType.NUMBER, name="notebookSlot", description="The slot in the current inventory that you're pushing from"), @Arg(type=LuaType.NUMBER, name="maxAmount", description="The maximum amount of items you want to push")})
    public int pushNotebookPage(IComputerAccess computer, Object desk, int deskSlot, ForgeDirection direction, int notebookSlot, int maxAmount) throws Exception {
        NotebookWrapper notebookWrapper = new NotebookWrapper(desk, deskSlot);
        return InventoryUtils.moveItemInto((IInventory)notebookWrapper.getinventoryWrapper(), (int)(notebookSlot - 1), (Object)notebookWrapper.getTargetTile(direction), (int)-1, (int)maxAmount, (ForgeDirection)direction.getOpposite(), (boolean)true);
    }

    @LuaMethod(returnType=LuaType.NUMBER, description="Pull an item from the target inventory into any slot in the current one. Returns the amount of items moved", args={@Arg(type=LuaType.NUMBER, name="deskSlot", description="The writing desk slot you are interested in"), @Arg(type=LuaType.STRING, name="direction", description="The direction of the other inventory. (north, south, east, west, up or down)"), @Arg(type=LuaType.NUMBER, name="notebookSlot", description="The slot in the other inventory that you're pulling from"), @Arg(type=LuaType.NUMBER, name="maxAmount", description="The maximum amount of items you want to pull")})
    public int pullNotebookPage(IComputerAccess computer, Object desk, int deskSlot, ForgeDirection direction, int notebookSlot, int maxAmount) throws Exception {
        NotebookWrapper notebookWrapper = new NotebookWrapper(desk, deskSlot);
        return InventoryUtils.moveItemInto((IInventory)notebookWrapper.getTargetTile(direction), (int)(notebookSlot - 1), (Object)notebookWrapper.getinventoryWrapper(), (int)-1, (int)maxAmount, (ForgeDirection)direction.getOpposite(), (boolean)true);
    }

    private static class NotebookWrapper {
        public ItemStack notebook;
        public Class<?> inventoryNotebookClass = ReflectionHelper.getClass("com.xcompwiz.mystcraft.inventory.InventoryNotebook");
        public Object tileEntityDesk;

        public NotebookWrapper(Object tile, int number) throws Exception {
            this.tileEntityDesk = tile;
            int slot = number + 4 - 1;
            IInventory inventory = (IInventory)this.tileEntityDesk;
            if (slot < 4 || slot > inventory.func_70302_i_()) {
                throw new Exception("Invalid slot number");
            }
            this.notebook = inventory.func_70301_a(slot);
        }

        public IInventory getTargetTile(ForgeDirection direction) throws Exception {
            if (direction == ForgeDirection.UNKNOWN) {
                throw new Exception("Invalid direction");
            }
            TileEntity targetTile = BlockUtils.getTileInDirection((TileEntity)((TileEntity)this.tileEntityDesk), (ForgeDirection)direction);
            if (targetTile == null || !(targetTile instanceof IInventory)) {
                throw new Exception("Target direction is not a valid inventory");
            }
            return (IInventory)targetTile;
        }

        public <T> T callStatic(String method, Object ... extra_args) {
            Object[] args;
            if (extra_args.length == 0) {
                args = new Object[]{this.notebook};
            } else {
                args = new Object[extra_args.length + 1];
                args[0] = this.notebook;
                System.arraycopy(extra_args, 0, args, 1, extra_args.length);
            }
            return new CallWrapper().call(this.inventoryNotebookClass, method, args);
        }

        public IInventory getinventoryWrapper() throws ClassNotFoundException {
            return new NotebookIInventoryWrapper(this.notebook);
        }
    }
}

