/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.forestry;

import dan200.computer.api.IComputerAccess;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesRoot;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import openperipheral.TypeConversionRegistry;
import openperipheral.api.Arg;
import openperipheral.api.IPeripheralAdapter;
import openperipheral.api.LuaMethod;
import openperipheral.api.LuaType;
import openperipheral.api.OnTickSafe;

@OnTickSafe
public class AdapterBeeHousing
implements IPeripheralAdapter {
    @Override
    public Class<?> getTargetClass() {
        return IBeeHousing.class;
    }

    @LuaMethod(returnType=LuaType.BOOLEAN, description="Can the bees breed?")
    public boolean canBreed(IComputerAccess computer, IBeeHousing beeHousing) {
        return beeHousing.canBreed();
    }

    @LuaMethod(returnType=LuaType.TABLE, description="Get the drone")
    public IIndividual getDrone(IComputerAccess computer, IBeeHousing beeHousing) {
        ItemStack drone = beeHousing.getDrone();
        if (drone != null) {
            return AlleleManager.alleleRegistry.getIndividual(drone);
        }
        return null;
    }

    @LuaMethod(returnType=LuaType.TABLE, description="Get the queen")
    public IIndividual getQueen(IComputerAccess computer, IBeeHousing beeHousing) {
        ItemStack queen = beeHousing.getQueen();
        if (queen != null) {
            return AlleleManager.alleleRegistry.getIndividual(queen);
        }
        return null;
    }

    @LuaMethod(returnType=LuaType.TABLE, description="Get the full breeding list thingy. Experimental!")
    public Map<?, HashMap<String, Object>> getBeeBreedingData(IComputerAccess computer, IBeeHousing housing) {
        ISpeciesRoot beeRoot = AlleleManager.alleleRegistry.getSpeciesRoot("rootBees");
        if (beeRoot == null) {
            return null;
        }
        HashMap result = new HashMap();
        int j = 1;
        for (IMutation mutation : beeRoot.getMutations(false)) {
            IAllele allele2;
            HashMap<String, Object> mutationMap = new HashMap<String, Object>();
            IAllele allele1 = mutation.getAllele0();
            if (allele1 != null) {
                mutationMap.put("allele1", allele1.getName());
            }
            if ((allele2 = mutation.getAllele1()) != null) {
                mutationMap.put("allele2", allele2.getName());
            }
            mutationMap.put("chance", Float.valueOf(mutation.getBaseChance()));
            mutationMap.put("specialConditions", TypeConversionRegistry.toLua(mutation.getSpecialConditions().toArray()));
            IAllele[] template = mutation.getTemplate();
            if (template != null && template.length > 0) {
                mutationMap.put("result", template[0].getName());
            }
            result.put(j++, mutationMap);
        }
        return result;
    }

    @LuaMethod(returnType=LuaType.TABLE, description="Get the parents for a particular mutation", args={@Arg(name="childType", description="The type of bee you want the parents for", type=LuaType.STRING)})
    public Map<Object, HashMap<String, Object>> getBeeParents(IComputerAccess computer, IBeeHousing housing, String childType) {
        ISpeciesRoot beeRoot = AlleleManager.alleleRegistry.getSpeciesRoot("rootBees");
        if (beeRoot == null) {
            return null;
        }
        int i = 1;
        HashMap<Object, HashMap<String, Object>> result = new HashMap<Object, HashMap<String, Object>>();
        for (IMutation mutation : beeRoot.getMutations(false)) {
            IAllele allele2;
            IAllele[] template = mutation.getTemplate();
            if (template == null || template.length < 1 || !template[0].getName().toLowerCase().equals(childType.toLowerCase())) continue;
            HashMap<String, Object> parentMap = new HashMap<String, Object>();
            IAllele allele1 = mutation.getAllele0();
            if (allele1 != null) {
                parentMap.put("allele1", allele1.getName());
            }
            if ((allele2 = mutation.getAllele1()) != null) {
                parentMap.put("allele2", allele2.getName());
            }
            parentMap.put("chance", Float.valueOf(mutation.getBaseChance()));
            parentMap.put("specialConditions", TypeConversionRegistry.toLua(mutation.getSpecialConditions().toArray()));
            result.put(i++, parentMap);
        }
        return result;
    }
}

