/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.enderstorage;

import dan200.computer.api.IComputerAccess;
import java.util.HashMap;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import openperipheral.api.Arg;
import openperipheral.api.IPeripheralAdapter;
import openperipheral.api.LuaMethod;
import openperipheral.api.LuaType;
import openperipheral.util.ReflectionHelper;

public class AdapterFrequencyOwner
implements IPeripheralAdapter {
    private static final Class<?> CLAZZ = ReflectionHelper.getClass("codechicken.enderstorage.common.TileFrequencyOwner");

    @Override
    public Class<?> getTargetClass() {
        return CLAZZ;
    }

    @LuaMethod(returnType=LuaType.TABLE, onTick=false, description="Get the colours active on this chest or tank")
    public HashMap<Integer, Double> getColors(IComputerAccess computer, TileEntity frequencyOwner) {
        int frequency = AdapterFrequencyOwner.getFreq(frequencyOwner);
        HashMap<Integer, Double> colors = new HashMap<Integer, Double>(3);
        colors.put(1, Math.pow(2.0, frequency >> 8 & 0xF));
        colors.put(2, Math.pow(2.0, frequency >> 4 & 0xF));
        colors.put(3, Math.pow(2.0, frequency & 0xF));
        return colors;
    }

    @LuaMethod(returnType=LuaType.TABLE, onTick=false, description="Get the colours active on this chest or tank")
    public HashMap<Integer, Double> getColours(IComputerAccess computer, TileEntity frequencyOwner) {
        return this.getColors(computer, frequencyOwner);
    }

    @LuaMethod(returnType=LuaType.VOID, onTick=false, description="Set the frequency of this chest or tank", args={@Arg(name="color_left", type=LuaType.NUMBER, description="The first color"), @Arg(name="color_middle", type=LuaType.NUMBER, description="The second color"), @Arg(name="color_right", type=LuaType.NUMBER, description="The third color")})
    public void setColors(IComputerAccess computer, TileEntity frequencyOwner, int color_left, int color_middle, int color_right) throws Exception {
        int high = AdapterFrequencyOwner.parseComputerCraftColor(color_left);
        int med = AdapterFrequencyOwner.parseComputerCraftColor(color_middle);
        int low = AdapterFrequencyOwner.parseComputerCraftColor(color_right);
        int frequency = ((high & 0xF) << 8) + ((med & 0xF) << 4) + (low & 0xF);
        this.setFreq(frequencyOwner, frequency);
    }

    @LuaMethod(returnType=LuaType.VOID, onTick=false, description="Set the frequency of this chest or tank", args={@Arg(name="color_left", type=LuaType.NUMBER, description="The first color"), @Arg(name="color_middle", type=LuaType.NUMBER, description="The second color"), @Arg(name="color_right", type=LuaType.NUMBER, description="The third color")})
    public void setColours(IComputerAccess computer, TileEntity frequencyOwner, int colour_left, int colour_middle, int colour_right) throws Exception {
        this.setColors(computer, frequencyOwner, colour_left, colour_middle, colour_right);
    }

    @LuaMethod(returnType=LuaType.TABLE, onTick=false, description="Get the frequency of this chest or tank")
    public int getFrequency(IComputerAccess computer, TileEntity frequencyOwner) {
        return AdapterFrequencyOwner.getFreq(frequencyOwner);
    }

    @LuaMethod(returnType=LuaType.VOID, onTick=false, description="Set the frequency of this chest or tank", args={@Arg(name="frequency", type=LuaType.NUMBER, description="A single color that represents all three colours on this chest or tank")})
    public void setFrequency(IComputerAccess computer, TileEntity frequencyOwner, int frequency) throws Exception {
        this.setFreq(frequencyOwner, frequency);
    }

    private static int getFreq(TileEntity frequencyOwner) {
        NBTTagCompound nbt = new NBTTagCompound();
        frequencyOwner.func_70310_b(nbt);
        return nbt.func_74762_e("freq");
    }

    private void setFreq(TileEntity frequencyOwner, int frequency) throws Exception {
        if (frequency < 0 || frequency > 4095) {
            throw new Exception("Frequency out of bounds. Should be 0-4095");
        }
        ReflectionHelper.call(frequencyOwner, "setFreq", frequency);
    }

    private static int parseComputerCraftColor(int color) throws Exception {
        if (color < 0 || color > 32768) {
            throw new Exception("Invalid color supplied");
        }
        double val = Math.log(color) / Math.log(2.0);
        if (val < 0.0 || val > 15.0 || val % 1.0 != 0.0) {
            throw new Exception("Invalid color supplied.");
        }
        return (int)val;
    }
}

