/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.peripheral;

import com.google.common.base.Preconditions;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.ILuaContext;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.Callable;
import openperipheral.adapter.MethodDeclaration;
import openperipheral.adapter.object.IObjectMethodExecutor;
import openperipheral.adapter.peripheral.ExecutionStrategy;
import openperipheral.adapter.peripheral.IPeripheralMethodExecutor;
import openperipheral.adapter.peripheral.PeripheralAdapterWrapper;

public class PeripheralInlineAdapterWrapper
extends PeripheralAdapterWrapper {
    public PeripheralInlineAdapterWrapper(Class<?> targetClass) {
        super(targetClass, targetClass);
    }

    @Override
    protected IPeripheralMethodExecutor createDirectExecutor(MethodDeclaration method, ExecutionStrategy strategy) {
        return new InlineMethodExecutor(method, strategy);
    }

    @Override
    protected void nameDefaultParameters(MethodDeclaration decl) {
        decl.nameJavaArg(0, "computer");
    }

    @Override
    protected void validateArgTypes(MethodDeclaration decl) {
        decl.checkJavaArgNames("computer", "context");
        decl.checkJavaArgType("computer", IComputerAccess.class);
        decl.checkJavaArgType("context", ILuaContext.class);
    }

    @Override
    protected IPeripheralMethodExecutor adaptObjectExecutor(final Method targetProvider, final IObjectMethodExecutor executor) {
        Preconditions.checkArgument((boolean)Arrays.equals(targetProvider.getParameterTypes(), new Class[0]));
        return new IPeripheralMethodExecutor(){

            @Override
            public boolean isSynthetic() {
                return false;
            }

            @Override
            public MethodDeclaration getWrappedMethod() {
                return executor.getWrappedMethod();
            }

            @Override
            public Object[] execute(IComputerAccess computer, ILuaContext context, Object target, Object[] args) throws Exception {
                Object executorTarget = targetProvider.invoke(target, new Object[0]);
                return executor.execute(context, executorTarget, args);
            }
        };
    }

    private static class InlineMethodExecutor
    extends PeripheralAdapterWrapper.PeripheralMethodExecutor {
        public InlineMethodExecutor(MethodDeclaration method, ExecutionStrategy strategy) {
            super(method, strategy);
        }

        @Override
        protected Callable<Object[]> createWrapper(IComputerAccess computer, ILuaContext context, Object target, Object[] luaArgs) {
            return this.method.createWrapper(target).setJavaArg("computer", computer).setJavaArg("context", context).setLuaArgs(luaArgs);
        }
    }
}

