/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.peripheral;

import com.google.common.base.Preconditions;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.ILuaContext;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.Callable;
import openperipheral.adapter.MethodDeclaration;
import openperipheral.adapter.object.IObjectMethodExecutor;
import openperipheral.adapter.peripheral.ExecutionStrategy;
import openperipheral.adapter.peripheral.IPeripheralMethodExecutor;
import openperipheral.adapter.peripheral.PeripheralAdapterWrapper;
import openperipheral.api.IPeripheralAdapter;

public class PeripheralExternalAdapterWrapper
extends PeripheralAdapterWrapper {
    private final IPeripheralAdapter adapter;

    public PeripheralExternalAdapterWrapper(IPeripheralAdapter adapter) {
        super(adapter.getClass(), adapter.getTargetClass());
        this.adapter = adapter;
    }

    @Override
    protected IPeripheralMethodExecutor createDirectExecutor(MethodDeclaration method, ExecutionStrategy strategy) {
        return new NormalMethodExecutor(method, strategy);
    }

    @Override
    protected void nameDefaultParameters(MethodDeclaration decl) {
        decl.nameJavaArg(0, "computer");
        decl.nameJavaArg(1, "target");
    }

    @Override
    protected void validateArgTypes(MethodDeclaration decl) {
        decl.checkJavaArgNames("computer", "context", "target");
        decl.checkJavaArgType("computer", IComputerAccess.class);
        decl.checkJavaArgType("context", ILuaContext.class);
        decl.checkJavaArgType("target", this.targetCls);
    }

    @Override
    protected IPeripheralMethodExecutor adaptObjectExecutor(final Method targetProvider, final IObjectMethodExecutor executor) {
        Preconditions.checkArgument((boolean)Arrays.equals(targetProvider.getParameterTypes(), new Class[]{this.targetCls}));
        return new IPeripheralMethodExecutor(){

            @Override
            public boolean isSynthetic() {
                return false;
            }

            @Override
            public MethodDeclaration getWrappedMethod() {
                return executor.getWrappedMethod();
            }

            @Override
            public Object[] execute(IComputerAccess computer, ILuaContext context, Object target, Object[] args) throws Exception {
                Object executorTarget = targetProvider.invoke((Object)PeripheralExternalAdapterWrapper.this.adapter, target);
                return executor.execute(context, executorTarget, args);
            }
        };
    }

    private class NormalMethodExecutor
    extends PeripheralAdapterWrapper.PeripheralMethodExecutor {
        public NormalMethodExecutor(MethodDeclaration method, ExecutionStrategy strategy) {
            super(method, strategy);
        }

        @Override
        protected Callable<Object[]> createWrapper(IComputerAccess computer, ILuaContext context, Object target, Object[] luaArgs) {
            return this.method.createWrapper(PeripheralExternalAdapterWrapper.this.adapter).setJavaArg("computer", computer).setJavaArg("target", target).setJavaArg("context", context).setLuaArgs(luaArgs);
        }
    }
}

