/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.peripheral;

import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IHostedPeripheral;
import dan200.computer.api.ILuaContext;
import dan200.computer.api.IMount;
import java.util.Arrays;
import java.util.logging.Level;
import net.minecraft.nbt.NBTTagCompound;
import openmods.Log;
import openperipheral.adapter.AdaptedClass;
import openperipheral.adapter.peripheral.IPeripheralMethodExecutor;
import openperipheral.api.IAttachable;
import openperipheral.util.PeripheralUtils;
import openperipheral.util.ResourceMount;

public class HostedPeripheral
implements IHostedPeripheral {
    private static final String MOUNT_NAME = "openp";
    private static final IMount MOUNT = new ResourceMount();
    protected final String type;
    protected final Object targetObject;
    protected final AdaptedClass<IPeripheralMethodExecutor> wrapped;

    public HostedPeripheral(AdaptedClass<IPeripheralMethodExecutor> wrapper, Object targetObject) {
        this.targetObject = targetObject;
        this.type = PeripheralUtils.getNameForTarget(targetObject);
        this.wrapped = wrapper;
    }

    public String getType() {
        return this.type;
    }

    public String[] getMethodNames() {
        return this.wrapped.methodNames;
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int index, Object[] arguments) throws Exception {
        try {
            IPeripheralMethodExecutor executor = this.wrapped.getMethod(index);
            return executor.execute(computer, context, this.targetObject, arguments);
        }
        catch (Exception e) {
            Log.log((Level)Level.FINE, (Throwable)e, (String)"Error during method %d execution on peripheral %s, args: %s", (Object[])new Object[]{index, this.type, Arrays.toString(arguments)});
            throw e;
        }
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
        computer.mount(MOUNT_NAME, MOUNT);
        if (this.targetObject instanceof IAttachable) {
            ((IAttachable)this.targetObject).addComputer(computer);
        }
    }

    public void detach(IComputerAccess computer) {
        if (this.targetObject instanceof IAttachable) {
            ((IAttachable)this.targetObject).removeComputer(computer);
        }
    }

    public void update() {
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
    }
}

