/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.peripheral;

import com.google.common.base.Preconditions;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.ILuaContext;
import java.util.Arrays;
import java.util.concurrent.Callable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import openmods.Log;
import openperipheral.TickHandler;
import openperipheral.api.IWorldProvider;
import openperipheral.util.PrettyPrint;

public abstract class ExecutionStrategy {
    public static final ExecutionStrategy ASYNCHRONOUS = new ExecutionStrategy(){

        @Override
        public Object[] execute(Object target, IComputerAccess computer, ILuaContext context, Callable<Object[]> callable) throws Exception {
            return callable.call();
        }
    };
    private static final ExecutionStrategy ON_TICK_TILE_ENTITY = new OnTick<TileEntity>(){

        @Override
        public World getWorld(TileEntity target) {
            return target.field_70331_k;
        }
    };
    private static final ExecutionStrategy ON_TICK_WORLD_PROVIDER = new OnTick<IWorldProvider>(){

        @Override
        public World getWorld(IWorldProvider target) {
            return target.getWorld();
        }
    };
    private static final ExecutionStrategy ON_TICK_OTHER = new OnTick<Object>(){

        @Override
        public World getWorld(Object target) {
            if (target instanceof TileEntity) {
                return ((TileEntity)target).field_70331_k;
            }
            if (target instanceof IWorldProvider) {
                return ((IWorldProvider)target).getWorld();
            }
            throw new UnsupportedOperationException(String.format("Methods of adapter for %s cannot be synchronous", target.getClass()));
        }

        @Override
        public boolean isAlwaysSafe() {
            return false;
        }
    };

    public abstract Object[] execute(Object var1, IComputerAccess var2, ILuaContext var3, Callable<Object[]> var4) throws Exception;

    public boolean isAlwaysSafe() {
        return true;
    }

    public static Object[] wrap(Object ... args) {
        return args;
    }

    public static ExecutionStrategy createOnTickStrategy(Class<?> targetClass) {
        if (TileEntity.class.isAssignableFrom(targetClass)) {
            return ON_TICK_TILE_ENTITY;
        }
        if (IWorldProvider.class.isAssignableFrom(targetClass)) {
            return ON_TICK_WORLD_PROVIDER;
        }
        return ON_TICK_OTHER;
    }

    private static abstract class OnTick<T>
    extends ExecutionStrategy {
        private static final String EVENT_SUCCESS = "openperipheral_success";
        private static final String EVENT_ERROR = "openperipheral_error";

        private OnTick() {
        }

        public abstract World getWorld(T var1);

        @Override
        public Object[] execute(Object target, IComputerAccess computer, ILuaContext context, final Callable<Object[]> callable) throws Exception {
            World world = this.getWorld(target);
            Preconditions.checkNotNull((Object)world, (Object)"Trying to execute OnTick method, but no available world");
            final Responder responder = new Responder(computer);
            TickHandler.addTickCallback(world, new Runnable(){

                @Override
                public void run() {
                    try {
                        Object[] response = (Object[])callable.call();
                        responder.queueEvent(OnTick.EVENT_SUCCESS, response);
                    }
                    catch (Throwable e) {
                        responder.queueEvent(OnTick.EVENT_ERROR, ExecutionStrategy.wrap(PrettyPrint.getMessageForThrowable(e)));
                    }
                }
            });
            try {
                Object[] event;
                String eventName;
                do {
                    if (!(eventName = (String)(event = context.pullEvent(null))[0]).equals(EVENT_ERROR)) continue;
                    throw new RuntimeException((String)event[1]);
                } while (!eventName.equals(EVENT_SUCCESS));
                return Arrays.copyOfRange(event, 1, event.length);
            }
            catch (InterruptedException e) {
                responder.tooLate();
                throw e;
            }
        }
    }

    private static class Responder {
        private final IComputerAccess access;
        private boolean nobodyLovesMe;

        private Responder(IComputerAccess access) {
            this.access = access;
        }

        public synchronized void tooLate() {
            this.nobodyLovesMe = true;
        }

        public synchronized void queueEvent(String event, Object ... args) {
            if (this.nobodyLovesMe) {
                Log.warn((String)"Ignoring event '%s', args='%s'. (sob)", (Object[])new Object[]{event, Arrays.toString(args)});
            } else {
                try {
                    this.access.queueEvent(event, args);
                }
                catch (Exception e) {
                    Log.warn((Throwable)e, (String)"Failed to queue response '%s', args='%s'", (Object[])new Object[]{event, Arrays.toString(args)});
                }
            }
        }
    }
}

