/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.object;

import dan200.computer.api.ILuaContext;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.Callable;
import openperipheral.adapter.AdapterWrapper;
import openperipheral.adapter.MethodDeclaration;
import openperipheral.adapter.object.IObjectMethodExecutor;
import openperipheral.api.IObjectAdapter;

public abstract class ObjectAdapterWrapper
extends AdapterWrapper<IObjectMethodExecutor> {
    private static final String ARG_TARGET = "target";
    private static final String ARG_CONTEXT = "context";

    protected ObjectAdapterWrapper(Class<?> adapterClass, Class<?> targetClass) {
        super(adapterClass, targetClass);
    }

    @Override
    protected Map<String, IObjectMethodExecutor> buildMethodMap() {
        return this.buildMethodMap(true, new AdapterWrapper.MethodExecutorFactory<IObjectMethodExecutor>(){

            @Override
            public IObjectMethodExecutor createExecutor(Method method, final MethodDeclaration decl) {
                return new IObjectMethodExecutor(){

                    @Override
                    public MethodDeclaration getWrappedMethod() {
                        return decl;
                    }

                    @Override
                    public Object[] execute(ILuaContext context, Object target, Object[] args) throws Exception {
                        return ObjectAdapterWrapper.this.createWrapper(decl, context, target, args).call();
                    }

                    @Override
                    public boolean isSynthetic() {
                        return false;
                    }
                };
            }
        });
    }

    protected abstract Callable<Object[]> createWrapper(MethodDeclaration var1, ILuaContext var2, Object var3, Object[] var4);

    public static class Inline
    extends ObjectAdapterWrapper {
        public Inline(Class<?> targetClass) {
            super(targetClass, targetClass);
        }

        @Override
        protected void nameDefaultParameters(MethodDeclaration decl) {
            decl.nameJavaArg(0, ObjectAdapterWrapper.ARG_CONTEXT);
        }

        @Override
        protected void validateArgTypes(MethodDeclaration decl) {
            decl.checkJavaArgNames(ObjectAdapterWrapper.ARG_CONTEXT);
            decl.checkJavaArgType(ObjectAdapterWrapper.ARG_CONTEXT, ILuaContext.class);
        }

        @Override
        protected Callable<Object[]> createWrapper(MethodDeclaration decl, ILuaContext context, Object target, Object[] args) {
            return decl.createWrapper(target).setJavaArg(ObjectAdapterWrapper.ARG_CONTEXT, context).setLuaArgs(args);
        }
    }

    public static class External
    extends ObjectAdapterWrapper {
        private final IObjectAdapter adapter;

        public External(IObjectAdapter adapter) {
            super(adapter.getClass(), adapter.getTargetClass());
            this.adapter = adapter;
        }

        @Override
        protected void nameDefaultParameters(MethodDeclaration decl) {
            decl.nameJavaArg(0, ObjectAdapterWrapper.ARG_TARGET);
            decl.nameJavaArg(1, ObjectAdapterWrapper.ARG_CONTEXT);
        }

        @Override
        protected void validateArgTypes(MethodDeclaration decl) {
            decl.checkJavaArgNames(ObjectAdapterWrapper.ARG_CONTEXT, ObjectAdapterWrapper.ARG_TARGET);
            decl.checkJavaArgType(ObjectAdapterWrapper.ARG_CONTEXT, ILuaContext.class);
            decl.checkJavaArgType(ObjectAdapterWrapper.ARG_TARGET, this.targetCls);
        }

        @Override
        protected Callable<Object[]> createWrapper(MethodDeclaration decl, ILuaContext context, Object target, Object[] args) {
            return decl.createWrapper(this.adapter).setJavaArg(ObjectAdapterWrapper.ARG_TARGET, target).setJavaArg(ObjectAdapterWrapper.ARG_CONTEXT, context).setLuaArgs(args);
        }
    }
}

