/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.object;

import com.google.common.base.Preconditions;
import dan200.computer.api.ILuaContext;
import dan200.computer.api.ILuaObject;
import openperipheral.adapter.AdaptedClass;
import openperipheral.adapter.AdapterManager;
import openperipheral.adapter.object.IObjectMethodExecutor;

public class LuaObjectWrapper {
    public static ILuaObject wrap(AdapterManager<?, IObjectMethodExecutor> manager, Object target) {
        Preconditions.checkNotNull((Object)target, (Object)"Can't wrap null");
        AdaptedClass<IObjectMethodExecutor> adapted = manager.getAdapterClass(target.getClass());
        return LuaObjectWrapper.wrap(adapted, target);
    }

    public static ILuaObject wrap(final AdaptedClass<IObjectMethodExecutor> adapted, final Object target) {
        return new ILuaObject(){

            public String[] getMethodNames() {
                return adapted.methodNames;
            }

            public Object[] callMethod(ILuaContext context, int method, Object[] arguments) throws Exception {
                IObjectMethodExecutor executor = (IObjectMethodExecutor)adapted.getMethod(method);
                Preconditions.checkNotNull((Object)executor, (String)"Invalid method index %s for wrapped %s", (Object[])new Object[]{method, target.getClass()});
                return executor.execute(context, target, arguments);
            }
        };
    }
}

