/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import openmods.Log;
import openmods.utils.AnnotationMap;
import openperipheral.TypeConversionRegistry;
import openperipheral.api.Arg;
import openperipheral.api.IMultiReturn;
import openperipheral.api.LuaCallable;
import openperipheral.api.LuaMethod;
import openperipheral.api.LuaType;
import openperipheral.api.Named;
import openperipheral.api.Optionals;

public class MethodDeclaration {
    public final String name;
    private final Method method;
    private final String description;
    private final LuaType[] returnTypes;
    private final boolean validateReturn;
    private final Map<String, Integer> namedArgs = Maps.newHashMap();
    private final List<Class<?>> javaArgs;
    private final List<ConvertedArgument> luaArgs;

    private ConvertedArgument createLuaArg(AnnotationMap annotations, Class<?> javaArgType, int index, boolean forceOptional, boolean isVarArg) {
        Arg arg = (Arg)annotations.get(Arg.class);
        Preconditions.checkNotNull((Object)arg);
        boolean isOptional = forceOptional || annotations.get(Optionals.class) != null;
        ConvertedArgument result = new ConvertedArgument(arg, javaArgType, index, isVarArg, isOptional);
        Preconditions.checkArgument((!result.javaType.isPrimitive() || !result.isNullable ? 1 : 0) != 0, (String)"In method %s arg %s has primitive type %s, but is marked nullable or optional", (Object[])new Object[]{this.method, index, result.javaType});
        return result;
    }

    public MethodDeclaration(Method method, LuaMethod luaMethod) {
        int arg;
        this.method = method;
        String luaName = luaMethod.name();
        this.name = "[none set]".equals(luaName) ? method.getName() : luaName;
        this.description = luaMethod.description();
        this.returnTypes = new LuaType[]{luaMethod.returnType()};
        this.validateReturn = false;
        Class<?>[] methodArgs = method.getParameterTypes();
        Arg[] declaredLuaArgs = luaMethod.args();
        Annotation[][] argsAnnotations = method.getParameterAnnotations();
        int luaArgsStart = methodArgs.length - declaredLuaArgs.length;
        boolean isVarArg = method.isVarArgs();
        Preconditions.checkArgument((luaArgsStart >= 0 ? 1 : 0) != 0, (String)"Method %s has less arguments than declared", (Object[])new Object[]{method});
        boolean isOptional = false;
        ImmutableList.Builder luaArgs = ImmutableList.builder();
        for (arg = 0; arg < declaredLuaArgs.length; ++arg) {
            boolean isLastArg = arg == declaredLuaArgs.length - 1;
            AnnotationMap annotations = new AnnotationMap(argsAnnotations[arg]);
            annotations.put((Annotation)declaredLuaArgs[arg]);
            int javaArgIndex = luaArgsStart + arg;
            ConvertedArgument luaArg = this.createLuaArg(annotations, methodArgs[javaArgIndex], javaArgIndex, isOptional, isLastArg && isVarArg);
            luaArgs.add((Object)luaArg);
            isOptional |= luaArg.isOptional;
        }
        this.luaArgs = luaArgs.build();
        this.javaArgs = ImmutableList.copyOf((Object[])Arrays.copyOf(methodArgs, luaArgsStart));
        for (arg = 0; arg < luaArgsStart; ++arg) {
            AnnotationMap annotations = new AnnotationMap(argsAnnotations[arg]);
            Named named = (Named)annotations.get(Named.class);
            if (named != null) {
                this.namedArgs.put(named.value(), arg);
            }
            Preconditions.checkState((annotations.get(Optionals.class) == null ? 1 : 0) != 0, (String)"@Optionals does not work for java arguments (method %s)", (Object[])new Object[]{method});
        }
    }

    public MethodDeclaration(Method method, LuaCallable meta) {
        this.method = method;
        String luaName = meta.name();
        this.name = "[none set]".equals(luaName) ? method.getName() : luaName;
        this.description = meta.description();
        this.returnTypes = meta.returnTypes();
        this.validateReturn = meta.validateReturn();
        if (this.validateReturn) {
            this.validateResultCount();
        }
        Class<?>[] methodArgs = method.getParameterTypes();
        Annotation[][] argsAnnotations = method.getParameterAnnotations();
        boolean isVarArg = method.isVarArgs();
        ImmutableList.Builder luaArgs = ImmutableList.builder();
        ImmutableList.Builder javaArgs = ImmutableList.builder();
        boolean isInLuaArgs = false;
        boolean isOptional = false;
        for (int i = 0; i < methodArgs.length; ++i) {
            boolean isLastArg = i == methodArgs.length - 1;
            Class<?> cls = methodArgs[i];
            AnnotationMap annotations = new AnnotationMap(argsAnnotations[i]);
            boolean isLuaArg = false;
            Arg tmp = (Arg)annotations.get(Arg.class);
            if (tmp != null) {
                ConvertedArgument luaArg = this.createLuaArg(annotations, cls, i, isOptional, isLastArg && isVarArg);
                luaArgs.add((Object)luaArg);
                isOptional |= luaArg.isOptional;
                isLuaArg = true;
                isInLuaArgs = true;
            }
            Preconditions.checkState((!isInLuaArgs || isLuaArg ? 1 : 0) != 0, (String)"Argument %s in method %s look like Java arg, but is in Lua part (perhaps missing Arg annotation?)", (Object[])new Object[]{i, method});
            Named named = (Named)annotations.get(Named.class);
            if (named != null) {
                Preconditions.checkState((!isInLuaArgs ? 1 : 0) != 0, (String)"Argument %s in method %s is Lua arg, but has Named annotation", (Object[])new Object[]{i, method});
                this.namedArgs.put(named.value(), i);
            }
            Preconditions.checkState((isInLuaArgs || annotations.get(Optionals.class) == null ? 1 : 0) != 0, (String)"@Optionals does not work for java arguments (method %s)", (Object[])new Object[]{method});
            if (isLuaArg) continue;
            javaArgs.add(cls);
        }
        this.luaArgs = luaArgs.build();
        this.javaArgs = javaArgs.build();
    }

    private void validateResultCount() {
        Class<?> javaReturn = this.method.getReturnType();
        int returnLength = this.returnTypes.length;
        for (LuaType t : this.returnTypes) {
            Preconditions.checkArgument((t != LuaType.VOID ? 1 : 0) != 0, (String)"Method '%s' declares Void as return type. Use empty list instead.", (Object[])new Object[]{this.method});
        }
        if (javaReturn == Void.TYPE) {
            Preconditions.checkArgument((returnLength == 0 ? 1 : 0) != 0, (String)"Method '%s' returns nothing, but declares at least one Lua result", (Object[])new Object[]{this.method});
        }
        if (returnLength == 0) {
            Preconditions.checkArgument((javaReturn == Void.TYPE ? 1 : 0) != 0, (String)"Method '%s' returns '%s', but declares no Lua results", (Object[])new Object[]{this.method, javaReturn});
        }
        if (returnLength > 1) {
            Preconditions.checkArgument((javaReturn == IMultiReturn.class ? 1 : 0) != 0, (String)"Method '%s' declared more than one Lua result, but returns single '%s' instead of '%s'", (Object[])new Object[]{this.method, javaReturn, IMultiReturn.class});
        }
    }

    private Object[] validateResult(Object ... result) {
        int i;
        for (i = 0; i < result.length; ++i) {
            result[i] = TypeConversionRegistry.toLua(result[i]);
        }
        if (this.validateReturn) {
            Preconditions.checkArgument((result.length == this.returnTypes.length ? 1 : 0) != 0, (String)"Returning invalid number of values from method %s, expected %s, got %s", (Object[])new Object[]{this.method, this.returnTypes.length, result.length});
            for (i = 0; i < result.length; ++i) {
                LuaType expected = this.returnTypes[i];
                Object got = result[i];
                Preconditions.checkArgument((got == null || expected.getJavaType().isInstance(got) ? 1 : 0) != 0, (String)"Invalid type of return value %s: expected %s, got %s", (Object[])new Object[]{i, expected, got});
            }
        }
        return result;
    }

    public CallWrap createWrapper(Object target) {
        return new CallWrap(target);
    }

    public void nameJavaArg(int index, String name) {
        Preconditions.checkArgument((index < this.javaArgs.size() ? 1 : 0) != 0, (String)"Can't assign name '%s' to argument %s in method '%s'. Possible missing argument or @Freeform?", (Object[])new Object[]{name, index, this.method});
        Integer prev = this.namedArgs.put(name, index);
        Preconditions.checkArgument((prev == null || prev == index ? 1 : 0) != 0, (String)"Trying to replace '%s' mapping from  %s, got %s", (Object[])new Object[]{name, prev, index});
    }

    public void checkJavaArgNames(String ... allowedNames) {
        ImmutableSet allowed = ImmutableSet.copyOf((Object[])allowedNames);
        Sets.SetView unknown = Sets.difference(this.namedArgs.keySet(), (Set)allowed);
        Preconditions.checkState((boolean)unknown.isEmpty(), (String)"Unknown named arg(s) %s in method '%s'. Allowed args: %s", (Object[])new Object[]{unknown, this.method, allowed});
    }

    public void checkJavaArgType(String name, Class<?> cls) {
        Integer index = this.namedArgs.get(name);
        if (index != null) {
            Class<?> expected = this.javaArgs.get(index);
            Preconditions.checkArgument((boolean)expected.isAssignableFrom(cls), (String)"Invalid argument type in method %s, was %s, got %s", (Object[])new Object[]{this.method, expected, cls});
        }
    }

    public void validate() {
        HashSet needed = Sets.newHashSet();
        for (int i = 0; i < this.javaArgs.size(); ++i) {
            needed.add(i);
        }
        HashSet named = Sets.newHashSet(this.namedArgs.values());
        Sets.SetView missing = Sets.difference((Set)needed, (Set)named);
        Preconditions.checkState((boolean)missing.isEmpty(), (String)"Arguments %s from method %s are not named", (Object[])new Object[]{missing, this.method});
        Sets.SetView extra = Sets.difference((Set)named, (Set)needed);
        Preconditions.checkState((boolean)missing.isEmpty(), (String)"Lua arguments %s from method %s are named", (Object[])new Object[]{extra, this.method});
    }

    public Map<String, Object> describe() {
        HashMap result = Maps.newHashMap();
        result.put("name", this.name);
        result.put("description", this.description);
        HashMap tmp = Maps.newHashMap();
        int i = 1;
        for (LuaType t : this.returnTypes) {
            tmp.put(i++, t.toString());
        }
        result.put("returnTypes", tmp);
        tmp = Maps.newHashMap();
        i = 1;
        for (ConvertedArgument arg : this.luaArgs) {
            tmp.put(i++, arg.describe());
        }
        result.put("args", tmp);
        return result;
    }

    public String signature() {
        return this.name + "(" + Joiner.on((String)",").join(this.luaArgs) + ")";
    }

    public class CallWrap
    implements Callable<Object[]> {
        private final Object[] args;
        private final Set<Integer> isSet;
        private final Object target;

        public CallWrap(Object target) {
            this.args = new Object[MethodDeclaration.this.javaArgs.size() + MethodDeclaration.this.luaArgs.size()];
            this.isSet = Sets.newHashSet();
            this.target = target;
        }

        private CallWrap setArg(int position, Object value) {
            boolean newlyAdded = this.isSet.add(position);
            Preconditions.checkState((boolean)newlyAdded, (String)"Trying to set already defined argument %s in method %s", (Object[])new Object[]{position, MethodDeclaration.this.method});
            this.args[position] = value;
            return this;
        }

        public CallWrap setJavaArg(String name, Object value) {
            Integer position = (Integer)MethodDeclaration.this.namedArgs.get(name);
            if (position != null) {
                this.setArg(position, value);
            }
            return this;
        }

        public CallWrap setLuaArgs(Object[] luaValues) {
            int argIndex = 0;
            try {
                for (ConvertedArgument arg : MethodDeclaration.this.luaArgs) {
                    int i;
                    if (arg.isVarArg) {
                        int varargSize = Math.max(0, luaValues.length - argIndex);
                        Object vararg = Array.newInstance(arg.javaType, varargSize);
                        for (int i2 = 0; i2 < varargSize; ++i2) {
                            Object value = luaValues[argIndex++];
                            Preconditions.checkArgument((arg.isNullable || value != null ? 1 : 0) != 0, (String)"Vararg parameter '%s' has null value, but is not marked as nullable", (Object[])new Object[]{arg.name});
                            Object converted = arg.convert(value);
                            Array.set(vararg, i2, converted);
                        }
                        this.setArg(arg.javaArgIndex, vararg);
                        continue;
                    }
                    if ((i = argIndex++) >= luaValues.length) {
                        Preconditions.checkState((boolean)arg.isOptional, (String)"Parameter '%s' is missing", (Object[])new Object[]{arg.name});
                        this.setArg(arg.javaArgIndex, null);
                        continue;
                    }
                    Object value = luaValues[i];
                    Preconditions.checkArgument((arg.isNullable || value != null ? 1 : 0) != 0, (String)"Parameter '%s' has null value, but is not marked as nullable", (Object[])new Object[]{arg.name});
                    this.setArg(arg.javaArgIndex, arg.convert(value));
                }
                Preconditions.checkState((argIndex >= luaValues.length ? 1 : 0) != 0, (String)"Not all lua values used, last index: %s", (Object[])new Object[]{argIndex - 1});
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Log.log((Level)Level.FINE, (Throwable)e, (String)"Trying to access arg index, args = %s", (Object[])new Object[]{Arrays.toString(luaValues)});
                throw new IllegalArgumentException(String.format("Invalid Lua parameter count, needs %s, got %s", MethodDeclaration.this.luaArgs.size(), luaValues.length));
            }
            return this;
        }

        @Override
        public Object[] call() throws Exception {
            for (int i = 0; i < this.args.length; ++i) {
                Preconditions.checkState((boolean)this.isSet.contains(i), (String)"Parameter %s value not set", (Object[])new Object[]{i});
            }
            Object result = MethodDeclaration.this.method.invoke(this.target, this.args);
            if (result instanceof IMultiReturn) {
                return MethodDeclaration.this.validateResult(((IMultiReturn)result).getObjects());
            }
            if (result == null) {
                return MethodDeclaration.this.validateResult(new Object[0]);
            }
            return MethodDeclaration.this.validateResult(new Object[]{result});
        }
    }

    public static class ConvertedArgument {
        public final String name;
        public final String description;
        public final LuaType luaType;
        public final Class<?> javaType;
        public final boolean isVarArg;
        private final boolean isNullable;
        private final boolean isOptional;
        private final int javaArgIndex;

        private ConvertedArgument(Arg arg, Class<?> javaClass, int javaArgIndex, boolean isVarArg, boolean isOptional) {
            this.name = arg.name();
            this.description = arg.description();
            this.luaType = arg.type();
            this.javaType = isVarArg ? javaClass.getComponentType() : javaClass;
            this.isVarArg = isVarArg;
            this.isOptional = isOptional;
            this.isNullable = arg.isNullable() || isOptional;
            this.javaArgIndex = javaArgIndex;
        }

        public Object convert(Object o) {
            if (o == null) {
                return null;
            }
            Object converted = TypeConversionRegistry.fromLua(o, this.javaType);
            Preconditions.checkNotNull((Object)converted, (String)"Failed to convert arg '%s' value '%s' to '%s'", (Object[])new Object[]{this.name, o, this.javaType.getSimpleName()});
            return converted;
        }

        public Map<String, Object> describe() {
            HashMap result = Maps.newHashMap();
            result.put("type", this.luaType.toString());
            result.put("name", this.name);
            result.put("description", this.description);
            result.put("vararg", this.isVarArg);
            result.put("optional", this.isOptional);
            result.put("nullable", this.isNullable);
            return result;
        }

        public String toString() {
            return this.isVarArg ? this.name + "..." : this.name;
        }
    }
}

