/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Map;
import openperipheral.adapter.IMethodExecutor;
import openperipheral.adapter.MethodDeclaration;
import openperipheral.api.Freeform;
import openperipheral.api.LuaCallable;
import openperipheral.api.LuaMethod;
import openperipheral.api.Prefixed;

public abstract class AdapterWrapper<E extends IMethodExecutor> {
    public final Map<String, E> methods;
    public final Class<?> targetCls;
    public final Class<?> adapterClass;

    protected static boolean isFreeform(AnnotatedElement element, boolean defaultValue) {
        Freeform freeform = element.getAnnotation(Freeform.class);
        return freeform != null ? freeform.value() : defaultValue;
    }

    protected AdapterWrapper(Class<?> adapterClass, Class<?> targetClass) {
        this.adapterClass = adapterClass;
        this.targetCls = targetClass;
        this.methods = ImmutableMap.copyOf(this.buildMethodMap());
    }

    protected abstract Map<String, E> buildMethodMap();

    protected void namesFromAnnotation(Prefixed prefixes, MethodDeclaration decl) {
        int i = 0;
        for (String name : prefixes.value()) {
            decl.nameJavaArg(i++, name);
        }
    }

    protected abstract void validateArgTypes(MethodDeclaration var1);

    protected abstract void nameDefaultParameters(MethodDeclaration var1);

    protected MethodDeclaration createDeclaration(Method method) {
        LuaMethod methodAnn = method.getAnnotation(LuaMethod.class);
        if (methodAnn != null) {
            return new MethodDeclaration(method, methodAnn);
        }
        LuaCallable callableAnn = method.getAnnotation(LuaCallable.class);
        if (callableAnn != null) {
            return new MethodDeclaration(method, callableAnn);
        }
        return null;
    }

    protected Map<String, E> buildMethodMap(boolean defaultIsFreeform, MethodExecutorFactory<E> factory) {
        ImmutableMap.Builder methods = ImmutableMap.builder();
        boolean clsIsFreeform = AdapterWrapper.isFreeform(this.adapterClass, defaultIsFreeform);
        Prefixed prefixes = this.adapterClass.getAnnotation(Prefixed.class);
        for (Method method : this.adapterClass.getMethods()) {
            MethodDeclaration decl = this.createDeclaration(method);
            if (decl == null) continue;
            E exec = factory.createExecutor(method, decl);
            if (!AdapterWrapper.isFreeform(method, clsIsFreeform)) {
                if (prefixes == null) {
                    this.nameDefaultParameters(decl);
                } else {
                    this.namesFromAnnotation(prefixes, decl);
                }
            }
            decl.validate();
            this.validateArgTypes(decl);
            methods.put((Object)decl.name, exec);
        }
        return methods.build();
    }

    protected static interface MethodExecutorFactory<E extends IMethodExecutor> {
        public E createExecutor(Method var1, MethodDeclaration var2);
    }
}

