/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import dan200.computer.api.ComputerCraftAPI;
import dan200.computer.api.IHostedPeripheral;
import dan200.computer.api.ILuaObject;
import dan200.computer.api.IPeripheralHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.tileentity.TileEntity;
import openmods.Log;
import openperipheral.adapter.AdaptedClass;
import openperipheral.adapter.AdapterWrapper;
import openperipheral.adapter.IMethodExecutor;
import openperipheral.adapter.object.IObjectMethodExecutor;
import openperipheral.adapter.object.LuaObjectWrapper;
import openperipheral.adapter.object.ObjectAdaptedClass;
import openperipheral.adapter.object.ObjectAdapterWrapper;
import openperipheral.adapter.peripheral.HostedPeripheral;
import openperipheral.adapter.peripheral.IPeripheralMethodExecutor;
import openperipheral.adapter.peripheral.PeripheralAdaptedClass;
import openperipheral.adapter.peripheral.PeripheralExternalAdapterWrapper;
import openperipheral.adapter.peripheral.PeripheralInlineAdapterWrapper;
import openperipheral.api.IAdapterBase;
import openperipheral.api.IObjectAdapter;
import openperipheral.api.IPeripheralAdapter;
import openperipheral.api.IPeripheralProvider;
import openperipheral.util.PeripheralUtils;

public abstract class AdapterManager<A extends IAdapterBase, E extends IMethodExecutor> {
    private static final IPeripheralHandler peripheralHandler = new IPeripheralHandler(){
        private Map<TileEntity, IHostedPeripheral> created = new WeakHashMap<TileEntity, IHostedPeripheral>();

        public IHostedPeripheral getPeripheral(TileEntity tile) {
            if (tile == null) {
                return null;
            }
            IHostedPeripheral peripheral = this.created.get(tile);
            if (peripheral == null) {
                if (tile instanceof IPeripheralProvider) {
                    peripheral = ((IPeripheralProvider)tile).providePeripheral(tile.field_70331_k);
                } else {
                    AdaptedClass<IPeripheralMethodExecutor> adapter = peripherals.adaptClass(tile.getClass());
                    peripheral = new HostedPeripheral(adapter, tile);
                }
                this.created.put(tile, peripheral);
            }
            return peripheral;
        }
    };
    public static final AdapterManager<IObjectAdapter, IObjectMethodExecutor> objects = new AdapterManager<IObjectAdapter, IObjectMethodExecutor>(){

        @Override
        protected AdaptedClass<IObjectMethodExecutor> adaptClass(Class<?> targetClass) {
            return new ObjectAdaptedClass(this, targetClass);
        }

        @Override
        protected AdapterWrapper<IObjectMethodExecutor> wrapExternalAdapter(IObjectAdapter adapter) {
            return new ObjectAdapterWrapper.External(adapter);
        }

        @Override
        protected AdapterWrapper<IObjectMethodExecutor> wrapInlineAdapter(Class<?> targetClass) {
            return new ObjectAdapterWrapper.Inline(targetClass);
        }
    };
    public static final AdapterManager<IPeripheralAdapter, IPeripheralMethodExecutor> peripherals = new AdapterManager<IPeripheralAdapter, IPeripheralMethodExecutor>(){

        @Override
        protected AdaptedClass<IPeripheralMethodExecutor> adaptClass(Class<?> targetClass) {
            return new PeripheralAdaptedClass(this, targetClass);
        }

        @Override
        protected AdapterWrapper<IPeripheralMethodExecutor> wrapExternalAdapter(IPeripheralAdapter adapter) {
            return new PeripheralExternalAdapterWrapper(adapter);
        }

        @Override
        protected AdapterWrapper<IPeripheralMethodExecutor> wrapInlineAdapter(Class<?> targetClass) {
            return new PeripheralInlineAdapterWrapper(targetClass);
        }
    };
    private final Multimap<Class<?>, AdapterWrapper<E>> externalAdapters = HashMultimap.create();
    private final Map<Class<?>, AdapterWrapper<E>> internalAdapters = Maps.newHashMap();
    private final Map<Class<?>, AdaptedClass<E>> classes = Maps.newHashMap();

    public static void addObjectAdapter(IObjectAdapter adapter) {
        objects.addAdapter(adapter);
    }

    public static void addPeripheralAdapter(IPeripheralAdapter adapter) {
        peripherals.addAdapter(adapter);
    }

    public static void addInlinePeripheralAdapter(Class<?> cls) {
        peripherals.addInlineAdapter(cls);
    }

    public static void registerPeripherals() {
        Map<Class<? extends TileEntity>, String> classToNameMap = PeripheralUtils.getClassToNameMap();
        Set<Class<?>> classesWithAdapters = super.getAllClasses();
        block0: for (Map.Entry<Class<? extends TileEntity>, String> e : classToNameMap.entrySet()) {
            Class<? extends TileEntity> teClass = e.getKey();
            if (teClass == null) {
                Log.warn((String)"TE with id %s has null key", (Object[])new Object[]{e.getValue()});
                continue;
            }
            if (IPeripheralProvider.class.isAssignableFrom(teClass)) {
                ComputerCraftAPI.registerExternalPeripheral(teClass, (IPeripheralHandler)peripheralHandler);
                continue;
            }
            for (Class<? extends TileEntity> clazz : classesWithAdapters) {
                if (!clazz.isAssignableFrom(teClass)) continue;
                ComputerCraftAPI.registerExternalPeripheral(teClass, (IPeripheralHandler)peripheralHandler);
                continue block0;
            }
        }
    }

    private Set<Class<?>> getAllClasses() {
        return Sets.union((Set)this.externalAdapters.keySet(), this.internalAdapters.keySet());
    }

    public void addAdapter(A adapter) {
        AdapterWrapper<E> wrapper;
        try {
            wrapper = this.wrapExternalAdapter(adapter);
        }
        catch (Throwable e) {
            Log.warn((Throwable)e, (String)"Something went terribly wrong while adding adapter '%s'. It will be disabled", (Object[])new Object[]{adapter.getClass()});
            return;
        }
        Class<?> targetCls = wrapper.targetCls;
        Preconditions.checkArgument((!Object.class.equals(wrapper.targetCls) ? 1 : 0) != 0, (Object)"Can't add adapter for Object class");
        Log.info((String)"Registering adapter %s for class %s", (Object[])new Object[]{wrapper.adapterClass, targetCls});
        this.externalAdapters.put(wrapper.targetCls, wrapper);
    }

    public void addInlineAdapter(Class<?> targetCls) {
        AdapterWrapper<E> wrapper = this.wrapInlineAdapter(targetCls);
        Log.info((String)"Registering auto-created adapter for class %s", (Object[])new Object[]{targetCls});
        this.internalAdapters.put(targetCls, wrapper);
    }

    public AdaptedClass<E> getAdapterClass(Class<?> targetCls) {
        AdaptedClass<E> value = this.classes.get(targetCls);
        if (value == null) {
            value = this.adaptClass(targetCls);
            this.classes.put(targetCls, value);
        }
        return value;
    }

    Collection<AdapterWrapper<E>> getExternalAdapters(Class<?> targetCls) {
        return Collections.unmodifiableCollection(this.externalAdapters.get(targetCls));
    }

    AdapterWrapper<E> getInlineAdapter(Class<?> targetCls) {
        AdapterWrapper<E> wrapper = this.internalAdapters.get(targetCls);
        if (wrapper == null) {
            wrapper = this.wrapInlineAdapter(targetCls);
            this.internalAdapters.put(targetCls, wrapper);
        }
        return wrapper;
    }

    protected abstract AdaptedClass<E> adaptClass(Class<?> var1);

    protected abstract AdapterWrapper<E> wrapExternalAdapter(A var1);

    protected abstract AdapterWrapper<E> wrapInlineAdapter(Class<?> var1);

    public static ILuaObject wrapObject(Object o) {
        return LuaObjectWrapper.wrap(objects, o);
    }

    public static HostedPeripheral createHostedPeripheral(Object target) {
        AdaptedClass<IPeripheralMethodExecutor> adapter = peripherals.adaptClass(target.getClass());
        return new HostedPeripheral(adapter, target);
    }
}

