/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import openmods.Log;
import openperipheral.adapter.AdapterManager;
import openperipheral.adapter.AdapterWrapper;
import openperipheral.adapter.IMethodExecutor;
import openperipheral.adapter.MethodDeclaration;
import openperipheral.api.LuaCallable;
import openperipheral.api.LuaType;

public abstract class AdaptedClass<E extends IMethodExecutor> {
    private final Map<String, E> methodsByName;
    private final Map<Integer, E> methodsByIndex;
    public final String[] methodNames;

    protected AdaptedClass(AdapterManager<?, E> manager, Class<?> cls) {
        this.methodsByName = this.collectAdaptersMethods(manager, cls);
        ImmutableMap.Builder methodsByIndex = ImmutableMap.builder();
        this.methodNames = new String[this.methodsByName.size()];
        int id = 0;
        for (Map.Entry<String, E> e : this.methodsByName.entrySet()) {
            this.methodNames[id] = e.getKey();
            methodsByIndex.put((Object)id++, e.getValue());
        }
        this.methodsByIndex = methodsByIndex.build();
    }

    private Map<String, E> collectAdaptersMethods(AdapterManager<?, E> manager, Class<?> cls) {
        TreeMap result = Maps.newTreeMap();
        List classHierarchy = Lists.reverse(AdaptedClass.listSuperClasses(cls));
        HashSet allSuperInterfaces = Sets.newHashSet();
        for (Class c : classHierarchy) {
            allSuperInterfaces.addAll(AdaptedClass.listSuperInterfaces(c));
        }
        for (Class c : allSuperInterfaces) {
            AdaptedClass.addExternalAdapters(manager, result, c);
        }
        for (Class c : classHierarchy) {
            AdaptedClass.addExternalAdapters(manager, result, c);
            AdaptedClass.addInlineAdapter(manager, result, c);
        }
        AdditionalHelperMethods helper = new AdditionalHelperMethods();
        for (Method method : AdditionalHelperMethods.class.getMethods()) {
            LuaCallable callableMeta = method.getAnnotation(LuaCallable.class);
            if (callableMeta == null) continue;
            MethodDeclaration decl = new MethodDeclaration(method, callableMeta);
            result.put(decl.name, this.createDummyWrapper(helper, decl));
        }
        return ImmutableMap.copyOf((Map)result);
    }

    private static <E extends IMethodExecutor> void addExternalAdapters(AdapterManager<?, E> manager, Map<String, E> result, Class<?> cls) {
        for (AdapterWrapper<E> wrapper : manager.getExternalAdapters(cls)) {
            AdaptedClass.addAdapterMethods(result, wrapper);
        }
    }

    private static <E extends IMethodExecutor> void addInlineAdapter(AdapterManager<?, E> manager, Map<String, E> result, Class<?> cls) {
        AdapterWrapper<E> wrapper = manager.getInlineAdapter(cls);
        AdaptedClass.addAdapterMethods(result, wrapper);
    }

    private static <E extends IMethodExecutor> void addAdapterMethods(Map<String, E> result, AdapterWrapper<E> wrapper) {
        for (Map.Entry e : wrapper.methods.entrySet()) {
            String name = e.getKey();
            IMethodExecutor previous = (IMethodExecutor)result.put(name, e.getValue());
            if (previous == null) continue;
            Log.info((String)"Previous defininition of Lua method '%s' overwritten by adapter %s", (Object[])new Object[]{name, wrapper.adapterClass});
        }
    }

    public E getMethod(int index) {
        return (E)((IMethodExecutor)this.methodsByIndex.get(index));
    }

    public Collection<E> getMethods() {
        return Collections.unmodifiableCollection(this.methodsByIndex.values());
    }

    private static List<Class<?>> listSuperClasses(Class<?> cls) {
        ArrayList superClasses = Lists.newArrayList();
        for (Class<?> currentClass = cls; currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            superClasses.add(currentClass);
        }
        return superClasses;
    }

    private static Set<Class<?>> listSuperInterfaces(Class<?> cls) {
        Class currentClass;
        HashSet superInterfaces = Sets.newHashSet();
        LinkedList tbd = Lists.newLinkedList();
        tbd.addAll(Arrays.asList(cls.getInterfaces()));
        while ((currentClass = (Class)tbd.poll()) != null) {
            superInterfaces.add(currentClass);
            tbd.addAll(Arrays.asList(currentClass.getInterfaces()));
        }
        return superInterfaces;
    }

    protected abstract E createDummyWrapper(Object var1, MethodDeclaration var2);

    private class AdditionalHelperMethods {
        private AdditionalHelperMethods() {
        }

        @LuaCallable(returnTypes={LuaType.STRING}, description="List all the methods available")
        public String listMethods() {
            ArrayList info = Lists.newArrayList();
            for (IMethodExecutor e : AdaptedClass.this.methodsByName.values()) {
                MethodDeclaration m = e.getWrappedMethod();
                info.add(m.signature());
            }
            return Joiner.on((String)", ").join((Iterable)info);
        }

        @LuaCallable(returnTypes={LuaType.TABLE}, description="Get a complete table of information about all available methods")
        public Map<?, ?> getAdvancedMethodsData() {
            HashMap info = Maps.newHashMap();
            for (IMethodExecutor e : AdaptedClass.this.methodsByName.values()) {
                MethodDeclaration m = e.getWrappedMethod();
                info.put(m.name, m.describe());
            }
            return info;
        }
    }
}

