/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.api;

import codechicken.core.CommonUtils;
import codechicken.core.featurehack.GameDataManipulator;
import codechicken.core.inventory.ItemKey;
import codechicken.lib.lang.LangUtil;
import codechicken.nei.InfiniteStackSizeHandler;
import codechicken.nei.InfiniteToolHandler;
import codechicken.nei.ItemMobSpawner;
import codechicken.nei.MultiItemRange;
import codechicken.nei.PopupInputHandler;
import codechicken.nei.SpawnerRenderer;
import codechicken.nei.api.API;
import codechicken.nei.api.IHighlightHandler;
import codechicken.nei.api.IInfiniteItemHandler;
import codechicken.nei.config.ArrayDumper;
import codechicken.nei.config.ItemPanelDumper;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.recipe.BrewingRecipeHandler;
import codechicken.nei.recipe.RecipeItemInputHandler;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.ItemData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.IShearable;

public class ItemInfo {
    public static final HashMap<Layout, ArrayList<IHighlightHandler>> highlightHandlers = new HashMap();
    public static final HashMap<ItemKey, String> fallbackNames = new HashMap();
    public static final HashSet<Integer> excludeIds = new HashSet();
    public static final HashSet<Integer> nonUnlimitedIds = new HashSet();
    public static final HashMap<Integer, ArrayList<int[]>> damageVariants = new HashMap();
    public static final ArrayList<int[]> defaultDamageRange = new ArrayList();
    public static final HashMap<Integer, ArrayList<ye>> itemcompounds = new HashMap();
    public static final LinkedList<IInfiniteItemHandler> infiniteHandlers = new LinkedList();
    public static final HashMap<Integer, ArrayList<IHighlightHandler>> highlightIdentifiers = new HashMap();
    public static final HashSet<Class<? extends we>> fastTransferExemptions = new HashSet();
    public static final String[] itemOwners = new String[yc.g.length];

    static {
        Layout[] layoutArray = Layout.values();
        int n = layoutArray.length;
        int n2 = 0;
        while (n2 < n) {
            Layout layout = layoutArray[n2];
            highlightHandlers.put(layout, new ArrayList());
            ++n2;
        }
    }

    public static boolean isHidden(int itemID) {
        return excludeIds.contains(itemID);
    }

    public static ArrayList<int[]> getItemDamageVariants(int itemID) {
        ArrayList<int[]> damages = damageVariants.get(itemID);
        return damages == null ? defaultDamageRange : damages;
    }

    public static String getOverrideName(int itemID, int itemDamage) {
        ItemKey itemhash = new ItemKey(itemID, itemDamage);
        return fallbackNames.get(itemhash);
    }

    public static boolean canItemBeUnlimited(int itemID) {
        return !nonUnlimitedIds.contains(itemID);
    }

    public static ArrayList<ye> getItemCompounds(int itemID) {
        return itemcompounds.get(itemID);
    }

    public static void load(abw world) {
        int[] nArray = new int[2];
        nArray[1] = 15;
        defaultDamageRange.add(nArray);
        ItemInfo.addVanillaBlockProperties();
        ItemInfo.addDefaultDropDowns();
        ItemInfo.searchItems();
        ItemInfo.parseModItems();
        ItemInfo.addMobSpawnerItem(world);
        ItemInfo.addSpawnEggs();
        new BrewingRecipeHandler().searchPotions();
        ItemInfo.addInfiniteHandlers();
        ItemInfo.addInputHandlers();
        ItemInfo.addIDDumps();
    }

    private static void addIDDumps() {
        API.addOption(new ArrayDumper<yc>("tools.dump.item"){

            @Override
            public String[] header() {
                return new String[]{"ID", "Block/Item", "Mod", "Unlocalised name", "Class"};
            }

            @Override
            public String[] dump(int i, yc item) {
                aqz block = i < aqz.s.length ? aqz.s[i] : null;
                return new String[]{Integer.toString(i), block != null ? "Block" : "Item", itemOwners[i], block != null ? block.a() : item.a(), (block != null ? block : item).getClass().getCanonicalName()};
            }

            public yc[] array() {
                return yc.g;
            }
        });
        API.addOption(new ArrayDumper<ni>("tools.dump.potion"){

            @Override
            public String[] header() {
                return new String[]{"ID", "Unlocalised name", "Class"};
            }

            @Override
            public String[] dump(int i, ni potion) {
                return new String[]{Integer.toString(i), potion.a(), potion.getClass().getCanonicalName()};
            }

            public ni[] array() {
                return ni.a;
            }
        });
        API.addOption(new ArrayDumper<aau>("tools.dump.enchantment"){

            @Override
            public String[] header() {
                return new String[]{"ID", "Unlocalised name", "Type", "Min Level", "Max Level", "Class"};
            }

            @Override
            public String[] dump(int i, aau ench) {
                return new String[]{Integer.toString(i), ench.a(), ench.A.toString(), Integer.toString(ench.d()), Integer.toString(ench.b()), ench.getClass().getCanonicalName()};
            }

            public aau[] array() {
                return aau.b;
            }
        });
        API.addOption(new ArrayDumper<acq>("tools.dump.biome"){

            @Override
            public String[] header() {
                return new String[]{"ID", "Name", "Temperature", "Rainfall", "Spawn Chance", "Min Height", "Max Height", "Types", "Class"};
            }

            @Override
            public String[] dump(int i, acq biome) {
                BiomeDictionary.Type[] types = BiomeDictionary.getTypesForBiome((acq)biome);
                StringBuilder s_types = new StringBuilder();
                BiomeDictionary.Type[] typeArray = types;
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    BiomeDictionary.Type t = typeArray[n2];
                    if (s_types.length() > 0) {
                        s_types.append(", ");
                    }
                    s_types.append(t.name());
                    ++n2;
                }
                return new String[]{Integer.toString(i), biome.y, Float.toString(biome.j()), Float.toString(biome.i()), Float.toString(biome.f()), Float.toString(biome.D), Float.toString(biome.E), s_types.toString(), biome.getClass().getCanonicalName()};
            }

            public acq[] array() {
                return acq.a;
            }
        });
        API.addOption(new ItemPanelDumper("tools.dump.itempanel"));
    }

    private static void parseModItems() {
        cg itemDataList = new cg();
        GameData.writeItemData((cg)itemDataList);
        HashMap<String, MultiItemRange> modRangeMap = new HashMap<String, MultiItemRange>();
        int i = 0;
        while (i < itemDataList.c()) {
            ItemData itemData = new ItemData((by)itemDataList.b(i));
            MultiItemRange itemRange = (MultiItemRange)modRangeMap.get(itemData.getModId());
            if (itemRange == null) {
                itemRange = new MultiItemRange();
                modRangeMap.put(itemData.getModId(), itemRange);
            }
            ItemInfo.itemOwners[itemData.getItemId()] = itemData.getModId();
            itemRange.add(itemData.getItemId());
            ++i;
        }
        for (Map.Entry entry : modRangeMap.entrySet()) {
            String modID = (String)entry.getKey();
            ModContainer mod = CommonUtils.findModContainer((String)modID);
            String modname = mod == null ? modID : mod.getName();
            API.addSetRange("Mod." + modname, (MultiItemRange)entry.getValue());
        }
    }

    private static void addInputHandlers() {
        GuiContainerManager.addInputHandler(new RecipeItemInputHandler());
        GuiContainerManager.addInputHandler(new PopupInputHandler());
    }

    private static void addMobSpawnerItem(final abw world) {
        yc.g[aqz.ax.cF] = null;
        GameDataManipulator.createHiddenItem((Runnable)new Runnable(){

            @Override
            public void run() {
                new ItemMobSpawner(world);
            }
        });
        MinecraftForgeClient.registerItemRenderer((int)aqz.ax.cF, (IItemRenderer)new SpawnerRenderer());
    }

    private static void addInfiniteHandlers() {
        API.addInfiniteItemHandler(new InfiniteStackSizeHandler());
        API.addInfiniteItemHandler(new InfiniteToolHandler());
    }

    private static void addVanillaBlockProperties() {
        API.setOverrideName(aqz.F.cF, 0, "Water Source");
        API.setMaxDamageException(aqz.F.cF, 0);
        API.setOverrideName(aqz.G.cF, 0, "Water Still");
        API.setMaxDamageException(aqz.G.cF, 0);
        API.setOverrideName(aqz.H.cF, 0, "Lava Source");
        API.setMaxDamageException(aqz.H.cF, 0);
        API.setOverrideName(aqz.I.cF, 0, "Lava Still");
        API.setMaxDamageException(aqz.I.cF, 0);
        API.setOverrideName(aqz.bq.cF, 0, "Silverfish Stone");
        API.setOverrideName(aqz.bM.cF, 0, "End Portal");
        API.setOverrideName(aqz.bN.cF, 0, "End Portal Frame");
        API.hideItem(aqz.af.cF);
        API.hideItem(aqz.ah.cF);
        API.hideItem(aqz.by.cF);
        API.hideItem(aqz.bx.cF);
        API.hideItem(aqz.X.cF);
        API.hideItem(aqz.aA.cF);
        API.hideItem(aqz.aE.cF);
        API.hideItem(aqz.aI.cF);
        API.hideItem(aqz.aJ.cF);
        API.hideItem(aqz.aN.cF);
        API.hideItem(aqz.aQ.cF);
        API.hideItem(aqz.aT.cF);
        API.hideItem(aqz.aU.cF);
        API.hideItem(aqz.bc.cF);
        API.hideItem(aqz.bm.cF);
        API.hideItem(aqz.bn.cF);
        API.hideItem(aqz.bL.cF);
        API.hideItem(aqz.bI.cF);
        API.hideItem(aqz.bK.cF);
        API.hideItem(aqz.aH.cF);
        API.hideItem(aqz.bR.cF);
        API.hideItem(aqz.ch.cF);
        API.hideItem(aqz.ci.cF);
        API.hideItem(aqz.cj.cF);
        API.hideItem(aqz.cl.cF);
        API.hideItem(aqz.bZ.cF);
    }

    private static void addDefaultDropDowns() {
        API.addSetRange("Blocks", new MultiItemRange("[0-32000]"){

            @Override
            public void addItemIfInRange(int item, int damage, by compound) {
                if (item < aqz.s.length && aqz.s[item] != null && aqz.s[item].cU != akc.a) {
                    super.addItemIfInRange(item, damage, compound);
                }
            }
        });
        API.addSetRange("Items", new MultiItemRange("[0-32000]"){

            @Override
            public void addItemIfInRange(int item, int damage, by compound) {
                if (item >= aqz.s.length || aqz.s[item] == null || aqz.s[item].cU == akc.a) {
                    super.addItemIfInRange(item, damage, compound);
                }
            }
        });
        API.addSetRange("Blocks.MobSpawners", new MultiItemRange("[52]"));
    }

    private static void searchItems() {
        ww tab;
        MultiItemRange tools = new MultiItemRange();
        MultiItemRange picks = new MultiItemRange();
        MultiItemRange shovels = new MultiItemRange();
        MultiItemRange axes = new MultiItemRange();
        MultiItemRange hoes = new MultiItemRange();
        MultiItemRange swords = new MultiItemRange();
        MultiItemRange chest = new MultiItemRange();
        MultiItemRange helmets = new MultiItemRange();
        MultiItemRange legs = new MultiItemRange();
        MultiItemRange boots = new MultiItemRange();
        MultiItemRange other = new MultiItemRange();
        MultiItemRange ranged = new MultiItemRange();
        MultiItemRange food = new MultiItemRange();
        MultiItemRange potioningredients = new MultiItemRange();
        MultiItemRange[] creativeTabRanges = new MultiItemRange[ww.a.length];
        ww[] wwArray = ww.a;
        int n = ww.a.length;
        int n2 = 0;
        while (n2 < n) {
            tab = wwArray[n2];
            creativeTabRanges[tab.a()] = new MultiItemRange();
            ++n2;
        }
        wwArray = yc.g;
        n = yc.g.length;
        n2 = 0;
        while (n2 < n) {
            ww item = wwArray[n2];
            if (item != null) {
                ww itemTab = item.y();
                if (itemTab != null) {
                    creativeTabRanges[itemTab.a()].add((yc)item);
                }
                if (item.p()) {
                    tools.add((yc)item);
                    if (item instanceof yn) {
                        picks.add((yc)item);
                    } else if (item instanceof yy) {
                        shovels.add((yc)item);
                    } else if (item instanceof ya) {
                        axes.add((yc)item);
                    } else if (item instanceof yb) {
                        hoes.add((yc)item);
                    } else if (item instanceof zl) {
                        swords.add((yc)item);
                    } else if (item instanceof wh) {
                        switch (((wh)item).b) {
                            case 0: {
                                helmets.add((yc)item);
                                break;
                            }
                            case 1: {
                                chest.add((yc)item);
                                break;
                            }
                            case 2: {
                                legs.add((yc)item);
                                break;
                            }
                            case 3: {
                                boots.add((yc)item);
                            }
                        }
                    } else if (item == yc.n || item == yc.m) {
                        ranged.add((yc)item);
                    } else if (item == yc.aT || item == yc.k || item == yc.bg) {
                        other.add((yc)item);
                    }
                }
                if (item instanceof xx) {
                    food.add((yc)item);
                }
                if (item.x()) {
                    BrewingRecipeHandler.ingredientIDs.add(item.cv);
                    potioningredients.add((yc)item);
                }
            }
            ++n2;
        }
        API.addSetRange("Items.Tools.Pickaxes", picks);
        API.addSetRange("Items.Tools.Shovels", shovels);
        API.addSetRange("Items.Tools.Axes", axes);
        API.addSetRange("Items.Tools.Hoes", hoes);
        API.addSetRange("Items.Tools.Other", other);
        API.addSetRange("Items.Weapons.Swords", swords);
        API.addSetRange("Items.Weapons.Ranged", ranged);
        API.addSetRange("Items.Armor.ChestPlates", chest);
        API.addSetRange("Items.Armor.Leggings", legs);
        API.addSetRange("Items.Armor.Helmets", helmets);
        API.addSetRange("Items.Armor.Boots", boots);
        API.addSetRange("Items.Food", food);
        API.addSetRange("Items.Potions.Ingredients", potioningredients);
        wwArray = ww.a;
        n = ww.a.length;
        n2 = 0;
        while (n2 < n) {
            tab = wwArray[n2];
            if (creativeTabRanges[tab.a()].ranges.size() > 0) {
                API.addSetRange("CreativeTabs." + LangUtil.translateG((String)tab.c(), (Object[])new Object[0]), creativeTabRanges[tab.a()]);
            }
            ++n2;
        }
    }

    private static void addSpawnEggs() {
        ArrayList<Integer> damages = new ArrayList<Integer>();
        try {
            HashMap classToIDMapping = (HashMap)nt.e;
            damages.add((Integer)classToIDMapping.get(rw.class));
            damages.add((Integer)classToIDMapping.get(tr.class));
            damages.add((Integer)classToIDMapping.get(tf.class));
            damages.add((Integer)classToIDMapping.get(ts.class));
            damages.add((Integer)classToIDMapping.get(tw.class));
            damages.add((Integer)classToIDMapping.get(tt.class));
            damages.add((Integer)classToIDMapping.get(rq.class));
            damages.add((Integer)classToIDMapping.get(te.class));
            damages.add((Integer)classToIDMapping.get(rr.class));
            damages.add((Integer)classToIDMapping.get(tg.class));
            damages.add((Integer)classToIDMapping.get(sf.class));
            damages.add((Integer)classToIDMapping.get(tn.class));
            damages.add((Integer)classToIDMapping.get(sc.class));
            damages.add((Integer)classToIDMapping.get(tj.class));
            damages.add((Integer)classToIDMapping.get(tl.class));
            damages.add((Integer)classToIDMapping.get(rz.class));
            damages.add((Integer)classToIDMapping.get(td.class));
            damages.add((Integer)classToIDMapping.get(ub.class));
            damages.add((Integer)classToIDMapping.get(tq.class));
            damages.add((Integer)classToIDMapping.get(ry.class));
            damages.add((Integer)classToIDMapping.get(rx.class));
            ItemInfo.addEntityEgg(damages, (Integer)classToIDMapping.get(sb.class), 0xEEFFFF, 16753185);
            ItemInfo.addEntityEgg(damages, (Integer)classToIDMapping.get(sd.class), 12960449, 16769484);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        API.setItemDamageVariants(yc.bE.cv, damages);
    }

    private static void addEntityEgg(ArrayList<Integer> damages, Integer ID, int i, int j) {
        damages.add(ID);
        nt.a.put(ID, new nu(ID.intValue(), i, j));
    }

    public static ArrayList<ye> getIdentifierItems(abw world, uf player, ata hit) {
        IShearable shearable;
        int x = hit.b;
        int y = hit.c;
        int z = hit.d;
        aqz mouseoverBlock = aqz.s[world.a(x, y, z)];
        ArrayList<ye> items = new ArrayList<ye>();
        ArrayList handlers = new ArrayList();
        if (highlightIdentifiers.get(0) != null) {
            handlers.addAll(highlightIdentifiers.get(0));
        }
        if (highlightIdentifiers.get(mouseoverBlock.cF) != null) {
            handlers.addAll(highlightIdentifiers.get(mouseoverBlock.cF));
        }
        for (IHighlightHandler ident : handlers) {
            ye item = ident.identifyHighlight(world, player, hit);
            if (item == null) continue;
            items.add(item);
        }
        if (items.size() > 0) {
            return items;
        }
        ye pick = mouseoverBlock.getPickBlock(hit, world, x, y, z);
        if (pick != null) {
            items.add(pick);
        }
        try {
            items.addAll(mouseoverBlock.getBlockDropped(world, x, y, z, world.h(x, y, z), 0));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (mouseoverBlock instanceof IShearable && (shearable = (IShearable)mouseoverBlock).isShearable(new ye((yc)yc.bg), world, x, y, z)) {
            items.addAll(shearable.onSheared(new ye((yc)yc.bg), world, x, y, z, 0));
        }
        if (items.size() == 0) {
            items.add(0, new ye(mouseoverBlock, 1, world.h(x, y, z)));
        }
        return items;
    }

    public static void registerHighlightHandler(IHighlightHandler handler, Layout ... layouts) {
        Layout[] layoutArray = layouts;
        int n = layouts.length;
        int n2 = 0;
        while (n2 < n) {
            Layout layout = layoutArray[n2];
            highlightHandlers.get((Object)layout).add(handler);
            ++n2;
        }
    }

    public static List<String> getText(ye itemStack, abw world, uf player, ata mop) {
        List<String> retString = new ArrayList<String>();
        Layout[] layoutArray = Layout.values();
        int n = layoutArray.length;
        int n2 = 0;
        while (n2 < n) {
            Layout layout = layoutArray[n2];
            for (IHighlightHandler handler : highlightHandlers.get((Object)layout)) {
                retString = handler.handleTextData(itemStack, world, player, mop, retString, layout);
            }
            ++n2;
        }
        return retString;
    }

    public static enum Layout {
        HEADER,
        BODY,
        FOOTER;

    }
}

