/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class TMIUninstaller {
    private static File jarFile;
    public static InstallerGui mainframe;

    public static void main(String[] args) {
        jarFile = new File(args[0]);
        InstallerGui.installLnF();
        mainframe = new InstallerGui();
        mainframe.setDefaultCloseOperation(3);
        mainframe.setLocationRelativeTo(null);
        mainframe.pack();
        mainframe.setVisible(true);
        if (!jarFile.exists()) {
            mainframe.getLabelInfo().setText("Invalid Minecraft.jar");
        } else {
            TMIUninstaller.uninstall();
        }
    }

    private static File getJarFile() {
        URL url = atv.class.getProtectionDomain().getCodeSource().getLocation();
        try {
            if (url.getProtocol().equals("jar")) {
                url = new URL(url.getPath().substring(0, url.getPath().indexOf(33)));
            }
            return new File(url.toURI());
        }
        catch (URISyntaxException e) {
            return new File(url.getPath());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static void deleteTMIUninstaller() throws IOException {
        System.out.println("Removing TMI Uninstaller");
        TMIUninstaller.deleteDir(new File(TMIUninstaller.getJarFile().getParentFile(), "TMIUninstaller"), true);
    }

    public static boolean TMIInstalled() {
        File jarFile = TMIUninstaller.getJarFile();
        if (!jarFile.getName().endsWith(".jar")) {
            return false;
        }
        try {
            ZipFile zip = new ZipFile(jarFile);
            ZipEntry tmi = zip.getEntry("mod_TooManyItems.class");
            zip.close();
            return tmi != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void runTMIUninstaller() throws IOException {
        ZipEntry zipentry;
        System.out.println("Installing Uninstaller.");
        File jarFile = TMIUninstaller.getJarFile();
        File uninstDir = new File(jarFile.getParentFile(), "TMIUninstaller");
        if (!uninstDir.exists()) {
            uninstDir.mkdirs();
        }
        System.out.println("Installing Uninstaller: " + uninstDir.getPath());
        FileInputStream fileinputstream = new FileInputStream(jarFile);
        ZipInputStream zipinputstream = new ZipInputStream(fileinputstream);
        while ((zipentry = zipinputstream.getNextEntry()) != null) {
            String fullname = zipentry.getName().replace('\\', '/');
            if (zipentry.isDirectory() || !fullname.replace('/', '.').startsWith(TMIUninstaller.class.getCanonicalName())) continue;
            File outFile = new File(uninstDir, fullname);
            System.out.println("Extracting File: " + outFile.getPath());
            if (!outFile.getParentFile().exists()) {
                outFile.getParentFile().mkdirs();
            }
            outFile.createNewFile();
            FileOutputStream fout = new FileOutputStream(outFile);
            byte[] buffer = new byte[65535];
            int read = 0;
            while ((read = zipinputstream.read(buffer)) != -1) {
                fout.write(buffer, 0, read);
            }
            fout.close();
        }
        fileinputstream.close();
        String javaBin = String.valueOf(System.getProperty("java.home")) + File.separator + "bin" + File.separator + "java";
        String classpath = uninstDir.getAbsolutePath();
        String className = TMIUninstaller.class.getCanonicalName();
        String jarPath = jarFile.getPath();
        System.out.println("Running Process: " + javaBin + " -cp \"" + classpath + "\" \"" + className + "\" \"" + jarPath + "\"");
        ProcessBuilder builder = new ProcessBuilder(javaBin, "-cp", classpath, className, jarPath);
        builder.start();
    }

    public static void deleteDir(File directory, boolean remove) throws IOException {
        System.out.println("Deleting Dir: " + directory.getPath());
        if (!directory.exists()) {
            if (!remove) {
                directory.mkdirs();
            }
            return;
        }
        File[] fileArray = directory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                TMIUninstaller.deleteDir(file, true);
            } else if (!file.delete()) {
                throw new IOException("Delete Failed: " + file);
            }
            ++n2;
        }
        if (remove) {
            if (!directory.delete()) {
                throw new IOException("Delete Failed: " + directory);
            }
        }
    }

    public static void uninstall() {
        File backupfile = new File(jarFile.getParentFile(), String.valueOf(jarFile.getName()) + ".bak");
        try {
            ZipEntry entry;
            if (!backupfile.exists()) {
                backupfile.createNewFile();
            }
            FileOutputStream backout = new FileOutputStream(backupfile);
            FileInputStream jarin = new FileInputStream(jarFile);
            backout.getChannel().transferFrom(jarin.getChannel(), 0L, jarFile.length());
            backout.close();
            jarin.close();
            ZipInputStream zipin = new ZipInputStream(new FileInputStream(backupfile));
            ZipOutputStream zipout = new ZipOutputStream(new FileOutputStream(jarFile));
            byte[] buffer = new byte[20000];
            int read = 0;
            while ((entry = zipin.getNextEntry()) != null) {
                String name;
                if (entry.isDirectory() || (name = entry.getName()).startsWith("TMI") || name.startsWith("_tmi") || name.startsWith("tmi.png") || name.startsWith("mod_TooManyItems")) continue;
                zipout.putNextEntry(new ZipEntry(name));
                ZipInputStream in = zipin;
                while ((read = ((InputStream)in).read(buffer)) != -1) {
                    zipout.write(buffer, 0, read);
                }
                zipout.closeEntry();
                zipin.closeEntry();
            }
            zipin.close();
            zipout.close();
            mainframe.getLabelInfo().setText("Uninstall Completed. Close this and restart minecraft.");
        }
        catch (Exception e) {
            e.printStackTrace();
            mainframe.getLabelInfo().setText("Invalid Minecraft.jar");
            try {
                FileInputStream backin = new FileInputStream(backupfile);
                FileOutputStream jarout = new FileOutputStream(jarFile);
                jarout.getChannel().transferFrom(backin.getChannel(), 0L, backupfile.length());
                backin.close();
                jarout.close();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public static class InstallerGui
    extends JFrame {
        private static final long serialVersionUID = 1L;
        private JTextField labelInfo;
        private static final String PREFERRED_LOOK_AND_FEEL = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";

        public InstallerGui() {
            this.setTitle("TMI Uninstaller");
            this.initComponents();
        }

        private void initComponents() {
            this.setLayout(new ResizeListener());
            this.add(this.getLabelInfo());
            this.setSize(358, 270);
        }

        public JTextField getLabelInfo() {
            if (this.labelInfo == null) {
                this.labelInfo = new JTextField();
                this.labelInfo.setFont(new Font("Tahoma", 0, 13));
                this.labelInfo.setHorizontalAlignment(0);
                this.labelInfo.setEditable(false);
                this.labelInfo.setText("Uninstalling TMI");
            }
            return this.labelInfo;
        }

        public static void installLnF() {
            try {
                String lnfClassname = UIManager.getCrossPlatformLookAndFeelClassName();
                UIManager.setLookAndFeel(lnfClassname);
            }
            catch (Exception e) {
                System.err.println("Cannot install com.sun.java.swing.plaf.windows.WindowsLookAndFeel on this platform:" + e.getMessage());
            }
        }

        public class InstallerListener
        implements ActionListener {
            @Override
            public void actionPerformed(ActionEvent e) {
            }
        }

        private class ResizeListener
        implements LayoutManager {
            private ResizeListener() {
            }

            @Override
            public void addLayoutComponent(String name, Component comp) {
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = InstallerGui.this.getContentPane().getWidth();
                InstallerGui.this.labelInfo.setBounds(10, 45, w - 20, 20);
                InstallerGui.this.labelInfo.setScrollOffset(1000);
                InstallerGui.this.labelInfo.update(InstallerGui.this.getGraphics());
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                return new Dimension(150, 100);
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(250, 120);
            }

            @Override
            public void removeLayoutComponent(Component comp) {
            }
        }
    }
}

