/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.CommonUtils;
import codechicken.core.IGuiPacketSender;
import codechicken.core.ServerUtils;
import codechicken.core.inventory.ContainerExtended;
import codechicken.core.inventory.ItemKey;
import codechicken.core.inventory.SlotDummy;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.vec.BlockCoord;
import codechicken.nei.ContainerCreativeInv;
import codechicken.nei.ContainerEnchantmentModifier;
import codechicken.nei.ContainerPotionCreator;
import codechicken.nei.ExtendedCreativeInv;
import codechicken.nei.NEIActions;
import codechicken.nei.NEIServerConfig;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PlayerSave;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;

public class NEISPH
implements PacketCustom.IServerPacketHandler {
    public static final String channel = "NEI";

    public void handlePacket(PacketCustom packet, ka nethandler, jv sender) {
        if (!NEIServerConfig.authenticatePacket(sender, packet)) {
            return;
        }
        switch (packet.getType()) {
            case 1: {
                this.handleGiveItem(sender, packet);
                break;
            }
            case 4: {
                NEIServerUtils.deleteAllItems(sender);
                break;
            }
            case 5: {
                this.setInventorySlot(sender, packet);
                break;
            }
            case 6: {
                NEIServerUtils.toggleMagnetMode(sender);
                break;
            }
            case 7: {
                NEIServerUtils.setHourForward(sender.q, packet.readUByte(), true);
                break;
            }
            case 8: {
                NEIServerUtils.healPlayer((uf)sender);
                break;
            }
            case 9: {
                NEIServerUtils.toggleRaining(sender.q, true);
                break;
            }
            case 10: {
                this.sendLoginState(sender);
                break;
            }
            case 11: {
                sender.a(sender.bp, sender.bp.a());
                break;
            }
            case 12: {
                this.handlePropertyChange(sender, packet);
                break;
            }
            case 13: {
                NEIServerUtils.setGamemode(sender, packet.readUByte());
                break;
            }
            case 14: {
                NEIServerUtils.cycleCreativeInv(sender, packet.readInt());
                break;
            }
            case 15: {
                this.handleMobSpawnerID(sender.q, packet.readCoord(), packet.readString());
                break;
            }
            case 20: {
                this.handleContainerPacket(sender, packet);
                break;
            }
            case 21: {
                this.openEnchantmentGui(sender);
                break;
            }
            case 22: {
                this.modifyEnchantment(sender, packet.readUByte(), packet.readUByte(), packet.readBoolean());
                break;
            }
            case 23: {
                this.processCreativeInv(sender, packet.readBoolean());
                break;
            }
            case 24: {
                this.openPotionGui(sender, packet);
                break;
            }
            case 25: {
                this.handleDummySlotSet(sender, packet);
            }
        }
    }

    private void handleDummySlotSet(jv sender, PacketCustom packet) {
        short slotNumber = packet.readShort();
        ye stack = packet.readItemStack(true);
        we slot = sender.bp.a((int)slotNumber);
        if (slot instanceof SlotDummy) {
            slot.c(stack);
        }
    }

    private void handleContainerPacket(jv sender, PacketCustom packet) {
        if (sender.bp instanceof ContainerExtended) {
            ((ContainerExtended)sender.bp).handleInputPacket(packet);
        }
    }

    private void handleMobSpawnerID(abw world, BlockCoord coord, String mobtype) {
        asp tile = world.r(coord.x, coord.y, coord.z);
        if (tile instanceof asj) {
            ((asj)tile).a().a(mobtype);
            tile.e();
            world.j(coord.x, coord.y, coord.z);
        }
    }

    private void handlePropertyChange(jv sender, PacketCustom packet) {
        String name = packet.readString();
        if (NEIServerConfig.canPlayerPerformAction(sender.bu, name)) {
            NEIServerConfig.disableAction(sender.ar, name, packet.readBoolean());
        }
    }

    private void processCreativeInv(jv sender, boolean open) {
        if (open) {
            ServerUtils.openSMPContainer((jv)sender, (uy)new ContainerCreativeInv((uf)sender, new ExtendedCreativeInv(NEIServerConfig.forPlayer(sender.bu), Side.SERVER)), (IGuiPacketSender)new IGuiPacketSender(){

                public void sendPacket(jv player, int windowId) {
                    PacketCustom packet = new PacketCustom((Object)NEISPH.channel, 23);
                    packet.writeBoolean(true);
                    packet.writeByte(windowId);
                    packet.sendToPlayer((uf)player);
                }
            });
        } else {
            sender.k();
            PacketCustom packet = new PacketCustom((Object)channel, 23);
            packet.writeBoolean(false);
            packet.sendToPlayer((uf)sender);
        }
    }

    private void handleGiveItem(jv player, PacketCustom packet) {
        boolean infinite = packet.readBoolean();
        boolean doSpawn = packet.readBoolean();
        int num = packet.readUByte();
        LinkedList<String> name = new LinkedList<String>();
        int i = 0;
        while (i < num) {
            name.add(packet.readString());
            ++i;
        }
        ye item = packet.readItemStack();
        if (item == null) {
            ServerUtils.sendChatTo((jv)player, (String)"\u00a7fNo such item.");
            return;
        }
        item.b = packet.readInt();
        NEIServerUtils.givePlayerItem(player, item, infinite, name, doSpawn);
    }

    private void setInventorySlot(jv player, PacketCustom packet) {
        boolean container = packet.readBoolean();
        short slot = packet.readShort();
        ye item = packet.readItemStack();
        if (!NEIServerConfig.canPlayerPerformAction(player.bu, item == null ? "delete" : "item")) {
            return;
        }
        NEIServerUtils.setSlotContents((uf)player, slot, item, container);
    }

    private void modifyEnchantment(jv player, int e, int lvl, boolean add) {
        ContainerEnchantmentModifier containerem = (ContainerEnchantmentModifier)player.bp;
        if (add) {
            containerem.addEnchantment(e, lvl);
        } else {
            containerem.removeEnchantment(e);
        }
    }

    private void openEnchantmentGui(jv player) {
        ServerUtils.openSMPContainer((jv)player, (uy)new ContainerEnchantmentModifier(player.bn, player.q, 0, 0, 0), (IGuiPacketSender)new IGuiPacketSender(){

            public void sendPacket(jv player, int windowId) {
                PacketCustom packet = new PacketCustom((Object)NEISPH.channel, 21);
                packet.writeByte(windowId);
                packet.sendToPlayer((uf)player);
            }
        });
    }

    private void openPotionGui(jv player, PacketCustom packet) {
        mu b = new mu("potionStore", true, 9);
        int i = 0;
        while (i < b.j_()) {
            b.a(i, packet.readItemStack());
            ++i;
        }
        ServerUtils.openSMPContainer((jv)player, (uy)new ContainerPotionCreator(player.bn, (mo)b), (IGuiPacketSender)new IGuiPacketSender(){

            public void sendPacket(jv player, int windowId) {
                PacketCustom packet = new PacketCustom((Object)NEISPH.channel, 24);
                packet.writeByte(windowId);
                packet.sendToPlayer((uf)player);
            }
        });
    }

    public static void sendActionDisabled(int dim, String name, boolean disable) {
        new PacketCustom((Object)channel, 11).writeString(name).writeBoolean(disable).sendToDimension(dim);
    }

    public static void sendActionEnabled(jv player, String name, boolean enable) {
        new PacketCustom((Object)channel, 12).writeString(name).writeBoolean(enable).sendToPlayer((uf)player);
    }

    private void sendLoginState(jv player) {
        LinkedList<String> actions = new LinkedList<String>();
        LinkedList<String> disabled = new LinkedList<String>();
        LinkedList<String> enabled = new LinkedList<String>();
        PlayerSave playerSave = NEIServerConfig.forPlayer(player.bu);
        for (String name : NEIActions.nameActionMap.keySet()) {
            if (NEIServerConfig.canPlayerPerformAction(player.bu, name)) {
                actions.add(name);
            }
            if (NEIServerConfig.isActionDisabled(player.ar, name)) {
                disabled.add(name);
            }
            if (!playerSave.isActionEnabled(name)) continue;
            enabled.add(name);
        }
        ArrayList<ItemKey> bannedblocks = new ArrayList<ItemKey>();
        for (Map.Entry<ItemKey, HashSet<String>> entry : NEIServerConfig.bannedblocks.entrySet()) {
            if (NEIServerConfig.isPlayerInList(player.bu, entry.getValue(), true)) continue;
            bannedblocks.add(entry.getKey());
        }
        PacketCustom packet = new PacketCustom((Object)channel, 10);
        packet.writeByte(actions.size());
        for (String s : actions) {
            packet.writeString(s);
        }
        packet.writeByte(disabled.size());
        for (String s : disabled) {
            packet.writeString(s);
        }
        packet.writeByte(enabled.size());
        for (String s : enabled) {
            packet.writeString(s);
        }
        packet.writeInt(bannedblocks.size());
        for (ItemKey hash : bannedblocks) {
            packet.writeShort(hash.item.d);
            packet.writeShort(hash.item.k());
        }
        packet.sendToPlayer((uf)player);
    }

    public static void sendHasServerSideTo(jv player) {
        System.out.println("Sending serverside check to: " + player.bu);
        PacketCustom packet = new PacketCustom((Object)channel, 1);
        packet.writeByte(0);
        packet.writeString(CommonUtils.getWorldName((abw)player.q));
        packet.sendToPlayer((uf)player);
    }

    public static void sendAddMagneticItemTo(jv player, ss item) {
        PacketCustom packet = new PacketCustom((Object)channel, 13);
        packet.writeInt(item.k);
        packet.sendToPlayer((uf)player);
    }
}

