/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.gui.GuiDraw;
import codechicken.nei.Button;
import codechicken.nei.ButtonCycled;
import codechicken.nei.DropDownWidget;
import codechicken.nei.GuiExtendedCreativeInv;
import codechicken.nei.Image;
import codechicken.nei.ItemList;
import codechicken.nei.ItemPanel;
import codechicken.nei.ItemQuantityField;
import codechicken.nei.KeyManager;
import codechicken.nei.Label;
import codechicken.nei.LayoutStyleMinecraft;
import codechicken.nei.LayoutStyleTMIOld;
import codechicken.nei.NEIActions;
import codechicken.nei.NEICPH;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIController;
import codechicken.nei.SaveLoadButton;
import codechicken.nei.SearchField;
import codechicken.nei.TextField;
import codechicken.nei.VisiblityData;
import codechicken.nei.Widget;
import codechicken.nei.WidgetZOrder;
import codechicken.nei.api.API;
import codechicken.nei.api.GuiInfo;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.IRecipeOverlayRenderer;
import codechicken.nei.api.ItemInfo;
import codechicken.nei.api.LayoutStyle;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.forge.IContainerDrawHandler;
import codechicken.nei.forge.IContainerInputHandler;
import codechicken.nei.forge.IContainerObjectHandler;
import codechicken.nei.forge.IContainerTooltipHandler;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.lwjgl.opengl.GL11;

public class LayoutManager
implements IContainerInputHandler,
IContainerTooltipHandler,
IContainerDrawHandler,
IContainerObjectHandler,
KeyManager.IKeyStateTracker {
    private static LayoutManager instance;
    private static Widget inputFocused;
    private static TreeSet<Widget> drawWidgets;
    private static TreeSet<Widget> controlWidgets;
    public static ItemPanel itemPanel;
    public static DropDownWidget dropDown;
    public static TextField searchField;
    public static Button options;
    public static Button prev;
    public static Button next;
    public static Label pageLabel;
    public static Button more;
    public static Button less;
    public static ItemQuantityField quantity;
    public static SaveLoadButton[] stateButtons;
    public static Button[] deleteButtons;
    public static Button delete;
    public static ButtonCycled gamemode;
    public static Button rain;
    public static Button magnet;
    public static Button[] timeButtons;
    public static Button heal;
    public static IRecipeOverlayRenderer overlayRenderer;
    public static HashMap<Integer, LayoutStyle> layoutStyles;

    static {
        timeButtons = new Button[4];
        layoutStyles = new HashMap();
    }

    public static void load() {
        API.addLayoutStyle(0, new LayoutStyleMinecraft());
        API.addLayoutStyle(1, new LayoutStyleTMIOld());
        instance = new LayoutManager();
        KeyManager.trackers.add(instance);
        GuiContainerManager.addInputHandler(instance);
        GuiContainerManager.addTooltipHandler(instance);
        GuiContainerManager.addDrawHandler(instance);
        GuiContainerManager.addObjectHandler(instance);
        LayoutManager.init();
    }

    @Override
    public void onPreDraw(awy gui) {
        if (!NEIClientConfig.isHidden() && NEIClientConfig.isEnabled() && gui instanceof axp) {
            gui.p = (gui.g - gui.c) / 2;
            gui.q = (gui.h - gui.d) / 2;
            if (gui instanceof axm && gui.i.size() >= 2) {
                aut button1 = (aut)gui.i.get(0);
                aut button2 = (aut)gui.i.get(1);
                button1.d = gui.p;
                button2.d = gui.p + gui.c - 20;
            }
        }
    }

    @Override
    public void onMouseClicked(awy gui, int mousex, int mousey, int button) {
        if (NEIClientConfig.isHidden()) {
            return;
        }
        for (Widget widget : controlWidgets) {
            widget.onGuiClick(mousex, mousey);
        }
    }

    @Override
    public boolean mouseClicked(awy gui, int mousex, int mousey, int button) {
        if (NEIClientConfig.isHidden()) {
            return false;
        }
        if (!NEIClientConfig.isEnabled()) {
            return options.contains(mousex, mousey) && options.handleClick(mousex, mousey, button);
        }
        for (Widget widget : controlWidgets) {
            widget.onGuiClick(mousex, mousey);
            if (!(widget.contains(mousex, mousey) ? widget.handleClick(mousex, mousey, button) : widget.handleClickExt(mousex, mousey, button))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean objectUnderMouse(awy gui, int mousex, int mousey) {
        if (!NEIClientConfig.isHidden() && NEIClientConfig.isEnabled()) {
            for (Widget widget : controlWidgets) {
                if (!widget.contains(mousex, mousey)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean keyTyped(awy gui, char keyChar, int keyID) {
        if (NEIClientConfig.isEnabled() && !NEIClientConfig.isHidden()) {
            if (inputFocused != null) {
                return inputFocused.handleKeyPress(keyID, keyChar);
            }
            for (Widget widget : controlWidgets) {
                if (!widget.handleKeyPress(keyID, keyChar)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void onKeyTyped(awy gui, char keyChar, int keyID) {
    }

    @Override
    public boolean lastKeyTyped(awy gui, char keyChar, int keyID) {
        if (keyID == NEIClientConfig.getKeyBinding("gui.hide")) {
            NEIClientConfig.toggleBooleanSetting("inventory.hidden");
            return true;
        }
        if (NEIClientConfig.isEnabled() && !NEIClientConfig.isHidden()) {
            for (Widget widget : controlWidgets) {
                if (inputFocused != null) continue;
                widget.lastKeyTyped(keyID, keyChar);
            }
        }
        return false;
    }

    @Override
    public void onMouseUp(awy gui, int mx, int my, int button) {
        if (!NEIClientConfig.isHidden() && NEIClientConfig.isEnabled()) {
            for (Widget widget : controlWidgets) {
                widget.mouseUp(mx, my, button);
            }
        }
    }

    @Override
    public void onMouseDragged(awy gui, int mx, int my, int button, long heldTime) {
        if (!NEIClientConfig.isHidden() && NEIClientConfig.isEnabled()) {
            for (Widget widget : controlWidgets) {
                widget.mouseDragged(mx, my, button, heldTime);
            }
        }
    }

    @Override
    public ye getStackUnderMouse(awy gui, int mousex, int mousey) {
        if (!NEIClientConfig.isHidden() && NEIClientConfig.isEnabled()) {
            for (Widget widget : controlWidgets) {
                ye stack = widget.getStackMouseOver(mousex, mousey);
                if (stack == null) continue;
                return stack;
            }
        }
        return null;
    }

    @Override
    public void renderObjects(awy gui, int mousex, int mousey) {
        if (!NEIClientConfig.isHidden()) {
            LayoutManager.layout(gui);
            if (NEIClientConfig.isEnabled()) {
                LayoutManager.getLayoutStyle().drawBackground(gui.manager);
                for (Widget widget : drawWidgets) {
                    widget.draw(mousex, mousey);
                }
            } else {
                options.draw(mousex, mousey);
            }
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
        }
    }

    @Override
    public void postRenderObjects(awy gui, int mousex, int mousey) {
        if (!NEIClientConfig.isHidden() && NEIClientConfig.isEnabled()) {
            for (Widget widget : drawWidgets) {
                widget.postDraw(mousex, mousey);
            }
        }
    }

    @Override
    public List<String> handleTooltipFirst(awy gui, int mousex, int mousey, List<String> currenttip) {
        if (!NEIClientConfig.isHidden() && NEIClientConfig.isEnabled() && gui.manager.shouldShowTooltip()) {
            for (Widget widget : controlWidgets) {
                currenttip = widget.handleTooltip(mousex, mousey, currenttip);
            }
        }
        return currenttip;
    }

    @Override
    public List<String> handleItemTooltip(awy gui, ye itemstack, List<String> currenttip) {
        String overridename = ItemInfo.getOverrideName(itemstack.d, itemstack.k());
        if (overridename != null) {
            currenttip.set(0, overridename);
        }
        String mainname = currenttip.get(0);
        if (NEIClientConfig.showIDs()) {
            mainname = String.valueOf(mainname) + " " + itemstack.d;
            if (itemstack.k() != 0) {
                mainname = String.valueOf(mainname) + ":" + itemstack.k();
            }
            currenttip.set(0, mainname);
        }
        return currenttip;
    }

    public static void layout(awy gui) {
        VisiblityData visiblity = new VisiblityData();
        if (NEIClientConfig.isHidden()) {
            visiblity.showNEI = false;
        }
        if (gui.h - gui.d <= 40) {
            visiblity.showSearchSection = false;
        }
        if (gui.p - 4 < 76) {
            visiblity.showWidgets = false;
        }
        for (INEIGuiHandler handler : GuiInfo.guiHandlers) {
            handler.modifyVisiblity(gui, visiblity);
        }
        visiblity.translateDependancies();
        LayoutManager.getLayoutStyle().layout(gui, visiblity);
        LayoutManager.updateWidgetVisiblities(gui, visiblity);
    }

    private static void init() {
        itemPanel = new ItemPanel();
        dropDown = new DropDownWidget();
        searchField = new SearchField("search");
        options = new Button("Options"){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (!rightclick) {
                    NEIClientConfig.getOptionList().showGui(NEIClientUtils.getGuiContainer());
                    return true;
                }
                return false;
            }

            @Override
            public String getRenderLabel() {
                return NEIClientUtils.translate("inventory.options", new Object[0]);
            }
        };
        prev = new Button("Prev"){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (!rightclick) {
                    itemPanel.scroll(-1);
                    return true;
                }
                return false;
            }

            @Override
            public String getRenderLabel() {
                return NEIClientUtils.translate("inventory.prev", new Object[0]);
            }
        };
        next = new Button("Next"){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (!rightclick) {
                    itemPanel.scroll(1);
                    return true;
                }
                return false;
            }

            @Override
            public String getRenderLabel() {
                return NEIClientUtils.translate("inventory.next", new Object[0]);
            }
        };
        pageLabel = new Label("(0/0)", true);
        more = new Button("+"){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (rightclick) {
                    return false;
                }
                int modifier = NEIClientUtils.controlKey() ? 64 : (NEIClientUtils.shiftKey() ? 10 : 1);
                int quantity = NEIClientConfig.getItemQuantity() + modifier;
                if (quantity < 0) {
                    quantity = 0;
                }
                NEIClientUtils.setItemQuantity(quantity);
                return true;
            }
        };
        less = new Button("-"){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (rightclick) {
                    return false;
                }
                int modifier = NEIClientUtils.controlKey() ? -64 : (NEIClientUtils.shiftKey() ? -10 : -1);
                int quantity = NEIClientConfig.getItemQuantity() + modifier;
                if (quantity < 0) {
                    quantity = 0;
                }
                NEIClientUtils.setItemQuantity(quantity);
                return true;
            }
        };
        quantity = new ItemQuantityField("quantity");
        stateButtons = new SaveLoadButton[7];
        deleteButtons = new Button[7];
        int i = 0;
        while (i < 7) {
            final int savestate = i;
            LayoutManager.stateButtons[i] = new SaveLoadButton(""){

                @Override
                public boolean onButtonPress(boolean rightclick) {
                    if (NEIClientConfig.isStateSaved(savestate)) {
                        NEIClientConfig.loadState(savestate);
                    } else {
                        NEIClientConfig.saveState(savestate);
                    }
                    return true;
                }

                @Override
                public void onTextChange() {
                    by statelist = NEIClientConfig.global.nbt.l("statename");
                    NEIClientConfig.global.nbt.a("statename", (cl)statelist);
                    statelist.a("" + savestate, this.label);
                    NEIClientConfig.global.saveNBT();
                }
            };
            LayoutManager.deleteButtons[i] = new Button("x"){

                @Override
                public boolean onButtonPress(boolean rightclick) {
                    if (!rightclick) {
                        NEIClientConfig.clearState(savestate);
                        return true;
                    }
                    return false;
                }
            };
            ++i;
        }
        delete = new Button(){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if ((this.state & 3) == 2) {
                    return false;
                }
                ye held = NEIClientUtils.getHeldItem();
                if (held != null) {
                    if (NEIClientUtils.shiftKey()) {
                        NEIClientUtils.deleteHeldItem();
                        NEIClientUtils.deleteItemsOfType(held);
                    } else if (rightclick) {
                        NEIClientUtils.decreaseSlotStack(-999);
                    } else {
                        NEIClientUtils.deleteHeldItem();
                    }
                } else if (NEIClientUtils.shiftKey()) {
                    NEIClientUtils.deleteEverything();
                } else {
                    NEIController.deleteMode = !NEIController.deleteMode;
                }
                return true;
            }

            @Override
            public String getButtonTip() {
                if ((this.state & 3) == 2) {
                    return null;
                }
                ye itemstack = NEIClientUtils.getHeldItem();
                if (itemstack == null) {
                    if (NEIClientUtils.shiftKey()) {
                        return NEIClientUtils.translate("inventory.delete.all", new Object[0]);
                    }
                    return LayoutManager.getStateTip("delete", this.state);
                }
                return NEIClientUtils.translate("delete." + (NEIClientUtils.shiftKey() ? "allof" : "oneof"), GuiContainerManager.itemDisplayNameShort(itemstack));
            }
        };
        gamemode = new ButtonCycled(){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (!rightclick) {
                    NEIClientUtils.cycleGamemode();
                    return true;
                }
                return false;
            }

            @Override
            public String getButtonTip() {
                return NEIClientUtils.translate("inventory.gamemode." + NEIClientUtils.getNextGamemode(), new Object[0]);
            }
        };
        LayoutManager.gamemode.icons = new Image[3];
        rain = new Button(){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (LayoutManager.handleDisabledButtonPress("rain", rightclick)) {
                    return true;
                }
                if (!rightclick) {
                    NEIClientUtils.toggleRaining();
                    return true;
                }
                return false;
            }

            @Override
            public String getButtonTip() {
                return LayoutManager.getStateTip("rain", this.state);
            }
        };
        magnet = new Button(){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (!rightclick) {
                    NEIClientUtils.toggleMagnetMode();
                    return true;
                }
                return false;
            }

            @Override
            public String getButtonTip() {
                return LayoutManager.getStateTip("magnet", this.state);
            }
        };
        i = 0;
        while (i < 4) {
            final int zone = i;
            LayoutManager.timeButtons[i] = new Button(){

                @Override
                public boolean onButtonPress(boolean rightclick) {
                    if (LayoutManager.handleDisabledButtonPress(NEIActions.timeZones[zone], rightclick)) {
                        return true;
                    }
                    if (!rightclick) {
                        NEIClientUtils.setHourForward(zone * 6);
                        return true;
                    }
                    return false;
                }

                @Override
                public String getButtonTip() {
                    return LayoutManager.getTimeTip(NEIActions.timeZones[zone], this.state);
                }
            };
            ++i;
        }
        heal = new Button(){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (!rightclick) {
                    NEIClientUtils.healPlayer();
                    return true;
                }
                return false;
            }

            @Override
            public String getButtonTip() {
                return NEIClientUtils.translate("inventory.heal", new Object[0]);
            }
        };
        LayoutManager.delete.state |= 4;
        LayoutManager.gamemode.state |= 4;
        LayoutManager.rain.state |= 4;
        LayoutManager.magnet.state |= 4;
    }

    private static String getStateTip(String name, int state) {
        String sfx = (state & 3) == 2 ? "enable" : ((state & 3) == 1 ? "0" : "1");
        return NEIClientUtils.translate("inventory." + name + "." + sfx, new Object[0]);
    }

    private static String getTimeTip(String name, int state) {
        String sfx = (state & 3) == 2 ? "enable" : "set";
        return NEIClientUtils.translate("inventory." + name + "." + sfx, new Object[0]);
    }

    private static boolean handleDisabledButtonPress(String ident, boolean rightclick) {
        if (!NEIActions.canDisable.contains(ident)) {
            return false;
        }
        if (rightclick != NEIClientConfig.disabledActions.contains(ident)) {
            return LayoutManager.setPropertyDisabled(ident, rightclick);
        }
        return false;
    }

    private static boolean setPropertyDisabled(String ident, boolean disable) {
        if (disable && NEIActions.base(ident).equals("time")) {
            int count = 0;
            int i = 0;
            while (i < 4) {
                if (NEIClientConfig.disabledActions.contains(NEIActions.timeZones[i])) {
                    ++count;
                }
                ++i;
            }
            if (count == 3) {
                return false;
            }
        }
        if (NEIClientConfig.hasSMPCounterPart()) {
            NEICPH.sendSetPropertyDisabled(ident, disable);
        }
        return true;
    }

    @Override
    public void load(awy gui) {
        if (NEIClientConfig.isEnabled()) {
            LayoutManager.setInputFocused(null);
            ItemList.loadItems();
            overlayRenderer = null;
            LayoutManager.getLayoutStyle().init();
            LayoutManager.layout(gui);
        }
        NEIController.load(gui);
        if (this.checkCreativeInv(gui)) {
            if (gui.f.n instanceof axm) {
                gui.f.a(null);
            }
            return;
        }
    }

    @Override
    public void refresh(awy gui) {
    }

    public boolean checkCreativeInv(awy gui) {
        if (gui instanceof axm && NEIClientConfig.invCreativeMode()) {
            NEICPH.sendCreativeInv(true);
            return true;
        }
        if (gui instanceof GuiExtendedCreativeInv && !NEIClientConfig.invCreativeMode()) {
            NEICPH.sendCreativeInv(false);
            return true;
        }
        return false;
    }

    public static void updateWidgetVisiblities(awy gui, VisiblityData visiblity) {
        int i;
        drawWidgets = new TreeSet<Widget>(new WidgetZOrder(false));
        controlWidgets = new TreeSet<Widget>(new WidgetZOrder(true));
        if (!visiblity.showNEI) {
            return;
        }
        LayoutManager.addWidget(options);
        if (visiblity.showItemPanel) {
            LayoutManager.addWidget(itemPanel);
            LayoutManager.addWidget(prev);
            LayoutManager.addWidget(next);
            LayoutManager.addWidget(pageLabel);
            if (NEIClientConfig.canPerformAction("item")) {
                LayoutManager.addWidget(more);
                LayoutManager.addWidget(less);
                LayoutManager.addWidget(quantity);
            }
        }
        if (visiblity.showSearchSection) {
            LayoutManager.addWidget(dropDown);
            LayoutManager.addWidget(searchField);
        }
        if (NEIClientConfig.canPerformAction("item") && visiblity.showStateButtons) {
            i = 0;
            while (i < 7) {
                LayoutManager.addWidget(stateButtons[i]);
                if (NEIClientConfig.isStateSaved(i)) {
                    LayoutManager.addWidget(deleteButtons[i]);
                }
                ++i;
            }
        }
        if (visiblity.showUtilityButtons) {
            if (NEIClientConfig.canPerformAction("time")) {
                i = 0;
                while (i < 4) {
                    LayoutManager.addWidget(timeButtons[i]);
                    ++i;
                }
            }
            if (NEIClientConfig.canPerformAction("rain")) {
                LayoutManager.addWidget(rain);
            }
            if (NEIClientConfig.canPerformAction("heal")) {
                LayoutManager.addWidget(heal);
            }
            if (NEIClientConfig.canPerformAction("magnet")) {
                LayoutManager.addWidget(magnet);
            }
            if (NEIClientUtils.isValidGamemode("creative") || NEIClientUtils.isValidGamemode("creative+") || NEIClientUtils.isValidGamemode("adventure")) {
                LayoutManager.addWidget(gamemode);
            }
            if (NEIClientConfig.canPerformAction("delete")) {
                LayoutManager.addWidget(delete);
            }
        }
    }

    public static LayoutStyle getLayoutStyle(int id) {
        LayoutStyle style = layoutStyles.get(id);
        if (style == null) {
            style = layoutStyles.get(0);
        }
        return style;
    }

    public static LayoutStyle getLayoutStyle() {
        return LayoutManager.getLayoutStyle(NEIClientConfig.getLayoutStyle());
    }

    private static void addWidget(Widget widget) {
        drawWidgets.add(widget);
        controlWidgets.add(widget);
    }

    @Override
    public void guiTick(awy gui) {
        if (this.checkCreativeInv(gui)) {
            return;
        }
        if (!NEIClientConfig.isEnabled()) {
            return;
        }
        for (Widget widget : controlWidgets) {
            widget.update();
        }
    }

    @Override
    public boolean mouseScrolled(awy gui, int mousex, int mousey, int scrolled) {
        if (NEIClientConfig.isHidden() || !NEIClientConfig.isEnabled()) {
            return false;
        }
        for (Widget widget : controlWidgets) {
            if (!widget.onMouseWheel(scrolled, mousex, mousey)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onMouseScrolled(awy gui, int mousex, int mousey, int scrolled) {
    }

    @Override
    public boolean shouldShowTooltip(awy gui) {
        return LayoutManager.itemPanel.draggedStack == null;
    }

    public static Widget getInputFocused() {
        return inputFocused;
    }

    public static void setInputFocused(Widget widget) {
        if (inputFocused != null) {
            inputFocused.loseFocus();
        }
        if ((inputFocused = widget) != null) {
            inputFocused.gainFocus();
        }
    }

    @Override
    public void renderSlotUnderlay(awy gui, we slot) {
        if (overlayRenderer != null) {
            overlayRenderer.renderOverlay(gui.manager, slot);
        }
    }

    @Override
    public void renderSlotOverlay(awy window, we slot) {
        ye item = slot.d();
        if (NEIClientConfig.world.nbt.n("searchinventories") && (item == null ? !NEIClientConfig.getSearchExpression().equals("") : !ItemList.itemMatchesSearch(item))) {
            GL11.glDisable((int)2896);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)150.0f);
            GuiDraw.drawRect((int)slot.h, (int)slot.i, (int)16, (int)16, (int)Integer.MIN_VALUE);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-150.0f);
            GL11.glEnable((int)2896);
        }
    }

    public static void drawIcon(int x, int y, Image image) {
        GuiDraw.changeTexture((String)"nei:textures/nei_sprites.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GuiDraw.drawTexturedModalRect((int)x, (int)y, (int)image.x, (int)image.y, (int)image.width, (int)image.height);
        GL11.glDisable((int)3042);
    }

    public static void drawButtonBackground(int x, int y, int w, int h, boolean edges, int type) {
        int wtiles = 0;
        int ew = w;
        if (w / 2 > 100) {
            wtiles = (w - 200) / 50 + 1;
            ew = 200;
        }
        int w1 = ew / 2;
        int h1 = h / 2;
        int w2 = (ew + 1) / 2;
        int h2 = (h + 1) / 2;
        int x2 = x + w - w2;
        int y2 = y + h - h2;
        int ty = 46 + type * 20;
        int te = edges ? 0 : 1;
        int ty1 = ty + te;
        int tx1 = te;
        int tx3 = 75;
        int ty2 = ty + 20 - h2 - te;
        int tx2 = 200 - w2 - te;
        GuiDraw.changeTexture((String)"textures/gui/widgets.png");
        GuiDraw.drawTexturedModalRect((int)x, (int)y, (int)tx1, (int)ty1, (int)w1, (int)h1);
        GuiDraw.drawTexturedModalRect((int)x, (int)y2, (int)tx1, (int)ty2, (int)w1, (int)h2);
        int tile = 0;
        while (tile < wtiles) {
            int tilex = x + w1 + 50 * tile;
            GuiDraw.drawTexturedModalRect((int)tilex, (int)y, (int)tx3, (int)ty1, (int)50, (int)h1);
            GuiDraw.drawTexturedModalRect((int)tilex, (int)y2, (int)tx3, (int)ty2, (int)50, (int)h2);
            ++tile;
        }
        GuiDraw.drawTexturedModalRect((int)x2, (int)y, (int)tx2, (int)ty1, (int)w2, (int)h1);
        GuiDraw.drawTexturedModalRect((int)x2, (int)y2, (int)tx2, (int)ty2, (int)w2, (int)h2);
    }

    public static LayoutManager instance() {
        return instance;
    }

    @Override
    public void tickKeyStates() {
        if (atv.w().n != null) {
            return;
        }
        if (KeyManager.keyStates.get((Object)"world.dawn").down) {
            timeButtons[0].onButtonPress(false);
        }
        if (KeyManager.keyStates.get((Object)"world.noon").down) {
            timeButtons[1].onButtonPress(false);
        }
        if (KeyManager.keyStates.get((Object)"world.dusk").down) {
            timeButtons[2].onButtonPress(false);
        }
        if (KeyManager.keyStates.get((Object)"world.midnight").down) {
            timeButtons[3].onButtonPress(false);
        }
        if (KeyManager.keyStates.get((Object)"world.rain").down) {
            rain.onButtonPress(false);
        }
        if (KeyManager.keyStates.get((Object)"world.heal").down) {
            heal.onButtonPress(false);
        }
        if (KeyManager.keyStates.get((Object)"world.creative").down) {
            gamemode.onButtonPress(false);
        }
    }
}

