/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.inventory.ItemKey;
import codechicken.nei.DropDownFile;
import codechicken.nei.ItemList;
import codechicken.nei.NEIClientConfig;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class ItemVisibilityHash {
    private static boolean[] statesSaved = new boolean[7];
    public TreeMap<Integer, IDInfo> hiddenitems;

    public ItemVisibilityHash() {
        try {
            this.loadFromCompound(this.getCurrentSaveCompound());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public by getCurrentSaveCompound() {
        by hashSave = NEIClientConfig.global.nbt.l("vis");
        NEIClientConfig.global.nbt.a("vis", (cl)hashSave);
        by currentSave = hashSave.l("current");
        hashSave.a("current", currentSave);
        return currentSave;
    }

    public void hideItem(int item, int damage) {
        IDInfo info = this.hiddenitems.get(item);
        if (info == null) {
            info = new IDInfo();
            this.hiddenitems.put(item, info);
        }
        info.damages.add(damage);
    }

    public void hideItem(int item, by stackTagCompound) {
        IDInfo info = this.hiddenitems.get(item);
        if (info == null) {
            info = new IDInfo();
            this.hiddenitems.put(item, info);
        }
        if (!info.compounds.contains(stackTagCompound)) {
            info.compounds.add(stackTagCompound);
        }
    }

    public void hideItem(ItemKey item) {
        if (item.item.p()) {
            this.hideItem(item.item.d, item.item.q());
        } else {
            this.hideItem(item.item.d, item.item.k());
        }
    }

    public void unhideItem(int item, int damage) {
        IDInfo info = this.hiddenitems.get(item);
        if (info == null) {
            return;
        }
        if (damage == -1) {
            this.hiddenitems.remove(item);
        } else {
            info.damages.remove(damage);
        }
    }

    public void unhideItem(int item, by stackTagCompound) {
        IDInfo info = this.hiddenitems.get(item);
        if (info == null) {
            return;
        }
        info.compounds.remove(stackTagCompound);
    }

    public void unhideItem(ItemKey item) {
        if (item.item.p()) {
            this.unhideItem(item.item.d, item.item.q());
        } else {
            this.unhideItem(item.item.d, item.item.k());
        }
    }

    public boolean isItemHidden(int itemID, int damage) {
        IDInfo info = this.hiddenitems.get(itemID);
        if (info == null) {
            return false;
        }
        return info.damages.contains(damage) || info.damages.contains(-1);
    }

    public boolean isItemHidden(int itemID, by stackTagCompound) {
        IDInfo info = this.hiddenitems.get(itemID);
        if (info == null) {
            return false;
        }
        return info.compounds.contains(stackTagCompound);
    }

    public boolean isItemHidden(ItemKey item) {
        IDInfo info = this.hiddenitems.get(item.item.d);
        if (info == null) {
            return false;
        }
        if (info.damages.contains(item.item.k()) || info.damages.contains(-1)) {
            return true;
        }
        if (item.item.p()) {
            return info.compounds.contains(item.item.q());
        }
        return false;
    }

    private void loadFromCompound(by readTag) {
        this.hiddenitems = new TreeMap();
        for (Object obj : readTag.c()) {
            int i;
            IDInfo info;
            int itemID;
            if (obj instanceof cg) {
                cg compoundlist = (cg)obj;
                itemID = Integer.parseInt(compoundlist.e().substring(1));
                info = this.hiddenitems.get(itemID);
                if (info == null) {
                    info = new IDInfo();
                    this.hiddenitems.put(itemID, info);
                }
                i = 0;
                while (i < compoundlist.c()) {
                    by itemNBT = (by)compoundlist.b(i);
                    itemNBT.p("tag");
                    info.compounds.add(itemNBT);
                    ++i;
                }
                continue;
            }
            if (!(obj instanceof bw)) continue;
            bw damagearray = (bw)obj;
            itemID = Integer.parseInt(damagearray.e().substring(1));
            info = this.hiddenitems.get(itemID);
            if (info == null) {
                info = new IDInfo();
                this.hiddenitems.put(itemID, info);
            }
            i = 0;
            while (i < damagearray.a.length / 2) {
                info.damages.add((damagearray.a[i * 2] << 8) + damagearray.a[i * 2 + 1]);
                ++i;
            }
        }
    }

    public void save() {
        by hashSave = NEIClientConfig.global.nbt.l("vis");
        NEIClientConfig.global.nbt.a("vis", (cl)hashSave);
        hashSave.a("current", this.constructSaveCompound());
        NEIClientConfig.global.saveNBT();
    }

    private by constructSaveCompound() {
        by savecompound = new by();
        for (Map.Entry<Integer, IDInfo> itemEntry : this.hiddenitems.entrySet()) {
            int id = itemEntry.getKey();
            IDInfo info = itemEntry.getValue();
            if (info.compounds.size() > 0) {
                cg compoundlist = new cg();
                for (by compound : info.compounds) {
                    compoundlist.a((cl)compound);
                }
                savecompound.a("c" + id, (cl)compoundlist);
            }
            if (info.damages.size() <= 0) continue;
            byte[] damagearray = new byte[info.damages.size() * 2];
            int i = 0;
            for (int damage : info.damages) {
                damagearray[i * 2] = (byte)(damage >> 8);
                damagearray[i * 2 + 1] = (byte)damage;
                ++i;
            }
            savecompound.a("d" + id, damagearray);
        }
        return savecompound;
    }

    public static void loadStates() {
        by hashSave = NEIClientConfig.global.nbt.l("vis");
        NEIClientConfig.global.nbt.a("vis", (cl)hashSave);
        int i = 0;
        while (i < 7) {
            by statesave = hashSave.l("save" + i);
            if (statesave.c().size() > 0) {
                ItemVisibilityHash.statesSaved[i] = true;
            }
            ++i;
        }
    }

    public void loadState(int i) {
        by hashSave = NEIClientConfig.global.nbt.l("vis");
        NEIClientConfig.global.nbt.a("vis", (cl)hashSave);
        this.loadFromCompound(hashSave.l("save" + i));
        DropDownFile.dropDownInstance.updateState();
        ItemList.updateSearch();
        NEIClientConfig.vishash.save();
    }

    public void saveState(int i) {
        by hashSave = NEIClientConfig.global.nbt.l("vis");
        NEIClientConfig.global.nbt.a("vis", (cl)hashSave);
        by saveCompound = this.getCurrentSaveCompound();
        saveCompound.a("saved", true);
        hashSave.a("save" + i, saveCompound);
        ItemVisibilityHash.statesSaved[i] = true;
        NEIClientConfig.global.saveNBT();
    }

    public void clearState(int i) {
        by hashSave = NEIClientConfig.global.nbt.l("vis");
        NEIClientConfig.global.nbt.a("vis", (cl)hashSave);
        hashSave.a("save" + i, new by());
        NEIClientConfig.global.saveNBT();
        ItemVisibilityHash.statesSaved[i] = false;
    }

    public static boolean isStateSaved(int i) {
        return statesSaved[i];
    }

    public static class IDInfo {
        public TreeSet<Integer> damages = new TreeSet();
        public ArrayList<by> compounds = new ArrayList();
    }
}

