/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.lighting.LazyLightMatrix;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.TextureUtils;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.JNormalOcclusion;
import codechicken.multipart.NormalOcclusionTest;
import codechicken.multipart.PartMap;
import codechicken.multipart.TFacePart;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import mrtjp.projectred.ProjectRedCore;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.core.BasicWireUtils;
import mrtjp.projectred.core.CommandDebug;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.core.WireConnLib;
import mrtjp.projectred.transmission.IWirePart;
import mrtjp.projectred.transmission.RenderWire;
import mrtjp.projectred.transmission.WireDef;
import mrtjp.projectred.transmission.WirePropogator;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;

public abstract class WirePart
extends TMultiPart
implements IConnectable,
TFacePart,
JNormalOcclusion,
IWirePart {
    public static Cuboid6[][] selectionBounds = new Cuboid6[3][6];
    public static Cuboid6[][] occlusionBounds = new Cuboid6[3][6];
    public byte side;
    public int connMap;

    public void preparePlacement(int n, int n2) {
        this.side = (byte)(n ^ 1);
    }

    public void save(by by2) {
        super.save(by2);
        by2.a("side", this.side);
        by2.a("connMap", this.connMap);
    }

    public void load(by by2) {
        super.load(by2);
        this.side = by2.c("side");
        this.connMap = by2.e("connMap");
    }

    public void writeDesc(MCDataOutput mCDataOutput) {
        mCDataOutput.writeByte((int)this.side);
        mCDataOutput.writeInt(this.connMap);
    }

    public void readDesc(MCDataInput mCDataInput) {
        this.side = mCDataInput.readByte();
        this.connMap = mCDataInput.readInt();
    }

    public void read(MCDataInput mCDataInput) {
        this.read(mCDataInput, mCDataInput.readUByte());
    }

    public void read(MCDataInput mCDataInput, int n) {
        if (n == 0) {
            this.connMap = mCDataInput.readInt();
            if (this.useStaticRenderer()) {
                this.tile().markRender();
            }
        }
    }

    public void onPartChanged(TMultiPart tMultiPart) {
        if (!this.world().I) {
            WirePropogator.logCalculation();
            boolean bl = this.updateInternalConnections();
            if (this.updateOpenConnections()) {
                bl |= this.updateExternalConnections();
            }
            if (bl) {
                this.sendConnUpdate();
                WirePropogator.propogateTo(this, 2);
            } else {
                WirePropogator.propogateTo(this, 0);
            }
        }
    }

    public void onNeighborChanged() {
        if (!this.world().I) {
            if (this.dropIfCantStay()) {
                return;
            }
            WirePropogator.logCalculation();
            if (this.updateExternalConnections()) {
                this.sendConnUpdate();
                WirePropogator.propogateTo(this, 2);
            } else {
                WirePropogator.propogateTo(this, 0);
            }
        }
    }

    public void onAdded() {
        super.onAdded();
        if (!this.world().I) {
            this.updateOpenConnections();
            boolean bl = this.updateInternalConnections();
            if (bl |= this.updateExternalConnections()) {
                this.sendConnUpdate();
            }
            WirePropogator.propogateTo(this, 0);
        }
    }

    public void onRemoved() {
        super.onRemoved();
        if (!this.world().I) {
            for (int i = 0; i < 4; ++i) {
                if (!this.maskConnects(i)) continue;
                if ((this.connMap & 1 << i) != 0) {
                    this.notifyCornerChange(i);
                    continue;
                }
                if ((this.connMap & 16 << i) == 0) continue;
                this.notifyStraightChange(i);
            }
        }
    }

    public void onChunkLoad() {
        if ((this.connMap & Integer.MIN_VALUE) != 0) {
            if (this.dropIfCantStay()) {
                return;
            }
            this.connMap = 0;
            this.updateInternalConnections();
            if (this.updateOpenConnections()) {
                this.updateExternalConnections();
            }
            this.tile().markDirty();
        }
    }

    public void sendConnUpdate() {
        this.tile().getWriteStream((TMultiPart)this).writeByte(0).writeInt(this.connMap);
    }

    public boolean canStay() {
        BlockCoord blockCoord = new BlockCoord((asp)this.tile()).offset((int)this.side);
        return BasicWireUtils.canPlaceWireOnSide((abw)this.world(), (int)blockCoord.x, (int)blockCoord.y, (int)blockCoord.z, (ForgeDirection)ForgeDirection.getOrientation((int)(this.side ^ 1)), (boolean)false);
    }

    public boolean dropIfCantStay() {
        if (!this.canStay()) {
            this.drop();
            return true;
        }
        return false;
    }

    public void drop() {
        TileMultipart.dropItem((ye)this.getItem(), (abw)this.world(), (Vector3)Vector3.fromTileEntityCenter((asp)this.tile()));
        this.tile().remPart((TMultiPart)this);
    }

    protected boolean updateExternalConnections() {
        int n;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < 4; ++n2) {
            if (!this.maskOpen(n2)) continue;
            if (this.connectStraight(n2)) {
                n3 |= 16 << n2;
                continue;
            }
            n = this.connectCorner(n2);
            if (n == 0) continue;
            n3 |= 1 << n2;
            if (n != 2) continue;
            n3 |= 0x100000 << n2;
        }
        if (n3 != (this.connMap & 0xF000FF)) {
            n2 = this.connMap ^ n3;
            this.connMap = this.connMap & 0xFF0FFF00 | n3;
            for (n = 0; n < 4; ++n) {
                if ((n2 & 1 << n) == 0) continue;
                this.notifyCornerChange(n);
            }
            return true;
        }
        return false;
    }

    protected boolean updateInternalConnections() {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            if (!this.connectInternal(i)) continue;
            n |= 256 << i;
        }
        if (this.connectCenter()) {
            n |= 0x10000;
        }
        if (n != (this.connMap & 0x10F00)) {
            this.connMap = this.connMap & 0xFFFEF0FF | n;
            return true;
        }
        return false;
    }

    protected boolean updateOpenConnections() {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            if (!this.connectionOpen(i)) continue;
            n |= 4096 << i;
        }
        if (n != (this.connMap & 0xF000)) {
            this.connMap = this.connMap & 0xFFFF0FFF | n;
            return true;
        }
        return false;
    }

    public boolean connectionOpen(int n) {
        int n2 = Rotation.rotateSide((int)this.side, (int)n);
        TMultiPart tMultiPart = this.tile().partMap(n2);
        if (!(tMultiPart == null || tMultiPart instanceof WirePart && this.canConnectToType((WirePart)tMultiPart))) {
            return false;
        }
        return this.tile().partMap(PartMap.edgeBetween((int)this.side, (int)n2)) == null;
    }

    public int connectCorner(int n) {
        boolean bl;
        int n2 = Rotation.rotateSide((int)this.side, (int)n);
        IConnectable iConnectable = WireConnLib.getCorner((abw)this.world(), (int)this.side, (int)n, (BlockCoord)new BlockCoord((asp)this.tile()));
        if (iConnectable != null && (bl = iConnectable.connectCorner((IConnectable)this, Rotation.rotationTo((int)(n2 ^ 1), (int)(this.side ^ 1)), -1))) {
            if (!this.renderThisCorner(iConnectable)) {
                return 1;
            }
            return 2;
        }
        return this.connectCornerOverride(n2) ? 2 : 0;
    }

    public boolean connectCornerOverride(int n) {
        return false;
    }

    public boolean connectStraight(int n) {
        IConnectable iConnectable = WireConnLib.getStraight((abw)this.world(), (int)this.side, (int)n, (BlockCoord)new BlockCoord((asp)this.tile()));
        if (iConnectable != null) {
            return iConnectable.connectStraight((IConnectable)this, (n + 2) % 4, -1);
        }
        int n2 = Rotation.rotateSide((int)this.side, (int)n);
        return this.connectStraightOverride(n2);
    }

    public boolean connectStraightOverride(int n) {
        return false;
    }

    public boolean connectInternal(int n) {
        int n2 = Rotation.rotateSide((int)this.side, (int)n);
        if (this.tile().partMap(PartMap.edgeBetween((int)n2, (int)this.side)) != null) {
            return false;
        }
        TMultiPart tMultiPart = this.tile().partMap(n2);
        if (tMultiPart instanceof IConnectable) {
            return ((IConnectable)tMultiPart).connectInternal((IConnectable)this, Rotation.rotationTo((int)n2, (int)this.side));
        }
        return this.connectInternalOverride(tMultiPart, n);
    }

    public boolean connectInternalOverride(TMultiPart tMultiPart, int n) {
        return false;
    }

    public boolean connectCenter() {
        IConnectable iConnectable = WireConnLib.getCenter((abw)this.world(), (BlockCoord)new BlockCoord((asp)this.tile()));
        if (iConnectable != null) {
            return iConnectable.connectInternal((IConnectable)this, (int)this.side);
        }
        return false;
    }

    public boolean renderThisCorner(IConnectable iConnectable) {
        if (!(iConnectable instanceof WirePart)) {
            return true;
        }
        WirePart wirePart = (WirePart)iConnectable;
        if (wirePart.getThickness() == this.getThickness()) {
            return this.side < wirePart.side;
        }
        return wirePart.getThickness() > this.getThickness();
    }

    public boolean connectCorner(IConnectable iConnectable, int n, int n2) {
        if (this.canConnectToType(iConnectable) && this.maskOpen(n)) {
            int n3 = this.connMap;
            this.connMap |= 1 << n;
            if (this.renderThisCorner(iConnectable)) {
                this.connMap |= 0x100000 << n;
            }
            if (n3 != this.connMap) {
                this.sendConnUpdate();
            }
            return true;
        }
        return false;
    }

    public boolean connectStraight(IConnectable iConnectable, int n, int n2) {
        if (this.canConnectToType(iConnectable) && this.maskOpen(n)) {
            int n3 = this.connMap;
            this.connMap |= 16 << n;
            if (n3 != this.connMap) {
                this.sendConnUpdate();
            }
            return true;
        }
        return false;
    }

    public boolean connectInternal(IConnectable iConnectable, int n) {
        if (this.canConnectToType(iConnectable)) {
            int n2 = this.connMap;
            this.connMap |= 256 << n;
            if (n2 != this.connMap) {
                this.sendConnUpdate();
            }
            return true;
        }
        return false;
    }

    public boolean canConnectCorner(int n) {
        return true;
    }

    public abstract boolean canConnectToType(IConnectable var1);

    public void notifyCornerChange(int n) {
        int n2 = Rotation.rotateSide((int)this.side, (int)n);
        BlockCoord blockCoord = new BlockCoord((asp)this.tile()).offset(n2).offset((int)this.side);
        this.world().g(blockCoord.x, blockCoord.y, blockCoord.z, this.tile().q().cF);
    }

    public void notifyStraightChange(int n) {
        int n2 = Rotation.rotateSide((int)this.side, (int)n);
        BlockCoord blockCoord = new BlockCoord((asp)this.tile()).offset(n2);
        this.world().g(blockCoord.x, blockCoord.y, blockCoord.z, this.tile().q().cF);
    }

    public boolean maskConnects(int n) {
        return (this.connMap & 273 << n) != 0;
    }

    public boolean maskOpen(int n) {
        return (this.connMap & 4096 << n) != 0;
    }

    public void propogate(TMultiPart tMultiPart, int n) {
        if (n != 3) {
            WirePropogator.addPartChange(this);
        }
        for (int i = 0; i < 4; ++i) {
            if ((this.connMap & 1 << i) != 0) {
                this.propogateCorner(i, tMultiPart, n);
                continue;
            }
            if ((this.connMap & 16 << i) != 0) {
                this.propogateStraight(i, tMultiPart, n);
                continue;
            }
            if ((this.connMap & 256 << i) == 0) continue;
            this.propogateInternal(i, tMultiPart, n);
        }
        if ((this.connMap & 0x10000) != 0) {
            this.propogateCenter(tMultiPart, n);
        }
        this.propogateOther(n);
    }

    public void propogateCorner(int n, TMultiPart tMultiPart, int n2) {
        int n3 = Rotation.rotateSide((int)this.side, (int)n);
        BlockCoord blockCoord = new BlockCoord((asp)this.tile()).offset(n3).offset((int)this.side);
        IConnectable iConnectable = WireConnLib.getCorner((abw)this.world(), (int)this.side, (int)n, (BlockCoord)new BlockCoord((asp)this.tile()));
        if (iConnectable == tMultiPart) {
            return;
        }
        if (this.propogateTo(iConnectable, n2)) {
            return;
        }
        WirePropogator.addNeighborChange(blockCoord);
    }

    public void propogateStraight(int n, TMultiPart tMultiPart, int n2) {
        int n3 = Rotation.rotateSide((int)this.side, (int)n);
        BlockCoord blockCoord = new BlockCoord((asp)this.tile()).offset(n3);
        IConnectable iConnectable = WireConnLib.getStraight((abw)this.world(), (int)this.side, (int)n, (BlockCoord)new BlockCoord((asp)this.tile()));
        if (iConnectable == tMultiPart) {
            return;
        }
        if (this.propogateTo(iConnectable, n2)) {
            return;
        }
        WirePropogator.addNeighborChange(blockCoord);
    }

    public void propogateInternal(int n, TMultiPart tMultiPart, int n2) {
        IConnectable iConnectable = WireConnLib.getInsideFace((abw)this.world(), (int)this.side, (int)n, (BlockCoord)new BlockCoord((asp)this.tile()));
        if (iConnectable == tMultiPart) {
            return;
        }
        this.propogateTo(iConnectable, n2);
    }

    public void propogateCenter(TMultiPart tMultiPart, int n) {
        IConnectable iConnectable = WireConnLib.getCenter((abw)this.world(), (BlockCoord)new BlockCoord((asp)this.tile()));
        if (iConnectable == tMultiPart) {
            return;
        }
        this.propogateTo(iConnectable, n);
    }

    public void propogateOther(int n) {
    }

    public boolean propogateTo(Object object, int n) {
        if (object instanceof IWirePart) {
            WirePropogator.propogateTo((IWirePart)object, this, n);
            return true;
        }
        return false;
    }

    @Override
    public void onSignalUpdate() {
        this.tile().markDirty();
    }

    @Override
    public boolean isWireSide(int n) {
        return true;
    }

    protected abstract boolean debug(uf var1);

    protected abstract boolean test(uf var1);

    public abstract WireDef getWireType();

    public int getThickness() {
        return this.getWireType().thickness();
    }

    public String getType() {
        return this.getWireType().wireType();
    }

    public float getStrength(ata ata2, uf uf2) {
        return 4.0f;
    }

    public ye getItem() {
        return this.getWireType().getItemStack();
    }

    public Iterable<ye> getDrops() {
        return Arrays.asList(this.getItem());
    }

    public ye pickItem(ata ata2) {
        return this.getItem();
    }

    public int getSlotMask() {
        return 1 << this.side;
    }

    public Iterable<IndexedCuboid6> getSubParts() {
        return Arrays.asList(new IndexedCuboid6((Object)0, selectionBounds[this.getThickness()][this.side]));
    }

    public boolean occlusionTest(TMultiPart tMultiPart) {
        return NormalOcclusionTest.apply((JNormalOcclusion)this, (TMultiPart)tMultiPart);
    }

    public Iterable<Cuboid6> getOcclusionBoxes() {
        return Arrays.asList(occlusionBounds[this.getThickness()][this.side]);
    }

    public int redstoneConductionMap() {
        return 15;
    }

    public boolean solid(int n) {
        return false;
    }

    public boolean activate(uf uf2, ata ata2, ye ye2) {
        if (CommandDebug.WIRE_READING) {
            return this.debug(uf2);
        }
        if (ye2 != null && ye2.d == ProjectRedCore.itemWireDebugger().cv) {
            ye2.a(1, (of)uf2);
            uf2.aV();
            return this.test(uf2);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public ms getIcon() {
        return this.getWireType().wireSprites()[0];
    }

    public int getColour() {
        return -1;
    }

    public boolean useStaticRenderer() {
        return Configurator.staticWires;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderStatic(Vector3 vector3, LazyLightMatrix lazyLightMatrix, int n) {
        if (n == 0 && this.useStaticRenderer()) {
            CCRenderState.setBrightness((acf)this.world(), (int)this.x(), (int)this.y(), (int)this.z());
            RenderWire.render(this, vector3);
            CCRenderState.setColour((int)-1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Vector3 vector3, float f, int n) {
        if (n == 0 && !this.useStaticRenderer()) {
            GL11.glDisable((int)2896);
            TextureUtils.bindAtlas((int)0);
            CCRenderState.useModelColours((boolean)true);
            CCRenderState.startDrawing((int)7);
            RenderWire.render(this, vector3);
            CCRenderState.draw();
            CCRenderState.setColour((int)-1);
            GL11.glEnable((int)2896);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drawBreaking(bfr bfr2) {
        CCRenderState.reset();
        RenderWire.renderBreakingOverlay(bfr2.d, this);
    }

    public boolean doesTick() {
        return false;
    }

    static {
        for (int i = 0; i < 3; ++i) {
            Cuboid6 cuboid6 = new Cuboid6(0.0, 0.0, 0.0, 1.0, (double)(i + 2) / 16.0, 1.0).expand(-0.005);
            Cuboid6 cuboid62 = new Cuboid6(0.25, 0.0, 0.25, 0.75, (double)(i + 2) / 16.0, 0.75);
            for (int j = 0; j < 6; ++j) {
                WirePart.selectionBounds[i][j] = cuboid6.copy().apply(Rotation.sideRotations[j].at(Vector3.center));
                WirePart.occlusionBounds[i][j] = cuboid62.copy().apply(Rotation.sideRotations[j].at(Vector3.center));
            }
        }
    }
}

