/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.vec.BlockCoord;
import codechicken.multipart.IMaskedRedstonePart;
import codechicken.multipart.IRedstonePart;
import codechicken.multipart.RedstoneInteractions;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.core.BasicUtils;
import mrtjp.projectred.core.CoreSPH;
import mrtjp.projectred.core.Messenger;
import mrtjp.projectred.transmission.FramedWirePart;
import mrtjp.projectred.transmission.IRedwireEmitter;
import mrtjp.projectred.transmission.IRedwirePart;
import mrtjp.projectred.transmission.WirePropogator;

public abstract class FramedRedwirePart
extends FramedWirePart
implements IRedwirePart,
IMaskedRedstonePart {
    public byte signal;

    @Override
    public void save(by by2) {
        super.save(by2);
        by2.a("signal", this.signal);
    }

    @Override
    public void load(by by2) {
        super.load(by2);
        this.signal = by2.c("signal");
    }

    @Override
    public void writeDesc(MCDataOutput mCDataOutput) {
        super.writeDesc(mCDataOutput);
        mCDataOutput.writeByte((int)this.signal);
    }

    @Override
    public void readDesc(MCDataInput mCDataInput) {
        super.readDesc(mCDataInput);
        this.signal = mCDataInput.readByte();
    }

    @Override
    public void read(MCDataInput mCDataInput, int n) {
        if (n == 10) {
            this.signal = mCDataInput.readByte();
            if (this.useStaticRenderer()) {
                this.tile().markRender();
            }
        } else {
            super.read(mCDataInput, n);
        }
    }

    public int strongPowerLevel(int n) {
        return 0;
    }

    public int weakPowerLevel(int n) {
        return this.rsLevel();
    }

    public boolean canConnectRedstone(int n) {
        return true;
    }

    public int rsLevel() {
        if (WirePropogator.redwiresProvidePower) {
            return ((this.signal & 0xFF) + 16) / 17;
        }
        return 0;
    }

    public int getConnectionMask(int n) {
        return 16;
    }

    @Override
    public boolean canConnectToType(IConnectable iConnectable) {
        return iConnectable instanceof IRedwirePart;
    }

    @Override
    public boolean connectStraightOverride(int n) {
        WirePropogator.setRedwiresConnectable(false);
        boolean bl = (RedstoneInteractions.otherConnectionMask((acf)this.world(), (int)this.x(), (int)this.y(), (int)this.z(), (int)n, (boolean)false) & RedstoneInteractions.connectionMask((TMultiPart)this, (int)n)) != 0;
        WirePropogator.setRedwiresConnectable(true);
        return bl;
    }

    @Override
    public boolean connectInternalOverride(TMultiPart tMultiPart, int n) {
        if (tMultiPart instanceof IRedstonePart) {
            IRedstonePart iRedstonePart = (IRedstonePart)tMultiPart;
            return iRedstonePart.canConnectRedstone(n ^ 1);
        }
        return false;
    }

    @Override
    public void updateAndPropogate(TMultiPart tMultiPart, int n) {
        if (n == 1 && this.signal == 0) {
            return;
        }
        int n2 = this.calculateSignal();
        if (n2 < this.getRedwireSignal()) {
            if (n2 > 0) {
                WirePropogator.propogateAnalogDrop(this);
            }
            this.signal = 0;
            this.propogate(tMultiPart, 1);
        } else if (n2 > this.getRedwireSignal()) {
            this.signal = (byte)n2;
            if (n == 1) {
                this.propogate(null, 0);
            } else {
                this.propogate(tMultiPart, 0);
            }
        } else if (n == 1) {
            this.propogateTo(tMultiPart, 0);
        } else if (n == 2) {
            this.propogate(tMultiPart, 3);
        }
    }

    @Override
    public void propogateOther(int n) {
        for (int i = 0; i < 6; ++i) {
            if (this.maskConnects(i)) continue;
            WirePropogator.addNeighborChange(new BlockCoord((asp)this.tile()).offset(i));
        }
    }

    @Override
    public void onSignalUpdate() {
        super.onSignalUpdate();
        this.tile().getWriteStream((TMultiPart)this).writeByte(10).writeByte((int)this.signal);
    }

    public int calculateSignal() {
        WirePropogator.setWiresProvidePower(false);
        WirePropogator.redwiresProvidePower = false;
        int n = 0;
        for (int i = 0; i < 6; ++i) {
            int n2;
            if (!this.maskConnects(i) || (n2 = (this.connMap & 1 << i) != 0 ? this.calculateStraightSignal(i) : this.calculateInternalSignal(i)) <= n) continue;
            n = n2;
        }
        WirePropogator.setWiresProvidePower(true);
        WirePropogator.redwiresProvidePower = true;
        return n;
    }

    public int calculateStraightSignal(int n) {
        TMultiPart tMultiPart;
        BlockCoord blockCoord = new BlockCoord((asp)this.tile()).offset(n);
        TileMultipart tileMultipart = BasicUtils.getMultipartTile((acf)this.world(), (BlockCoord)blockCoord);
        if (tileMultipart != null && (tMultiPart = tileMultipart.partMap(6)) != null) {
            return this.getPartSignal(tMultiPart, n ^ 1);
        }
        return RedstoneInteractions.getPowerTo((TMultiPart)this, (int)n) * 17;
    }

    public int calculateInternalSignal(int n) {
        TMultiPart tMultiPart = this.tile().partMap(n);
        int n2 = this.getPartSignal(tMultiPart, -1);
        if (n2 > 0) {
            return n2;
        }
        if (tMultiPart instanceof IRedstonePart) {
            IRedstonePart iRedstonePart = (IRedstonePart)tMultiPart;
            return Math.max(iRedstonePart.strongPowerLevel(n ^ 1), iRedstonePart.weakPowerLevel(n ^ 1)) << 4;
        }
        return 0;
    }

    public int getPartSignal(TMultiPart tMultiPart, int n) {
        if (tMultiPart instanceof IRedwirePart && ((IRedwirePart)tMultiPart).isWireSide(n)) {
            return ((IRedwirePart)tMultiPart).getRedwireSignal(n) - 1;
        }
        if (tMultiPart instanceof IRedwireEmitter) {
            return ((IRedwireEmitter)tMultiPart).getRedwireSignal(n);
        }
        return 0;
    }

    public int getRedwireSignal() {
        return this.signal & 0xFF;
    }

    @Override
    public int getRedwireSignal(int n) {
        return this.getRedwireSignal();
    }

    @Override
    protected boolean test(uf uf2) {
        if (BasicUtils.isClient((abw)this.world())) {
            Messenger.addMessage((double)this.x(), (double)((float)this.y() + 0.5f), (double)this.z(), (String)("/#f/#c[c] = " + this.getRedwireSignal()));
        } else {
            PacketCustom packetCustom = new PacketCustom((Object)CoreSPH.channel(), CoreSPH.messagePacket());
            packetCustom.writeDouble((double)this.x() + 0.0);
            packetCustom.writeDouble((double)this.y() + 0.5);
            packetCustom.writeDouble((double)this.z() + 0.0);
            packetCustom.writeString("/#c[s] = " + this.getRedwireSignal());
            packetCustom.sendToPlayer(uf2);
        }
        return true;
    }
}

