/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.multipart.TMultiPart;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.transmission.FramedRedwirePart;
import mrtjp.projectred.transmission.IBundledCablePart;
import mrtjp.projectred.transmission.IInsulatedRedwirePart;
import mrtjp.projectred.transmission.IRedwirePart;
import mrtjp.projectred.transmission.WireDef;

public class FramedInsulatedRedAlloyPart
extends FramedRedwirePart
implements IInsulatedRedwirePart {
    public byte colour;

    @Override
    public WireDef getWireType() {
        return WireDef.INSULATED_WIRE()[this.colour];
    }

    @Override
    public void preparePlacement(int n) {
        super.preparePlacement(n);
        this.colour = (byte)(n - WireDef.INSULATED_0().meta());
    }

    @Override
    public void save(by by2) {
        super.save(by2);
        by2.a("colour", this.colour);
    }

    @Override
    public void load(by by2) {
        super.load(by2);
        this.colour = by2.c("colour");
    }

    @Override
    public void writeDesc(MCDataOutput mCDataOutput) {
        super.writeDesc(mCDataOutput);
        mCDataOutput.writeByte((int)this.colour);
    }

    @Override
    public void readDesc(MCDataInput mCDataInput) {
        super.readDesc(mCDataInput);
        this.colour = mCDataInput.readByte();
    }

    @Override
    public int getPartSignal(TMultiPart tMultiPart, int n) {
        if (tMultiPart instanceof IBundledCablePart) {
            return (((IBundledCablePart)tMultiPart).getBundledSignal()[this.colour] & 0xFF) - 1;
        }
        return super.getPartSignal(tMultiPart, n);
    }

    @Override
    public boolean canConnectToType(IConnectable iConnectable) {
        if (iConnectable instanceof IInsulatedRedwirePart) {
            return ((IInsulatedRedwirePart)iConnectable).getInsulatedColour() == this.colour;
        }
        return iConnectable instanceof IBundledCablePart || iConnectable instanceof IRedwirePart;
    }

    @Override
    public int weakPowerLevel(int n) {
        if (!this.maskConnects(n)) {
            return 0;
        }
        return super.weakPowerLevel(n);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ms getIcon() {
        return this.getWireType().wireSprites()[this.signal != 0 ? 1 : 0];
    }

    @Override
    public int getInsulatedColour() {
        return this.colour;
    }
}

