/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission;

import codechicken.lib.packet.PacketCustom;
import codechicken.lib.vec.BlockCoord;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import java.util.Arrays;
import mrtjp.projectred.api.IBundledEmitter;
import mrtjp.projectred.api.IBundledTile;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.core.BasicUtils;
import mrtjp.projectred.core.CoreSPH;
import mrtjp.projectred.transmission.BundledCableCommons;
import mrtjp.projectred.transmission.FramedWirePart;
import mrtjp.projectred.transmission.IBundledCablePart;
import mrtjp.projectred.transmission.IInsulatedRedwirePart;
import mrtjp.projectred.transmission.WireDef;

public class FramedBundledCablePart
extends FramedWirePart
implements IBundledCablePart {
    public byte[] signal = new byte[16];

    @Override
    public WireDef getWireType() {
        return WireDef.BUNDLED_N();
    }

    @Override
    public void save(by by2) {
        super.save(by2);
        by2.a("signal", this.signal);
    }

    @Override
    public void load(by by2) {
        super.load(by2);
        this.signal = by2.j("signal");
    }

    @Override
    public boolean canConnectToType(IConnectable iConnectable) {
        return iConnectable instanceof IInsulatedRedwirePart || iConnectable instanceof IBundledEmitter;
    }

    @Override
    public boolean connectStraightOverride(int n) {
        BlockCoord blockCoord = new BlockCoord((asp)this.tile()).offset(n);
        asp asp2 = this.world().r(blockCoord.x, blockCoord.y, blockCoord.z);
        if (asp2 instanceof IBundledTile) {
            return ((IBundledTile)asp2).canConnectBundled(n ^ 1);
        }
        return false;
    }

    @Override
    public void updateAndPropogate(TMultiPart tMultiPart, int n) {
        BundledCableCommons.updateAndPropogate(this, tMultiPart, n);
    }

    @Override
    public boolean propogateTo(TMultiPart tMultiPart, int n) {
        if (!BundledCableCommons.shouldPropogate(this, tMultiPart, n)) {
            return true;
        }
        return super.propogateTo(tMultiPart, n);
    }

    @Override
    public void setSignal(byte[] byArray) {
        if (byArray == null) {
            Arrays.fill(this.signal, (byte)0);
        } else {
            System.arraycopy(byArray, 0, this.signal, 0, 16);
        }
    }

    @Override
    public byte[] calculateSignal() {
        Arrays.fill(BundledCableCommons.tmpSignal, (byte)0);
        for (int i = 0; i < 6; ++i) {
            if (!this.maskConnects(i)) continue;
            if ((this.connMap & 1 << i) != 0) {
                this.calculateStraightSignal(i);
                continue;
            }
            this.calculateInternalSignal(i);
        }
        return BundledCableCommons.tmpSignal;
    }

    public void calculateStraightSignal(int n) {
        BlockCoord blockCoord = new BlockCoord((asp)this.tile()).offset(n);
        asp asp2 = this.world().r(blockCoord.x, blockCoord.y, blockCoord.z);
        if (asp2 instanceof IBundledEmitter) {
            BundledCableCommons.calculatePartSignal(asp2, n ^ 1);
        } else if (asp2 instanceof TileMultipart) {
            BundledCableCommons.calculatePartSignal(((TileMultipart)asp2).partMap(6), n ^ 1);
        }
    }

    public void calculateInternalSignal(int n) {
        BundledCableCommons.calculatePartSignal(this.tile().partMap(n), -1);
    }

    @Override
    public byte[] getBundledSignal() {
        return this.signal;
    }

    public byte[] getBundledSignal(int n) {
        return this.maskConnects(n) ? this.getBundledSignal() : null;
    }

    @Override
    protected boolean test(uf uf2) {
        if (BasicUtils.isServer((abw)this.world())) {
            String string = "";
            for (int i = 0; i < 16; ++i) {
                byte by2 = this.getBundledSignal()[i];
                if (by2 == 0) continue;
                string = string + "[" + i + "]";
            }
            if (string.equals("")) {
                string = "off";
            }
            PacketCustom packetCustom = new PacketCustom((Object)CoreSPH.channel(), CoreSPH.messagePacket());
            packetCustom.writeDouble((double)this.x() + 0.0);
            packetCustom.writeDouble((double)this.y() + 0.5);
            packetCustom.writeDouble((double)this.z() + 0.0);
            packetCustom.writeString("/#f" + string);
            packetCustom.sendToPlayer(uf2);
        }
        return true;
    }
}

