/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Rotation;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import java.util.Arrays;
import mrtjp.projectred.api.IBundledEmitter;
import mrtjp.projectred.api.IBundledTile;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.core.BasicUtils;
import mrtjp.projectred.core.CoreSPH;
import mrtjp.projectred.transmission.BundledCableCommons;
import mrtjp.projectred.transmission.IBundledCablePart;
import mrtjp.projectred.transmission.IInsulatedRedwirePart;
import mrtjp.projectred.transmission.WireDef;
import mrtjp.projectred.transmission.WirePart;

public class BundledCablePart
extends WirePart
implements IBundledCablePart {
    public byte[] signal = new byte[16];
    public byte colour;

    @Override
    public WireDef getWireType() {
        return WireDef.BUNDLED_WIRE()[this.colour + 1];
    }

    @Override
    public void preparePlacement(int n, int n2) {
        super.preparePlacement(n, n2);
        this.colour = (byte)(n2 - WireDef.BUNDLED_0().meta());
    }

    @Override
    public void save(by by2) {
        super.save(by2);
        by2.a("signal", this.signal);
        by2.a("colour", this.colour);
    }

    @Override
    public void load(by by2) {
        super.load(by2);
        this.signal = by2.j("signal");
        this.colour = by2.c("colour");
    }

    @Override
    public void writeDesc(MCDataOutput mCDataOutput) {
        super.writeDesc(mCDataOutput);
        mCDataOutput.writeByte((int)this.colour);
    }

    @Override
    public void readDesc(MCDataInput mCDataInput) {
        super.readDesc(mCDataInput);
        this.colour = mCDataInput.readByte();
    }

    @Override
    public boolean canConnectToType(IConnectable iConnectable) {
        if (iConnectable instanceof BundledCablePart) {
            byte by2 = ((BundledCablePart)iConnectable).colour;
            return by2 == -1 || this.colour == -1 || by2 == this.colour;
        }
        return iConnectable instanceof IInsulatedRedwirePart || iConnectable instanceof IBundledEmitter;
    }

    @Override
    public boolean connectStraightOverride(int n) {
        BlockCoord blockCoord = new BlockCoord((asp)this.tile()).offset(n);
        asp asp2 = this.world().r(blockCoord.x, blockCoord.y, blockCoord.z);
        if (asp2 instanceof IBundledTile) {
            return ((IBundledTile)asp2).canConnectBundled(n ^ 1);
        }
        return false;
    }

    @Override
    public void updateAndPropogate(TMultiPart tMultiPart, int n) {
        BundledCableCommons.updateAndPropogate(this, tMultiPart, n);
    }

    @Override
    public boolean propogateTo(TMultiPart tMultiPart, int n) {
        if (!BundledCableCommons.shouldPropogate(this, tMultiPart, n)) {
            return true;
        }
        return super.propogateTo((IConnectable)tMultiPart, n);
    }

    @Override
    public void setSignal(byte[] byArray) {
        if (byArray == null) {
            Arrays.fill(this.signal, (byte)0);
        } else {
            System.arraycopy(byArray, 0, this.signal, 0, 16);
        }
    }

    @Override
    public byte[] calculateSignal() {
        Arrays.fill(BundledCableCommons.tmpSignal, (byte)0);
        for (int i = 0; i < 4; ++i) {
            if (!this.maskConnects(i)) continue;
            if ((this.connMap & 1 << i) != 0) {
                this.calculateCornerSignal(i);
                continue;
            }
            if ((this.connMap & 16 << i) != 0) {
                this.calculateStraightSignal(i);
            }
            this.calculateInternalSignal(i);
        }
        this.calculateCenterSignal();
        return BundledCableCommons.tmpSignal;
    }

    public void calculateCornerSignal(int n) {
        int n2 = Rotation.rotateSide((int)this.side, (int)n);
        BlockCoord blockCoord = new BlockCoord((asp)this.tile()).offset(n2).offset((int)this.side);
        TileMultipart tileMultipart = BasicUtils.getMultipartTile((acf)this.world(), (BlockCoord)blockCoord);
        if (tileMultipart != null) {
            BundledCableCommons.calculatePartSignal(tileMultipart.partMap(n2 ^ 1), Rotation.rotationTo((int)(n2 ^ 1), (int)(this.side ^ 1)));
        }
    }

    public void calculateStraightSignal(int n) {
        int n2 = Rotation.rotateSide((int)this.side, (int)n);
        BlockCoord blockCoord = new BlockCoord((asp)this.tile()).offset(n2);
        asp asp2 = this.world().r(blockCoord.x, blockCoord.y, blockCoord.z);
        if (asp2 instanceof IBundledEmitter) {
            BundledCableCommons.calculatePartSignal(asp2, n2 ^ 1);
        } else if (asp2 instanceof TileMultipart) {
            BundledCableCommons.calculatePartSignal(((TileMultipart)asp2).partMap((int)this.side), (n + 2) % 4);
        }
    }

    public void calculateInternalSignal(int n) {
        int n2 = Rotation.rotateSide((int)this.side, (int)n);
        BundledCableCommons.calculatePartSignal(this.tile().partMap(n2), (n + 2) % 4);
    }

    public void calculateCenterSignal() {
        BundledCableCommons.calculatePartSignal(this.tile().partMap(6), this.side);
    }

    @Override
    public byte[] getBundledSignal() {
        return this.signal;
    }

    public byte[] getBundledSignal(int n) {
        return this.maskConnects(n) ? this.getBundledSignal() : null;
    }

    @Override
    protected boolean debug(uf uf2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            String string = Integer.toHexString(this.signal[i] & 0xFF).toUpperCase();
            if (string.length() == 1) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string);
        }
        uf2.a(cv.e((String)stringBuilder.toString()));
        return true;
    }

    @Override
    protected boolean test(uf uf2) {
        if (BasicUtils.isServer((abw)this.world())) {
            String string = "";
            for (int i = 0; i < 16; ++i) {
                byte by2 = this.getBundledSignal()[i];
                if (by2 == 0) continue;
                string = string + "[" + i + "]";
            }
            if (string.equals("")) {
                string = "off";
            }
            PacketCustom packetCustom = new PacketCustom((Object)CoreSPH.channel(), CoreSPH.messagePacket());
            packetCustom.writeDouble((double)this.x() + 0.0);
            packetCustom.writeDouble((double)this.y() + 0.5);
            packetCustom.writeDouble((double)this.z() + 0.0);
            packetCustom.writeString("/#f" + string);
            packetCustom.sendToPlayer(uf2);
        }
        return true;
    }

    @Override
    public boolean useStaticRenderer() {
        return true;
    }
}

