/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission;

import codechicken.multipart.TMultiPart;
import java.util.Arrays;
import mrtjp.projectred.api.IBundledEmitter;
import mrtjp.projectred.transmission.IBundledCablePart;
import mrtjp.projectred.transmission.IInsulatedRedwirePart;
import mrtjp.projectred.transmission.WirePropogator;

public class BundledCableCommons {
    public static byte[] tmpSignal = new byte[16];
    private static int propogatingMask = 65535;

    public static boolean signalsEqual(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            return BundledCableCommons.isSignalZero(byArray2);
        }
        if (byArray2 == null) {
            return BundledCableCommons.isSignalZero(byArray);
        }
        return Arrays.equals(byArray, byArray2);
    }

    public static boolean isSignalZero(byte[] byArray) {
        if (byArray == null) {
            return true;
        }
        for (int i = 0; i < 16; ++i) {
            if (byArray[i] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isSignalZero(byte[] byArray, int n) {
        if (byArray == null) {
            return true;
        }
        for (int i = 0; i < 16; ++i) {
            if ((n & 1 << i) == 0 || byArray[i] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean dropSignalsLessThan(byte[] byArray, byte[] byArray2) {
        boolean bl = false;
        for (int i = 0; i < 16; ++i) {
            if ((byArray2[i] & 0xFF) >= (byArray[i] & 0xFF)) continue;
            byArray[i] = 0;
            bl = true;
        }
        return bl;
    }

    public static void applyChangeMask(byte[] byArray, byte[] byArray2, int n) {
        for (int i = 0; i < 16; ++i) {
            if ((n & 1 << i) != 0) continue;
            byArray2[i] = byArray[i];
        }
    }

    public static void updateAndPropogate(IBundledCablePart iBundledCablePart, TMultiPart tMultiPart, int n) {
        int n2 = BundledCableCommons.getUpdateMask(iBundledCablePart, tMultiPart, n);
        if (n == 1 && BundledCableCommons.isSignalZero(iBundledCablePart.getBundledSignal(), n2)) {
            return;
        }
        byte[] byArray = iBundledCablePart.calculateSignal();
        BundledCableCommons.applyChangeMask(iBundledCablePart.getBundledSignal(), byArray, n2);
        propogatingMask = n2;
        if (BundledCableCommons.dropSignalsLessThan(iBundledCablePart.getBundledSignal(), byArray)) {
            if (!BundledCableCommons.isSignalZero(byArray, n2)) {
                WirePropogator.propogateAnalogDrop(iBundledCablePart);
            }
            iBundledCablePart.propogate(tMultiPart, 1);
        } else if (!BundledCableCommons.signalsEqual(iBundledCablePart.getBundledSignal(), byArray)) {
            iBundledCablePart.setSignal(byArray);
            if (n == 1) {
                iBundledCablePart.propogate(null, 0);
            } else {
                iBundledCablePart.propogate(tMultiPart, 0);
            }
        } else if (n == 1) {
            iBundledCablePart.propogateTo(tMultiPart, 0);
        } else if (n == 2) {
            iBundledCablePart.propogate(tMultiPart, 3);
        }
        propogatingMask = 65535;
    }

    public static int getUpdateMask(IBundledCablePart iBundledCablePart, TMultiPart tMultiPart, int n) {
        if (tMultiPart instanceof IInsulatedRedwirePart) {
            return 1 << ((IInsulatedRedwirePart)tMultiPart).getInsulatedColour();
        }
        if (tMultiPart instanceof IBundledCablePart) {
            byte[] byArray = ((IBundledCablePart)tMultiPart).getBundledSignal();
            if (n == 1) {
                int n2 = 0;
                for (int i = 0; i < 16; ++i) {
                    if (byArray[i] != 0) continue;
                    n2 |= 1 << i;
                }
                return n2;
            }
            if (n == 0) {
                int n3 = 0;
                for (int i = 0; i < 16; ++i) {
                    if ((byArray[i] & 0xFF) <= (iBundledCablePart.getBundledSignal()[i] & 0xFF)) continue;
                    n3 |= 1 << i;
                }
                return n3;
            }
        }
        return 65535;
    }

    public static boolean shouldPropogate(IBundledCablePart iBundledCablePart, TMultiPart tMultiPart, int n) {
        return !(tMultiPart instanceof IInsulatedRedwirePart) || (propogatingMask & 1 << ((IInsulatedRedwirePart)tMultiPart).getInsulatedColour()) != 0;
    }

    public static void calculatePartSignal(Object object, int n) {
        block4: {
            byte[] byArray;
            block5: {
                block3: {
                    if (!(object instanceof IBundledCablePart)) break block3;
                    byte[] byArray2 = ((IBundledCablePart)object).getBundledSignal();
                    for (int i = 0; i < 16; ++i) {
                        if ((byArray2[i] & 0xFF) - 1 <= (tmpSignal[i] & 0xFF)) continue;
                        BundledCableCommons.tmpSignal[i] = (byte)(byArray2[i] - 1);
                    }
                    break block4;
                }
                if (!(object instanceof IInsulatedRedwirePart)) break block5;
                IInsulatedRedwirePart iInsulatedRedwirePart = (IInsulatedRedwirePart)object;
                int n2 = iInsulatedRedwirePart.getRedwireSignal(n) - 1;
                if (n2 <= (tmpSignal[iInsulatedRedwirePart.getInsulatedColour()] & 0xFF)) break block4;
                BundledCableCommons.tmpSignal[iInsulatedRedwirePart.getInsulatedColour()] = (byte)n2;
                break block4;
            }
            if (object instanceof IBundledEmitter && (byArray = ((IBundledEmitter)object).getBundledSignal(n)) != null) {
                for (int i = 0; i < 16; ++i) {
                    if ((byArray[i] & 0xFF) <= (tmpSignal[i] & 0xFF)) continue;
                    BundledCableCommons.tmpSignal[i] = byArray[i];
                }
            }
        }
    }

    public static byte[] raiseSignal(byte[] byArray, byte[] byArray2) {
        if (byArray2 == null) {
            return byArray;
        }
        if (byArray == null) {
            byArray = new byte[16];
        }
        for (int i = 0; i < 16; ++i) {
            if ((byArray[i] & 0xFF) >= (byArray2[i] & 0xFF)) continue;
            byArray[i] = byArray2[i];
        }
        return byArray;
    }

    public static byte[] copySignal(byte[] byArray) {
        return byArray == null ? null : (byte[])byArray.clone();
    }

    public static void saveSignal(by by2, String string, byte[] byArray) {
        if (byArray != null) {
            by2.a(string, byArray);
        }
    }

    public static byte[] loadSignal(by by2, String string) {
        return by2.b(string) ? by2.j(string) : null;
    }

    public static int packDigital(byte[] byArray) {
        if (byArray == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < 16; ++i) {
            if (byArray[i] == 0) continue;
            n |= 1 << i;
        }
        return n;
    }

    public static byte[] unpackDigital(byte[] byArray, int n) {
        if (n == 0) {
            return null;
        }
        if (byArray == null) {
            byArray = new byte[16];
        }
        for (int i = 0; i < 16; ++i) {
            byArray[i] = (byte)((n & 1 << i) == 0 ? 0 : 255);
        }
        return byArray;
    }
}

