/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.integration;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.multipart.TMultiPart;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.integration.RedstoneGateLogic;
import mrtjp.projectred.integration.RedstoneGatePart;
import mrtjp.projectred.integration.SimpleGateLogic;

public class SimpleGatePart
extends RedstoneGatePart {
    public byte state;

    public int state() {
        return this.state & 0xFF;
    }

    public void setState(int n) {
        this.state = (byte)n;
    }

    @Override
    public void save(by by2) {
        super.save(by2);
        by2.a("state", this.state);
    }

    @Override
    public void load(by by2) {
        super.load(by2);
        this.state = by2.c("state");
    }

    @Override
    public void writeDesc(MCDataOutput mCDataOutput) {
        super.writeDesc(mCDataOutput);
        mCDataOutput.writeByte((int)this.state);
    }

    @Override
    public void readDesc(MCDataInput mCDataInput) {
        super.readDesc(mCDataInput);
        this.state = mCDataInput.readByte();
    }

    @Override
    public void read(MCDataInput mCDataInput, int n) {
        if (n == 10) {
            this.state = mCDataInput.readByte();
            if (Configurator.staticGates) {
                this.tile().markRender();
            }
        } else {
            super.read(mCDataInput, n);
        }
    }

    @Override
    public String getType() {
        return "pr_sgate";
    }

    @Override
    public RedstoneGateLogic getLogic() {
        return SimpleGateLogic.instances[this.subID & 0xFF];
    }

    public void sendStateUpdate() {
        this.getWriteStream(10).writeByte((int)this.state);
    }

    public void onWorldJoin() {
        super.onWorldJoin();
        if (this.getLogic() == null) {
            this.tile().remPart((TMultiPart)this);
        }
    }

    public void onInputChange() {
        this.tile().markDirty();
        this.sendStateUpdate();
    }

    public void onOutputChange(int n) {
        this.tile().markDirty();
        this.sendStateUpdate();
        this.tile().internalPartChange((TMultiPart)this);
        this.notifyNeighbors(this.toAbsoluteMask(n));
    }
}

