/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.integration;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.TextureUtils;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import mrtjp.projectred.integration.ArrayCommons;
import mrtjp.projectred.integration.ArrayGatePart;
import mrtjp.projectred.integration.BundledGateLogic;
import mrtjp.projectred.integration.BundledGatePart;
import mrtjp.projectred.integration.ComponentStore;
import mrtjp.projectred.integration.GatePart;
import mrtjp.projectred.integration.InstancedRsGateLogic;
import mrtjp.projectred.integration.InstancedRsGatePart;
import mrtjp.projectred.integration.RowGatePart;
import mrtjp.projectred.integration.SimpleGatePart;

public class RenderGate {
    public static GateRenderer[] renderers = new GateRenderer[]{new OR(), new NOR(), new NOT(), new AND(), new NAND(), new XOR(), new XNOR(), new Buffer(), new Multiplexer(), new Pulse(), new Repeater(), new Randomizer(), new RSLatch(), new ToggleLatch(), new TransparentLatch(), new LightSensor(), new RainSensor(), new Timer(), new Sequencer(), new Counter(), new StateCell(), new Synchronizer(), new BusXcvr(), new NullCell(), new InvertCell(), new BufferCell(), new Comparator(), new ANDCell()};

    public static void registerIcons(mt mt2) {
        for (GateRenderer gateRenderer : renderers) {
            gateRenderer.registerIcons(mt2);
        }
    }

    public static void renderStatic(GatePart gatePart, Vector3 vector3) {
        GateRenderer gateRenderer = renderers[gatePart.subID & 0xFF];
        gateRenderer.prepare(gatePart);
        gateRenderer.renderStatic((Transformation)new Translation(vector3), gatePart.orientation & 0xFF);
    }

    public static void renderDynamic(GatePart gatePart, Vector3 vector3, float f) {
        GateRenderer gateRenderer = renderers[gatePart.subID & 0xFF];
        if (gateRenderer.hasSpecials()) {
            gateRenderer.prepareDynamic(gatePart, f);
            gateRenderer.renderDynamic((Transformation)gatePart.rotationT().with((Transformation)vector3.translation()));
        }
    }

    public static void renderInv(Transformation transformation, int n) {
        GateRenderer gateRenderer = renderers[n];
        TextureUtils.bindAtlas((int)0);
        gateRenderer.prepareInv();
        CCRenderState.startDrawing((int)7);
        gateRenderer.renderStatic(transformation, 0);
        CCRenderState.draw();
        if (gateRenderer.hasSpecials()) {
            gateRenderer.renderDynamic(transformation);
        }
    }

    public static void spawnParticles(GatePart gatePart, Random random) {
        renderers[gatePart.subID & 0xFF].spawnParticles(gatePart, random);
    }

    public static class ANDCell
    extends GateRenderer<RowGatePart> {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("ANDCELL", 2);
        ComponentStore.CellTopWireModel topWire = new ComponentStore.CellTopWireModel(ComponentStore.nullCellWireTop);
        ComponentStore.RedstoneTorchModel[] torches = new ComponentStore.RedstoneTorchModel[]{new ComponentStore.RedstoneTorchModel(8.0, 13.0, 6), new ComponentStore.RedstoneTorchModel(8.0, 2.0, 8), new ComponentStore.FlippedRSTorchModel(8.0, 8.0)};

        public ANDCell() {
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.torches));
            this.models.add(this.topWire);
            this.models.add(new ComponentStore.CellFrameModel());
        }

        @Override
        public void prepareInv() {
            this.topWire.signal = 0;
            this.topWire.invColour = true;
            this.topWire.conn = 0;
            this.torches[0].on = true;
            this.torches[1].on = false;
            this.torches[2].on = true;
            this.wires[0].on = true;
            this.wires[1].on = false;
        }

        @Override
        public void prepare(RowGatePart rowGatePart) {
            super.prepare(rowGatePart);
            this.topWire.signal = rowGatePart.signal;
            this.topWire.conn = ArrayCommons.topWireConn(rowGatePart);
            this.topWire.invColour = false;
            this.torches[0].on = (rowGatePart.state & 4) == 0;
            this.torches[1].on = (rowGatePart.state & 0x10) != 0;
            this.torches[2].on = (rowGatePart.state & 0xA) == 0;
            this.wires[0].on = this.torches[0].on || this.torches[2].on;
            this.wires[1].on = !this.torches[0].on;
        }
    }

    public static class Comparator
    extends GateRenderer<InstancedRsGatePart> {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("COMPARATOR", 4);
        ComponentStore.RedstoneTorchModel torch = new ComponentStore.RedstoneTorchModel(8.0, 2.0, 6);
        ComponentStore.OnOffModel[] chips = new ComponentStore.OnOffModel[]{new ComponentStore.MinusChipModel(5.0, 8.0), new ComponentStore.PlusChipModel(11.0, 8.0)};

        public Comparator() {
            this.models.addAll(Arrays.asList(this.wires));
            this.models.add(this.torch);
        }

        @Override
        public void prepareInv() {
            this.reflect = false;
            this.wires[0].on = false;
            this.wires[1].on = false;
            this.wires[2].on = false;
            this.wires[3].on = false;
            this.chips[0].on = false;
            this.chips[1].on = false;
            this.torch.on = false;
        }

        @Override
        public void prepare(InstancedRsGatePart instancedRsGatePart) {
            this.reflect = instancedRsGatePart.shape() != 0;
            this.wires[0].on = (instancedRsGatePart.state & 0x10) == 0;
            this.wires[1].on = (instancedRsGatePart.state & 2) != 0;
            this.wires[2].on = (instancedRsGatePart.state & 4) != 0;
            this.wires[3].on = (instancedRsGatePart.state & 8) != 0;
            this.chips[0].on = (instancedRsGatePart.state & 1) != 0 && instancedRsGatePart.shape == 1;
            this.chips[1].on = (instancedRsGatePart.state & 1) != 0 && instancedRsGatePart.shape != 1;
            boolean bl = this.torch.on = (instancedRsGatePart.state & 0x10) != 0;
            if (instancedRsGatePart.shape() != 0) {
                boolean bl2 = this.wires[1].on;
                boolean bl3 = this.wires[3].on;
                this.wires[3].on = bl2;
                this.wires[1].on = bl3;
            }
        }

        @Override
        public void renderModels(Transformation transformation, int n) {
            super.renderModels(transformation, n);
            this.chips[0].renderModel(transformation, n % 24);
            this.chips[1].renderModel(transformation, n % 24);
        }
    }

    public static class BufferCell
    extends ArrayCell {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("BUFFCELL", 2);
        ComponentStore.RedstoneTorchModel[] torches = new ComponentStore.RedstoneTorchModel[]{new ComponentStore.RedstoneTorchModel(11.0, 13.0, 6), new ComponentStore.RedstoneTorchModel(8.0, 8.0, 6)};

        public BufferCell() {
            super(new ComponentStore.CellTopWireModel(ComponentStore.extendedCellWireTop), new ComponentStore.CellBottomWireModel(ComponentStore.extendedCellWireBottom));
            this.models.add(new ComponentStore.ExtendedCellBaseModel());
            this.models.add(new ComponentStore.CellPlateModel());
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.torches));
        }

        @Override
        public void prepareInv() {
            super.prepareInv();
            this.wires[0].on = false;
            this.wires[1].on = true;
            this.torches[0].on = true;
            this.torches[1].on = false;
        }

        @Override
        public void prepare(ArrayGatePart arrayGatePart) {
            super.prepare(arrayGatePart);
            this.torches[0].on = arrayGatePart.signal1 == 0;
            this.torches[1].on = arrayGatePart.signal1 != 0;
            this.wires[0].on = arrayGatePart.signal1 != 0;
            this.wires[1].on = arrayGatePart.signal1 == 0;
        }
    }

    public static class InvertCell
    extends ArrayCell {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("INVCELL", 1);
        ComponentStore.RedstoneTorchModel torch = new ComponentStore.RedstoneTorchModel(8.0, 8.0, 6);

        public InvertCell() {
            super(new ComponentStore.CellTopWireModel(ComponentStore.extendedCellWireTop), new ComponentStore.CellBottomWireModel(ComponentStore.extendedCellWireBottom));
            this.models.add(new ComponentStore.ExtendedCellBaseModel());
            this.models.add(new ComponentStore.CellPlateModel());
            this.models.addAll(Arrays.asList(this.wires));
            this.models.add(this.torch);
        }

        @Override
        public void prepareInv() {
            super.prepareInv();
            this.wires[0].on = false;
            this.torch.on = true;
        }

        @Override
        public void prepare(ArrayGatePart arrayGatePart) {
            super.prepare(arrayGatePart);
            this.torch.on = arrayGatePart.signal1 == 0;
            this.wires[0].on = arrayGatePart.signal1 != 0;
        }
    }

    public static class NullCell
    extends ArrayCell {
        public NullCell() {
            super(new ComponentStore.CellTopWireModel(ComponentStore.nullCellWireTop), new ComponentStore.CellBottomWireModel(ComponentStore.nullCellWireBottom));
            this.models.add(new ComponentStore.NullCellBaseModel());
        }
    }

    public static class ArrayCell
    extends GateRenderer<ArrayGatePart> {
        public ComponentStore.CellBottomWireModel bottomWire;
        public ComponentStore.CellTopWireModel topWire;

        public ArrayCell(ComponentStore.CellTopWireModel cellTopWireModel, ComponentStore.CellBottomWireModel cellBottomWireModel) {
            this.topWire = cellTopWireModel;
            this.bottomWire = cellBottomWireModel;
            this.models.clear();
            this.models.add(cellTopWireModel);
            this.models.add(cellBottomWireModel);
            this.models.add(new ComponentStore.CellFrameModel());
        }

        @Override
        public void prepareInv() {
            this.bottomWire.signal = 0;
            this.bottomWire.invColour = true;
            this.topWire.signal = 0;
            this.topWire.invColour = true;
            this.topWire.conn = 0;
        }

        @Override
        public void prepare(ArrayGatePart arrayGatePart) {
            super.prepare(arrayGatePart);
            this.bottomWire.signal = arrayGatePart.signal1;
            this.bottomWire.invColour = false;
            this.topWire.signal = arrayGatePart.signal2;
            this.topWire.conn = ArrayCommons.topWireConn(arrayGatePart);
            this.topWire.invColour = false;
        }
    }

    public static class BusXcvr
    extends GateRenderer<BundledGatePart> {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("BUSXCVR", 2);
        ComponentStore.BusXcvrCableModel cable = new ComponentStore.BusXcvrCableModel();
        ComponentStore.BusXcvrPanelModel[] panels = new ComponentStore.BusXcvrPanelModel[]{new ComponentStore.BusXcvrPanelModel(4.0, 8.0, false), new ComponentStore.BusXcvrPanelModel(12.0, 8.0, true)};

        public BusXcvr() {
            this.models.add(this.cable);
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.panels));
        }

        @Override
        public void prepareInv() {
            this.reflect = false;
            this.wires[0].on = false;
            this.wires[1].on = false;
            this.panels[0].signal = 0;
            this.panels[1].signal = 0;
        }

        @Override
        public void prepare(BundledGatePart bundledGatePart) {
            this.reflect = bundledGatePart.shape() != 0;
            int n = bundledGatePart.state();
            if (this.reflect) {
                n = GatePart.flipMaskZ(n);
            }
            this.wires[0].on = (n & 2) != 0;
            this.wires[1].on = (n & 8) != 0;
            BundledGateLogic.BusTransceiver busTransceiver = (BundledGateLogic.BusTransceiver)bundledGatePart.getLogic();
            int n2 = busTransceiver.packClientData();
            this.panels[0].signal = n2 >>> 16;
            this.panels[1].signal = n2 & 0xFFFF;
        }
    }

    public static class Synchronizer
    extends GateRenderer<InstancedRsGatePart> {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("SYNC", 6);
        ComponentStore.RedstoneTorchModel torch = new ComponentStore.RedstoneTorchModel(8.0, 3.0, 6);
        ComponentStore.RedChipModel[] chips = new ComponentStore.RedChipModel[]{new ComponentStore.RedChipModel(4.5, 9.0), new ComponentStore.RedChipModel(11.5, 9.0)};

        public Synchronizer() {
            this.models.addAll(Arrays.asList(this.wires));
            this.models.add(this.torch);
            this.models.addAll(Arrays.asList(this.chips));
        }

        @Override
        public void prepareInv() {
            this.wires[0].on = true;
            this.wires[1].on = true;
            this.wires[2].on = false;
            this.wires[3].on = false;
            this.wires[4].on = false;
            this.wires[5].on = false;
            this.chips[0].on = false;
            this.chips[1].on = false;
            this.torch.on = false;
        }

        @Override
        public void prepare(InstancedRsGatePart instancedRsGatePart) {
            InstancedRsGateLogic.Synchronizer synchronizer = (InstancedRsGateLogic.Synchronizer)instancedRsGatePart.getLogic();
            this.wires[0].on = !synchronizer.left();
            this.wires[1].on = !synchronizer.right();
            this.wires[2].on = (instancedRsGatePart.state() & 4) != 0;
            this.wires[3].on = synchronizer.left() && synchronizer.right();
            this.wires[4].on = (instancedRsGatePart.state() & 8) != 0;
            this.wires[5].on = (instancedRsGatePart.state() & 2) != 0;
            this.chips[0].on = synchronizer.left();
            this.chips[1].on = synchronizer.right();
            this.torch.on = (instancedRsGatePart.state() & 0x10) != 0;
        }
    }

    public static class StateCell
    extends GateRenderer<InstancedRsGatePart> {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("STATECELL", 5);
        ComponentStore.RedstoneTorchModel[] torches = new ComponentStore.RedstoneTorchModel[]{new ComponentStore.RedstoneTorchModel(10.0, 3.5, 6), new ComponentStore.RedstoneTorchModel(13.0, 8.0, 12)};
        ComponentStore.PointerModel pointer = new ComponentStore.PointerModel(13.0, 8.0, 8.0);
        ComponentStore.RedChipModel chip = new ComponentStore.RedChipModel(6.5, 10.0);

        public StateCell() {
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.torches));
            this.models.add(this.chip);
        }

        public InstancedRsGateLogic.StateCell getLogic(InstancedRsGatePart instancedRsGatePart) {
            return (InstancedRsGateLogic.StateCell)instancedRsGatePart.getLogic();
        }

        @Override
        public void prepareInv() {
            this.reflect = false;
            this.wires[0].on = false;
            this.wires[1].on = false;
            this.wires[2].on = false;
            this.wires[3].on = false;
            this.wires[4].on = false;
            this.torches[0].on = false;
            this.torches[1].on = true;
            this.chip.on = false;
            this.pointer.angle = -1.5707963267948966;
        }

        @Override
        public void prepare(InstancedRsGatePart instancedRsGatePart) {
            this.reflect = instancedRsGatePart.shape == 1;
            int n = instancedRsGatePart.state();
            if (this.reflect) {
                n = GatePart.flipMaskZ(n >> 4) << 4 | GatePart.flipMaskZ(n);
            }
            this.wires[0].on = (n & 0x10) != 0;
            this.wires[1].on = (n & 4) != 0;
            this.wires[2].on = this.getLogic((InstancedRsGatePart)instancedRsGatePart).state2 == 0 || (n & 4) != 0;
            this.wires[3].on = (n & 0x88) != 0;
            this.wires[4].on = (n & 2) != 0;
            this.torches[0].on = (n & 0x10) != 0;
            this.torches[1].on = this.getLogic((InstancedRsGatePart)instancedRsGatePart).pointer_start >= 0L;
            this.chip.on = this.getLogic((InstancedRsGatePart)instancedRsGatePart).state2 != 0;
        }

        @Override
        public boolean hasSpecials() {
            return true;
        }

        @Override
        public void prepareDynamic(InstancedRsGatePart instancedRsGatePart, float f) {
            this.reflect = instancedRsGatePart.shape == 1;
            this.pointer.angle = (double)this.getLogic(instancedRsGatePart).interpPointer(f) - 1.5707963267948966;
        }

        @Override
        public void renderDynamic(Transformation transformation) {
            CCRenderState.startDrawing((int)7);
            CCRenderState.pullLightmap();
            CCRenderState.useNormals((boolean)true);
            this.pointer.renderModel(transformation, this.reflect ? 1 : 0);
            CCRenderState.draw();
        }
    }

    public static class Counter
    extends GateRenderer<InstancedRsGatePart> {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("COUNT", 2);
        ComponentStore.RedstoneTorchModel[] torches = new ComponentStore.RedstoneTorchModel[]{new ComponentStore.RedstoneTorchModel(11.0, 8.0, 12), new ComponentStore.RedstoneTorchModel(8.0, 3.0, 6), new ComponentStore.RedstoneTorchModel(8.0, 13.0, 6)};
        ComponentStore.PointerModel pointer = new ComponentStore.PointerModel(11.0, 8.0, 8.0, 1.2);

        public Counter() {
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.torches));
            this.torches[0].on = true;
        }

        @Override
        public void prepare(InstancedRsGatePart instancedRsGatePart) {
            this.reflect = instancedRsGatePart.shape() == 1;
            this.wires[0].on = (instancedRsGatePart.state() & 8) != 0;
            this.wires[1].on = (instancedRsGatePart.state() & 2) != 0;
            this.torches[1].on = (instancedRsGatePart.state() & 0x10) != 0;
            this.torches[2].on = (instancedRsGatePart.state() & 0x40) != 0;
        }

        @Override
        public void prepareInv() {
            this.reflect = false;
            this.wires[0].on = false;
            this.wires[1].on = false;
            this.torches[1].on = false;
            this.torches[2].on = true;
            this.pointer.angle = 3.83972435438746;
        }

        @Override
        public void prepareDynamic(InstancedRsGatePart instancedRsGatePart, float f) {
            int n = ((InstancedRsGateLogic.Counter)instancedRsGatePart.getLogic()).max;
            int n2 = ((InstancedRsGateLogic.Counter)instancedRsGatePart.getLogic()).value;
            this.pointer.angle = ((double)n2 / (double)n * 120.0 + 210.0) * 0.017453292519943;
            if (instancedRsGatePart.shape() == 1) {
                this.reflect = true;
            }
        }

        @Override
        public boolean hasSpecials() {
            return true;
        }

        @Override
        public void renderDynamic(Transformation transformation) {
            CCRenderState.startDrawing((int)7);
            CCRenderState.pullLightmap();
            CCRenderState.useNormals((boolean)true);
            this.pointer.renderModel(transformation, this.reflect ? 1 : 0);
            CCRenderState.draw();
        }
    }

    public static class Sequencer
    extends GateRenderer<InstancedRsGatePart> {
        ComponentStore.RedstoneTorchModel[] torches = new ComponentStore.RedstoneTorchModel[]{new ComponentStore.RedstoneTorchModel(8.0, 8.0, 12), new ComponentStore.RedstoneTorchModel(8.0, 3.0, 6), new ComponentStore.RedstoneTorchModel(13.0, 8.0, 6), new ComponentStore.RedstoneTorchModel(8.0, 13.0, 6), new ComponentStore.RedstoneTorchModel(3.0, 8.0, 6)};
        ComponentStore.PointerModel pointer = new ComponentStore.PointerModel(8.0, 8.0, 8.0);

        public Sequencer() {
            this.models.addAll(Arrays.asList(this.torches));
            this.torches[0].on = true;
        }

        @Override
        public void prepare(InstancedRsGatePart instancedRsGatePart) {
            this.torches[1].on = (instancedRsGatePart.state & 0x10) != 0;
            this.torches[2].on = (instancedRsGatePart.state & 0x20) != 0;
            this.torches[3].on = (instancedRsGatePart.state & 0x40) != 0;
            this.torches[4].on = (instancedRsGatePart.state & 0x80) != 0;
        }

        @Override
        public void prepareInv() {
            this.torches[1].on = false;
            this.torches[2].on = false;
            this.torches[3].on = false;
            this.torches[4].on = false;
            this.pointer.angle = 0.0;
        }

        @Override
        public void prepareDynamic(InstancedRsGatePart instancedRsGatePart, float f) {
            int n = ((InstancedRsGateLogic.Sequencer)instancedRsGatePart.getLogic()).pointer_max;
            this.pointer.angle = (double)(((float)(instancedRsGatePart.world().J() % (long)n) + f) / (float)n * 2.0f) * Math.PI;
            if (instancedRsGatePart.shape() == 1) {
                this.pointer.angle = -this.pointer.angle;
            }
        }

        @Override
        public boolean hasSpecials() {
            return true;
        }

        @Override
        public void renderDynamic(Transformation transformation) {
            CCRenderState.startDrawing((int)7);
            CCRenderState.pullLightmap();
            CCRenderState.useNormals((boolean)true);
            this.pointer.renderModel(transformation, 0);
            CCRenderState.draw();
        }
    }

    public static class Timer
    extends GateRenderer<InstancedRsGatePart> {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("TIME", 3);
        ComponentStore.RedstoneTorchModel[] torches = new ComponentStore.RedstoneTorchModel[]{new ComponentStore.RedstoneTorchModel(8.0, 3.0, 6), new ComponentStore.RedstoneTorchModel(8.0, 8.0, 12)};
        ComponentStore.PointerModel pointer = new ComponentStore.PointerModel(8.0, 8.0, 8.0);

        public Timer() {
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.torches));
            this.torches[1].on = true;
        }

        @Override
        public void prepare(InstancedRsGatePart instancedRsGatePart) {
            this.torches[0].on = (instancedRsGatePart.state & 0x10) != 0;
            this.wires[0].on = (instancedRsGatePart.state & 0x88) != 0;
            this.wires[1].on = (instancedRsGatePart.state & 0x22) != 0;
            this.wires[2].on = (instancedRsGatePart.state & 4) != 0;
        }

        @Override
        public void prepareInv() {
            this.wires[0].on = false;
            this.wires[1].on = false;
            this.wires[2].on = false;
            this.torches[0].on = false;
            this.pointer.angle = 0.0;
        }

        @Override
        public boolean hasSpecials() {
            return true;
        }

        @Override
        public void prepareDynamic(InstancedRsGatePart instancedRsGatePart, float f) {
            this.pointer.angle = (double)((InstancedRsGateLogic.TimerGateLogic)instancedRsGatePart.getLogic()).interpPointer(f) * Math.PI * 2.0;
        }

        @Override
        public void renderDynamic(Transformation transformation) {
            CCRenderState.startDrawing((int)7);
            CCRenderState.pullLightmap();
            CCRenderState.useNormals((boolean)true);
            this.pointer.renderModel(transformation, 0);
            CCRenderState.draw();
        }
    }

    public static class RainSensor
    extends GateRenderer<SimpleGatePart> {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("RAINSENSOR", 1);
        ComponentStore.RainSensorModel solar = new ComponentStore.RainSensorModel(8.0, 6.0);

        public RainSensor() {
            this.models.addAll(Arrays.asList(this.wires));
            this.models.add(this.solar);
        }

        @Override
        public void prepareInv() {
            this.wires[0].on = false;
        }

        @Override
        public void prepare(SimpleGatePart simpleGatePart) {
            this.wires[0].on = (simpleGatePart.state & 0x44) != 0;
        }
    }

    public static class LightSensor
    extends GateRenderer<SimpleGatePart> {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("LIGHTSENSOR", 1);
        ComponentStore.SolarModel solar = new ComponentStore.SolarModel(8.0, 5.5);

        public LightSensor() {
            this.models.addAll(Arrays.asList(this.wires));
            this.models.add(this.solar);
        }

        @Override
        public void prepareInv() {
            this.wires[0].on = false;
            this.solar.state = 0;
        }

        @Override
        public void prepare(SimpleGatePart simpleGatePart) {
            this.wires[0].on = (simpleGatePart.state & 0xF4) != 0;
            this.solar.state = simpleGatePart.shape();
        }
    }

    public static class TransparentLatch
    extends GateRenderer<SimpleGatePart> {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("TRANSLATCH", 5);
        ComponentStore.RedstoneTorchModel[] torches = new ComponentStore.RedstoneTorchModel[]{new ComponentStore.RedstoneTorchModel(4.0, 12.5, 6), new ComponentStore.RedstoneTorchModel(4.0, 8.0, 6), new ComponentStore.RedstoneTorchModel(8.0, 8.0, 6), new ComponentStore.RedstoneTorchModel(8.0, 2.0, 8), new ComponentStore.RedstoneTorchModel(14.0, 8.0, 8)};

        public TransparentLatch() {
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.torches));
        }

        @Override
        public void prepareInv() {
            this.reflect = false;
            this.wires[0].on = true;
            this.wires[1].on = false;
            this.wires[2].on = true;
            this.wires[3].on = false;
            this.wires[4].on = false;
            this.torches[0].on = true;
            this.torches[1].on = false;
            this.torches[2].on = true;
            this.torches[3].on = false;
            this.torches[4].on = false;
        }

        @Override
        public void prepare(SimpleGatePart simpleGatePart) {
            this.reflect = simpleGatePart.shape() == 1;
            boolean bl = (simpleGatePart.state & 0x10) != 0;
            this.wires[0].on = !bl;
            this.wires[1].on = (simpleGatePart.state & 4) != 0;
            this.wires[2].on = (simpleGatePart.state & 4) == 0;
            this.wires[3].on = bl;
            this.wires[4].on = (simpleGatePart.state & 0xA) != 0;
            this.torches[0].on = this.wires[2].on;
            this.torches[1].on = !this.wires[2].on && !this.wires[4].on;
            this.torches[2].on = !this.wires[1].on && !this.wires[3].on;
            this.torches[3].on = bl;
            this.torches[4].on = bl;
        }
    }

    public static class ToggleLatch
    extends GateRenderer<InstancedRsGatePart> {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("TOGLATCH", 2);
        ComponentStore.RedstoneTorchModel[] torches = new ComponentStore.RedstoneTorchModel[]{new ComponentStore.RedstoneTorchModel(4.0, 4.0, 6), new ComponentStore.RedstoneTorchModel(4.0, 12.0, 6)};
        ComponentStore.LeverModel lever = new ComponentStore.LeverModel(11.0, 8.0);

        public ToggleLatch() {
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.torches));
            this.models.add(this.lever);
        }

        @Override
        public void prepareInv() {
            this.wires[0].on = false;
            this.wires[1].on = false;
            this.torches[0].on = true;
            this.torches[1].on = false;
            this.lever.state = 0;
        }

        @Override
        public void prepare(InstancedRsGatePart instancedRsGatePart) {
            this.wires[0].on = (instancedRsGatePart.state & 8) != 0;
            this.wires[1].on = (instancedRsGatePart.state & 2) != 0;
            this.torches[0].on = (instancedRsGatePart.state & 0x10) != 0;
            this.torches[1].on = (instancedRsGatePart.state & 0x40) != 0;
            this.lever.state = (instancedRsGatePart.state & 0x10) != 0 ? 0 : 1;
        }
    }

    public static class RSLatch
    extends GateRenderer<InstancedRsGatePart> {
        ComponentStore.WireComponentModel[] wires1 = ComponentStore.generateWireModels("RSLATCH", 2);
        ComponentStore.WireComponentModel[] wires2 = ComponentStore.generateWireModels("RSLATCH2", 4);
        ComponentStore.RedstoneTorchModel[] torches1 = new ComponentStore.RedstoneTorchModel[]{new ComponentStore.RedstoneTorchModel(8.0, 3.0, 6), new ComponentStore.RedstoneTorchModel(8.0, 13.0, 6)};
        ComponentStore.RedstoneTorchModel[] torches2 = new ComponentStore.RedstoneTorchModel[]{new ComponentStore.RedstoneTorchModel(9.5, 3.0, 6), new ComponentStore.RedstoneTorchModel(6.5, 13.0, 6)};
        int type = 0;

        @Override
        public void prepareInv() {
            this.reflect = false;
            this.type = 0;
            this.wires1[0].on = false;
            this.wires1[1].on = true;
            this.torches1[0].on = false;
            this.torches1[1].on = true;
        }

        @Override
        public void prepare(InstancedRsGatePart instancedRsGatePart) {
            this.reflect = (instancedRsGatePart.shape & 1) != 0;
            this.type = instancedRsGatePart.shape >> 1;
            int n = instancedRsGatePart.state();
            if (this.reflect) {
                n = GatePart.flipMaskZ(n >> 4) << 4 | GatePart.flipMaskZ(n);
            }
            if (this.type == 0) {
                this.wires1[0].on = (n & 0x88) != 0;
                this.wires1[1].on = (n & 0x22) != 0;
                this.torches1[0].on = (n & 0x10) != 0;
                this.torches1[1].on = (n & 0x40) != 0;
            } else {
                this.wires2[1].on = (n & 2) != 0;
                this.wires2[3].on = (n & 8) != 0;
                this.torches2[0].on = (n & 0x10) != 0;
                this.torches2[1].on = (n & 0x40) != 0;
                this.wires2[0].on = this.torches2[1].on;
                this.wires2[2].on = this.torches2[0].on;
            }
        }

        @Override
        public void renderModels(Transformation transformation, int n) {
            super.renderModels(transformation, n);
            for (ComponentStore.WireComponentModel componentModel : this.type == 0 ? this.wires1 : this.wires2) {
                ((ComponentStore.ComponentModel)componentModel).renderModel(transformation, n);
            }
            for (ComponentStore.ComponentModel componentModel : this.type == 0 ? this.torches1 : this.torches2) {
                componentModel.renderModel(transformation, n);
            }
        }

        @Override
        public void registerIcons(mt mt2) {
            for (ComponentStore.WireComponentModel wireComponentModel : this.wires1) {
                ((ComponentStore.ComponentModel)wireComponentModel).registerTextures(mt2);
            }
            for (ComponentStore.WireComponentModel wireComponentModel : this.wires2) {
                ((ComponentStore.ComponentModel)wireComponentModel).registerTextures(mt2);
            }
        }
    }

    public static class Randomizer
    extends GateRenderer<SimpleGatePart> {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("RANDOM", 4);
        ComponentStore.YellowChipModel[] chips = new ComponentStore.YellowChipModel[]{new ComponentStore.YellowChipModel(8.0, 5.5), new ComponentStore.YellowChipModel(11.5, 12.0), new ComponentStore.YellowChipModel(4.5, 12.0)};

        public Randomizer() {
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.chips));
        }

        @Override
        public void prepareInv() {
            this.wires[0].on = false;
            this.wires[1].on = false;
            this.wires[2].on = false;
            this.wires[3].on = false;
            this.chips[0].on = false;
            this.chips[1].on = false;
            this.chips[2].on = false;
        }

        @Override
        public void prepare(SimpleGatePart simpleGatePart) {
            this.wires[1].on = (simpleGatePart.state & 4) != 0;
            this.wires[0].on = (simpleGatePart.state & 0x11) != 0;
            this.wires[3].on = (simpleGatePart.state & 0x22) != 0;
            this.wires[2].on = (simpleGatePart.state & 0x88) != 0;
            this.chips[0].on = (simpleGatePart.state & 0x10) != 0;
            this.chips[1].on = (simpleGatePart.state & 0x20) != 0;
            this.chips[2].on = (simpleGatePart.state & 0x80) != 0;
        }
    }

    public static class Repeater
    extends GateRenderer<SimpleGatePart> {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("REPEATER", 2);
        ComponentStore.RedstoneTorchModel endtorch = new ComponentStore.RedstoneTorchModel(8.0, 2.0, 6);
        ComponentStore.RedstoneTorchModel[] vartorches = new ComponentStore.RedstoneTorchModel[]{new ComponentStore.RedstoneTorchModel(12.5, 12.0, 6), new ComponentStore.RedstoneTorchModel(12.5, 11.0, 6), new ComponentStore.RedstoneTorchModel(12.5, 10.0, 6), new ComponentStore.RedstoneTorchModel(12.5, 9.0, 6), new ComponentStore.RedstoneTorchModel(12.5, 8.0, 6), new ComponentStore.RedstoneTorchModel(12.5, 7.0, 6), new ComponentStore.RedstoneTorchModel(12.5, 6.0, 6), new ComponentStore.RedstoneTorchModel(12.5, 5.0, 6), new ComponentStore.RedstoneTorchModel(12.5, 4.0, 6)};
        int shape = 0;

        public Repeater() {
            this.models.addAll(Arrays.asList(this.wires));
            this.models.add(this.endtorch);
        }

        @Override
        public void prepareInv() {
            this.wires[0].on = true;
            this.wires[1].on = false;
            this.endtorch.on = true;
            this.shape = 0;
            this.vartorches[0].on = false;
        }

        @Override
        public void prepare(SimpleGatePart simpleGatePart) {
            this.wires[0].on = (simpleGatePart.state & 0x10) == 0;
            this.wires[1].on = (simpleGatePart.state & 4) != 0;
            this.endtorch.on = (simpleGatePart.state & 0x10) != 0;
            this.shape = simpleGatePart.shape();
            this.vartorches[this.shape].on = (simpleGatePart.state & 4) == 0;
        }

        @Override
        public void renderModels(Transformation transformation, int n) {
            super.renderModels(transformation, n);
            this.vartorches[this.shape].renderModel(transformation, n);
        }
    }

    public static class Pulse
    extends GateRenderer<SimpleGatePart> {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("PULSE", 3);
        ComponentStore.RedstoneTorchModel[] torches = new ComponentStore.RedstoneTorchModel[]{new ComponentStore.RedstoneTorchModel(4.0, 9.5, 6), new ComponentStore.RedstoneTorchModel(11.0, 9.5, 6), new ComponentStore.RedstoneTorchModel(8.0, 3.5, 8)};

        public Pulse() {
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.torches));
        }

        @Override
        public void prepareInv() {
            this.wires[0].on = true;
            this.wires[1].on = false;
            this.wires[2].on = false;
            this.torches[0].on = true;
            this.torches[1].on = false;
            this.torches[2].on = false;
        }

        @Override
        public void prepare(SimpleGatePart simpleGatePart) {
            this.wires[0].on = (simpleGatePart.state & 4) == 0;
            this.wires[1].on = (simpleGatePart.state & 4) != 0;
            this.wires[2].on = (simpleGatePart.state & 0x14) == 4;
            this.torches[0].on = this.wires[0].on;
            this.torches[1].on = this.wires[1].on;
            this.torches[2].on = (simpleGatePart.state & 0x10) != 0;
        }
    }

    public static class Multiplexer
    extends GateRenderer<SimpleGatePart> {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("MULTIPLEXER", 6);
        ComponentStore.RedstoneTorchModel[] torches = new ComponentStore.RedstoneTorchModel[]{new ComponentStore.RedstoneTorchModel(8.0, 2.0, 8), new ComponentStore.RedstoneTorchModel(9.0, 10.5, 6), new ComponentStore.RedstoneTorchModel(4.5, 8.0, 6), new ComponentStore.RedstoneTorchModel(11.5, 8.0, 6)};

        public Multiplexer() {
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.torches));
        }

        @Override
        public void prepareInv() {
            this.wires[0].on = false;
            this.wires[1].on = true;
            this.wires[2].on = true;
            this.wires[3].on = false;
            this.wires[4].on = false;
            this.wires[5].on = false;
            this.torches[0].on = false;
            this.torches[1].on = true;
            this.torches[2].on = false;
            this.torches[3].on = true;
        }

        @Override
        public void prepare(SimpleGatePart simpleGatePart) {
            this.wires[2].on = (simpleGatePart.state & 4) == 0;
            this.wires[3].on = (simpleGatePart.state & 4) != 0;
            this.wires[4].on = (simpleGatePart.state & 8) != 0;
            this.wires[5].on = (simpleGatePart.state & 2) != 0;
            this.torches[0].on = (simpleGatePart.state & 0x10) != 0;
            this.torches[1].on = !this.wires[3].on;
            this.torches[2].on = (simpleGatePart.state & 8) == 0 && this.wires[3].on;
            this.torches[3].on = (simpleGatePart.state & 4) == 0 && !this.wires[5].on;
            this.wires[0].on = this.torches[2].on;
            this.wires[1].on = this.torches[1].on;
        }
    }

    public static class Buffer
    extends GateRenderer<SimpleGatePart> {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("BUFFER", 4);
        ComponentStore.RedstoneTorchModel[] torches = new ComponentStore.RedstoneTorchModel[]{new ComponentStore.RedstoneTorchModel(8.0, 2.0, 8), new ComponentStore.RedstoneTorchModel(8.0, 9.0, 6)};

        public Buffer() {
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.torches));
        }

        @Override
        public void prepareInv() {
            this.wires[0].on = true;
            this.wires[1].on = false;
            this.wires[2].on = false;
            this.wires[3].on = false;
            this.wires[1].disabled = false;
            this.wires[3].disabled = false;
            this.torches[0].on = false;
            this.torches[1].on = true;
        }

        @Override
        public void prepare(SimpleGatePart simpleGatePart) {
            this.wires[0].on = (simpleGatePart.state & 4) == 0;
            this.wires[1].on = (simpleGatePart.state & 0x22) != 0;
            this.wires[2].on = (simpleGatePart.state & 0x44) != 0;
            this.wires[3].on = (simpleGatePart.state & 0x88) != 0;
            this.wires[1].disabled = (simpleGatePart.shape & 1) != 0;
            this.wires[3].disabled = (simpleGatePart.shape & 2) != 0;
            this.torches[0].on = (simpleGatePart.state & 4) != 0;
            this.torches[1].on = (simpleGatePart.state & 4) == 0;
        }
    }

    public static class XNOR
    extends GateRenderer<SimpleGatePart> {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("XNOR", 5);
        ComponentStore.RedstoneTorchModel[] torches = new ComponentStore.RedstoneTorchModel[]{new ComponentStore.RedstoneTorchModel(8.0, 2.0, 8), new ComponentStore.RedstoneTorchModel(4.5, 8.0, 6), new ComponentStore.RedstoneTorchModel(11.5, 8.0, 6), new ComponentStore.RedstoneTorchModel(8.0, 12.0, 6)};

        public XNOR() {
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.torches));
        }

        @Override
        public void prepareInv() {
            this.wires[0].on = false;
            this.wires[3].on = false;
            this.wires[2].on = false;
            this.wires[1].on = false;
            this.torches[0].on = true;
            this.torches[1].on = false;
            this.torches[2].on = false;
            this.torches[3].on = true;
        }

        @Override
        public void prepare(SimpleGatePart simpleGatePart) {
            this.wires[0].on = (simpleGatePart.state & 2) != 0 && (simpleGatePart.state & 8) == 0;
            this.wires[1].on = (simpleGatePart.state & 8) != 0 && (simpleGatePart.state & 2) == 0;
            this.wires[2].on = (simpleGatePart.state & 8) != 0;
            this.wires[3].on = (simpleGatePart.state & 2) != 0;
            this.wires[4].on = !this.wires[3].on && !this.wires[2].on;
            this.torches[0].on = (simpleGatePart.state & 0x11) != 0;
            this.torches[1].on = !this.wires[4].on && (simpleGatePart.state & 8) == 0;
            this.torches[2].on = !this.wires[4].on && (simpleGatePart.state & 2) == 0;
            this.torches[3].on = (simpleGatePart.state & 2) == 0 && (simpleGatePart.state & 8) == 0;
        }
    }

    public static class XOR
    extends GateRenderer<SimpleGatePart> {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("XOR", 4);
        ComponentStore.RedstoneTorchModel[] torches = new ComponentStore.RedstoneTorchModel[]{new ComponentStore.RedstoneTorchModel(4.5, 8.0, 6), new ComponentStore.RedstoneTorchModel(11.5, 8.0, 6), new ComponentStore.RedstoneTorchModel(8.0, 12.0, 6)};

        public XOR() {
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.torches));
        }

        @Override
        public void prepareInv() {
            this.wires[0].on = false;
            this.wires[3].on = false;
            this.wires[2].on = false;
            this.wires[1].on = true;
            this.torches[0].on = false;
            this.torches[1].on = false;
            this.torches[2].on = true;
        }

        @Override
        public void prepare(SimpleGatePart simpleGatePart) {
            this.wires[0].on = (simpleGatePart.state & 0x11) != 0;
            this.wires[3].on = (simpleGatePart.state & 2) != 0;
            this.wires[2].on = (simpleGatePart.state & 8) != 0;
            this.wires[1].on = !this.wires[3].on && !this.wires[2].on;
            this.torches[0].on = !this.wires[2].on && !this.wires[1].on;
            this.torches[1].on = !this.wires[3].on && !this.wires[1].on;
            this.torches[2].on = this.wires[1].on;
        }
    }

    public static class NAND
    extends GateRenderer<SimpleGatePart> {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("NAND", 4);
        ComponentStore.RedstoneTorchModel[] torches = new ComponentStore.RedstoneTorchModel[]{new ComponentStore.RedstoneTorchModel(4.0, 8.0, 6), new ComponentStore.RedstoneTorchModel(12.0, 8.0, 6), new ComponentStore.RedstoneTorchModel(8.0, 8.0, 6)};

        public NAND() {
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.torches));
        }

        @Override
        public void prepareInv() {
            this.wires[0].on = true;
            this.wires[1].on = false;
            this.wires[2].on = false;
            this.wires[3].on = false;
            this.wires[1].disabled = false;
            this.wires[2].disabled = false;
            this.wires[3].disabled = false;
            this.torches[0].on = true;
            this.torches[1].on = true;
            this.torches[2].on = true;
        }

        @Override
        public void prepare(SimpleGatePart simpleGatePart) {
            this.wires[0].on = (simpleGatePart.state & 0x11) != 0;
            this.wires[3].on = (simpleGatePart.state & 2) != 0;
            this.wires[1].on = (simpleGatePart.state & 4) != 0;
            this.wires[2].on = (simpleGatePart.state & 8) != 0;
            this.wires[3].disabled = (simpleGatePart.shape & 1) != 0;
            this.wires[1].disabled = (simpleGatePart.shape & 2) != 0;
            this.wires[2].disabled = (simpleGatePart.shape & 4) != 0;
            this.torches[0].on = !this.wires[2].on && !this.wires[2].disabled;
            this.torches[1].on = !this.wires[3].on && !this.wires[3].disabled;
            this.torches[2].on = !this.wires[1].on && !this.wires[1].disabled;
        }
    }

    public static class AND
    extends GateRenderer<SimpleGatePart> {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("AND", 4);
        ComponentStore.RedstoneTorchModel[] torches = new ComponentStore.RedstoneTorchModel[]{new ComponentStore.RedstoneTorchModel(4.0, 8.0, 6), new ComponentStore.RedstoneTorchModel(12.0, 8.0, 6), new ComponentStore.RedstoneTorchModel(8.0, 8.0, 6), new ComponentStore.RedstoneTorchModel(8.0, 2.0, 8)};

        public AND() {
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.torches));
        }

        @Override
        public void prepareInv() {
            this.wires[0].on = true;
            this.wires[1].on = false;
            this.wires[2].on = false;
            this.wires[3].on = false;
            this.wires[1].disabled = false;
            this.wires[2].disabled = false;
            this.wires[3].disabled = false;
            this.torches[0].on = true;
            this.torches[1].on = true;
            this.torches[2].on = true;
            this.torches[3].on = false;
        }

        @Override
        public void prepare(SimpleGatePart simpleGatePart) {
            this.wires[0].on = (simpleGatePart.state & 0x11) == 0;
            this.wires[3].on = (simpleGatePart.state & 2) != 0;
            this.wires[1].on = (simpleGatePart.state & 4) != 0;
            this.wires[2].on = (simpleGatePart.state & 8) != 0;
            this.wires[3].disabled = (simpleGatePart.shape & 1) != 0;
            this.wires[1].disabled = (simpleGatePart.shape & 2) != 0;
            this.wires[2].disabled = (simpleGatePart.shape & 4) != 0;
            this.torches[2].on = !this.wires[1].on && !this.wires[1].disabled;
            this.torches[0].on = !this.wires[2].on && !this.wires[2].disabled;
            this.torches[1].on = !this.wires[3].on && !this.wires[3].disabled;
            this.torches[3].on = !this.wires[0].on;
        }
    }

    public static class NOT
    extends GateRenderer<SimpleGatePart> {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("NOT", 4);
        ComponentStore.RedstoneTorchModel torch = new ComponentStore.RedstoneTorchModel(8.0, 8.0, 6);

        public NOT() {
            this.models.addAll(Arrays.asList(this.wires));
            this.models.add(this.torch);
        }

        @Override
        public void prepareInv() {
            this.wires[0].on = true;
            this.wires[1].on = true;
            this.wires[2].on = true;
            this.wires[3].on = false;
            this.wires[3].disabled = false;
            this.wires[0].disabled = false;
            this.wires[2].disabled = false;
            this.torch.on = true;
        }

        @Override
        public void prepare(SimpleGatePart simpleGatePart) {
            this.wires[0].on = (simpleGatePart.state & 0x11) != 0;
            this.wires[3].on = (simpleGatePart.state & 0x22) != 0;
            this.wires[1].on = (simpleGatePart.state & 4) != 0;
            this.wires[2].on = (simpleGatePart.state & 0x88) != 0;
            this.wires[3].disabled = (simpleGatePart.shape & 1) != 0;
            this.wires[0].disabled = (simpleGatePart.shape & 2) != 0;
            this.wires[2].disabled = (simpleGatePart.shape & 4) != 0;
            this.torch.on = (simpleGatePart.state & 0xF0) != 0;
        }
    }

    public static class NOR
    extends GateRenderer<SimpleGatePart> {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("OR", 4);
        ComponentStore.RedstoneTorchModel torch = new ComponentStore.RedstoneTorchModel(8.0, 9.0, 6);

        public NOR() {
            this.models.addAll(Arrays.asList(this.wires));
            this.models.add(this.torch);
        }

        @Override
        public void prepareInv() {
            this.wires[0].on = true;
            this.wires[1].on = false;
            this.wires[2].on = false;
            this.wires[3].on = false;
            this.wires[1].disabled = false;
            this.wires[2].disabled = false;
            this.wires[3].disabled = false;
            this.torch.on = true;
        }

        @Override
        public void prepare(SimpleGatePart simpleGatePart) {
            this.wires[0].on = (simpleGatePart.state & 0x11) != 0;
            this.wires[1].on = (simpleGatePart.state & 2) != 0;
            this.wires[2].on = (simpleGatePart.state & 4) != 0;
            this.wires[3].on = (simpleGatePart.state & 8) != 0;
            this.wires[1].disabled = (simpleGatePart.shape & 1) != 0;
            this.wires[2].disabled = (simpleGatePart.shape & 2) != 0;
            this.wires[3].disabled = (simpleGatePart.shape & 4) != 0;
            this.torch.on = (simpleGatePart.state & 0xE) == 0;
        }
    }

    public static class OR
    extends GateRenderer<SimpleGatePart> {
        ComponentStore.WireComponentModel[] wires = ComponentStore.generateWireModels("OR", 4);
        ComponentStore.RedstoneTorchModel[] torches = new ComponentStore.RedstoneTorchModel[]{new ComponentStore.RedstoneTorchModel(8.0, 9.0, 6), new ComponentStore.RedstoneTorchModel(8.0, 2.5, 8)};

        public OR() {
            this.models.addAll(Arrays.asList(this.wires));
            this.models.addAll(Arrays.asList(this.torches));
        }

        @Override
        public void prepareInv() {
            this.wires[0].on = true;
            this.wires[1].on = false;
            this.wires[2].on = false;
            this.wires[3].on = false;
            this.wires[1].disabled = false;
            this.wires[2].disabled = false;
            this.wires[3].disabled = false;
            this.torches[0].on = true;
            this.torches[1].on = false;
        }

        @Override
        public void prepare(SimpleGatePart simpleGatePart) {
            this.wires[0].on = (simpleGatePart.state & 0x10) == 0;
            this.wires[1].on = (simpleGatePart.state & 2) != 0;
            this.wires[2].on = (simpleGatePart.state & 4) != 0;
            this.wires[3].on = (simpleGatePart.state & 8) != 0;
            this.wires[1].disabled = (simpleGatePart.shape & 1) != 0;
            this.wires[2].disabled = (simpleGatePart.shape & 2) != 0;
            this.wires[3].disabled = (simpleGatePart.shape & 4) != 0;
            this.torches[0].on = (simpleGatePart.state & 0xE) == 0;
            this.torches[1].on = !this.wires[0].on;
        }
    }

    public static abstract class GateRenderer<PartType extends GatePart> {
        public List<ComponentStore.ComponentModel> models = new LinkedList<ComponentStore.ComponentModel>();
        public boolean reflect = false;

        public GateRenderer() {
            this.models.add(new ComponentStore.BaseComponentModel());
        }

        public void registerIcons(mt mt2) {
            for (ComponentStore.ComponentModel componentModel : this.models) {
                if (componentModel == null) continue;
                componentModel.registerTextures(mt2);
            }
        }

        public final void renderStatic(Transformation transformation, int n) {
            this.renderModels(transformation, this.reflect ? n + 24 : n);
        }

        public void renderModels(Transformation transformation, int n) {
            for (ComponentStore.ComponentModel componentModel : this.models) {
                componentModel.renderModel(transformation, n);
            }
        }

        public void renderDynamic(Transformation transformation) {
        }

        public void prepareInv() {
        }

        public void prepare(PartType PartType) {
        }

        public void prepareDynamic(PartType PartType, float f) {
        }

        public boolean hasSpecials() {
            return false;
        }

        public void spawnParticles(PartType PartType, Random random) {
            this.prepare(PartType);
            LinkedList<ComponentStore.RedstoneTorchModel> linkedList = new LinkedList<ComponentStore.RedstoneTorchModel>();
            for (ComponentStore.ComponentModel componentModel : this.models) {
                if (!(componentModel instanceof ComponentStore.RedstoneTorchModel)) continue;
                linkedList.add((ComponentStore.RedstoneTorchModel)componentModel);
            }
            for (ComponentStore.RedstoneTorchModel redstoneTorchModel : linkedList) {
                if (!redstoneTorchModel.on || random.nextInt(linkedList.size()) != 0) continue;
                Vector3 vector3 = new Vector3((double)random.nextFloat(), (double)random.nextFloat(), (double)random.nextFloat()).add(-0.5).multiply(0.05, 0.1, 0.05);
                vector3.add(redstoneTorchModel.lightPos);
                vector3.apply(((GatePart)((Object)PartType)).rotationT()).add((double)PartType.x(), (double)PartType.y(), (double)PartType.z());
                PartType.world().a("reddust", vector3.x, vector3.y, vector3.z, 0.0, 0.0, 0.0);
            }
        }
    }
}

