/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.integration;

import codechicken.lib.colour.Colour;
import codechicken.lib.lighting.LightModel;
import codechicken.lib.lighting.PlanarLightModel;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.ColourMultiplier;
import codechicken.lib.render.IUVTransformation;
import codechicken.lib.render.IVertexModifier;
import codechicken.lib.render.IconTransformation;
import codechicken.lib.render.MultiIconTransformation;
import codechicken.lib.render.TextureDataHolder;
import codechicken.lib.render.TextureSpecial;
import codechicken.lib.render.TextureUtils;
import codechicken.lib.render.UVScale;
import codechicken.lib.render.UVTranslation;
import codechicken.lib.render.Vertex5;
import codechicken.lib.vec.Rectangle4i;
import codechicken.lib.vec.RedundantTransformation;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.core.InvertX;
import mrtjp.projectred.integration.RenderGate;
import mrtjp.projectred.transmission.RenderWire;

public class ComponentStore {
    public static CCModel base = ComponentStore.loadBase("base");
    public static CCModel lightChip = ComponentStore.loadModel("chip");
    public static CCModel leverOn = ComponentStore.loadModel("leveron");
    public static CCModel leverOff = ComponentStore.loadModel("leveroff");
    public static CCModel solarArray = ComponentStore.loadModel("solar");
    public static CCModel rainSensor = ComponentStore.loadModel("rainsensor");
    public static CCModel pointer = ComponentStore.loadModel("pointer");
    public static CCModel busXcvr = ComponentStore.loadModel("array/busxcvr");
    public static CCModel busXcvrPanel = ComponentStore.loadModel("array/busxcvrpanel");
    public static CCModel nullCellWireBottom = ComponentStore.loadModel("array/nullcellbottomwire").apply((Transformation)new Translation(0.5, 0.0, 0.5));
    public static CCModel nullCellWireTop = ComponentStore.loadModel("array/nullcelltopwire").apply((Transformation)new Translation(0.5, 0.0, 0.5));
    public static CCModel nullCellBase = ComponentStore.loadBase("array/nullcellbase");
    public static CCModel extendedCellWireBottom = ComponentStore.loadModel("array/extendedcellbottomwire").apply((Transformation)new Translation(0.5, 0.0, 0.5));
    public static CCModel extendedCellWireTop = ComponentStore.loadModel("array/extendedcelltopwire").apply((Transformation)new Translation(0.5, 0.0, 0.5));
    public static CCModel extendedCellBase = ComponentStore.loadBase("array/extendedcellbase");
    public static CCModel cellWireSide = ComponentStore.loadModel("array/cellsidewire").apply((Transformation)new Translation(0.5, 0.0, 0.5));
    public static CCModel cellFrame = ComponentStore.loadModel("array/cellstand").apply((Transformation)new Translation(0.5, 0.0, 0.5));
    public static CCModel cellPlate = ComponentStore.loadModel("array/cellplate").apply((Transformation)new Translation(0.5, 0.0, 0.5));
    public static ms baseIcon;
    public static ms[] wireIcons;
    public static Colour[][] wireData;
    public static ms[] redstoneTorchIcons;
    public static ms[] taintedChipIcons;
    public static ms[] redstoneChipIcons;
    public static ms[] minusChipIcons;
    public static ms[] plusChipIcons;
    public static ms leverIcon;
    public static ms[] solarIcons;
    public static ms rainIcon;
    public static ms pointerIcon;
    public static ms busXcvrIcon;
    public static ms cellIcon;

    public static Map<String, CCModel> loadModels(String string) {
        return CCModel.parseObjModels((bjo)new bjo("projectred:textures/obj/gateparts/" + string + ".obj"), (int)7, (Transformation)new InvertX());
    }

    public static CCModel loadModel(String string) {
        Map<String, CCModel> map = ComponentStore.loadModels(string);
        CCModel cCModel = CCModel.combine(map.values());
        cCModel.computeNormals();
        cCModel.shrinkUVs(5.0E-4);
        return cCModel;
    }

    public static CCModel[] loadModelSet(String string, String[] ... stringArray) {
        Map<String, CCModel> map = ComponentStore.loadModels(string);
        CCModel[] cCModelArray = new CCModel[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            LinkedList<CCModel> linkedList = new LinkedList<CCModel>();
            for (String string2 : stringArray[i]) {
                linkedList.add(map.get(string2));
            }
            CCModel cCModel = CCModel.combine(linkedList);
            cCModel.computeNormals();
            cCModel.shrinkUVs(5.0E-4);
            cCModelArray[i] = cCModel;
        }
        return cCModelArray;
    }

    private static CCModel loadBase(String string) {
        CCModel cCModel = ComponentStore.loadModel(string);
        cCModel.apply((Transformation)new Translation(0.5, 0.0, 0.5));
        for (int i = 0; i < cCModel.verts.length; ++i) {
            cCModel.verts[i].vec.subtract(cCModel.normals[i].copy().multiply(2.0E-4));
        }
        return cCModel;
    }

    public static void registerIcons(mt mt2) {
        int n;
        String string = "projectred:gates/";
        baseIcon = mt2.a(string + "base");
        ComponentStore.wireIcons[0] = mt2.a(string + "surface/bordermatte");
        ComponentStore.wireIcons[1] = mt2.a(string + "surface/wirematte-OFF");
        ComponentStore.wireIcons[2] = mt2.a(string + "surface/wirematte-ON");
        for (n = 0; n < 3; ++n) {
            bjo bjo2 = new bjo(wireIcons[n].g());
            ComponentStore.wireData[n] = TextureUtils.loadTextureColours((bjo)new bjo(bjo2.b(), "textures/blocks/" + bjo2.a() + ".png"));
        }
        ComponentStore.redstoneTorchIcons[0] = mt2.a("redstone_torch_off");
        ComponentStore.redstoneTorchIcons[1] = mt2.a("redstone_torch_on");
        ComponentStore.taintedChipIcons[0] = mt2.a(string + "yellowchipoff");
        ComponentStore.taintedChipIcons[1] = mt2.a(string + "yellowchipon");
        ComponentStore.redstoneChipIcons[0] = mt2.a(string + "redchipoff");
        ComponentStore.redstoneChipIcons[1] = mt2.a(string + "redchipon");
        ComponentStore.minusChipIcons[0] = mt2.a(string + "minuschipoff");
        ComponentStore.minusChipIcons[1] = mt2.a(string + "minuschipon");
        ComponentStore.plusChipIcons[0] = mt2.a(string + "pluschipoff");
        ComponentStore.plusChipIcons[1] = mt2.a(string + "pluschipon");
        for (n = 0; n < 3; ++n) {
            ComponentStore.solarIcons[n] = mt2.a(string + "solar" + n);
        }
        rainIcon = mt2.a(string + "rainsensor");
        leverIcon = mt2.a(string + "lever");
        pointerIcon = mt2.a(string + "pointer");
        busXcvrIcon = mt2.a(string + "busxcvr");
        cellIcon = mt2.a(string + "cells");
        RenderGate.registerIcons(mt2);
    }

    public static WireComponentModel[] generateWireModels(String string, int n) {
        WireComponentModel[] wireComponentModelArray = new WireComponentModel[n];
        for (int i = 0; i < n; ++i) {
            wireComponentModelArray[i] = ComponentStore.generateWireModel(string + "-" + i);
        }
        return wireComponentModelArray;
    }

    public static WireComponentModel generateWireModel(String string) {
        Colour[] colourArray = TextureUtils.loadTextureColours((bjo)new bjo("projectred:textures/blocks/gates/surface/" + string + ".png"));
        WireComponentModel wireComponentModel = new WireComponentModel();
        if (Configurator.logicwires3D) {
            new WireModel3D(colourArray).bind(wireComponentModel);
        } else {
            new WireModel2D(colourArray).bind(wireComponentModel);
        }
        return wireComponentModel;
    }

    public static Transformation orientT(int n) {
        Transformation transformation = Rotation.sideOrientation((int)(n % 24 >> 2), (int)(n & 3));
        if (n >= 24) {
            transformation = new Scale(-1.0, 1.0, 1.0).with(transformation);
        }
        return transformation.at(Vector3.center);
    }

    public static Transformation dynamicT(int n) {
        return n == 0 ? new RedundantTransformation() : new Scale(-1.0, 1.0, 1.0).at(Vector3.center);
    }

    public static CCModel bakeCopy(CCModel cCModel, int n) {
        CCModel cCModel2 = cCModel.copy();
        if (n >= 24) {
            ComponentStore.reverseFacing(cCModel2);
        }
        cCModel2.apply(ComponentStore.orientT(n)).computeLighting(LightModel.standardLightModel);
        return cCModel2;
    }

    public static CCModel[] bakeDynamic(CCModel cCModel) {
        return new CCModel[]{cCModel.copy(), ComponentStore.reverseFacing(cCModel.copy())};
    }

    public static CCModel reverseFacing(CCModel cCModel) {
        for (int i = 0; i < cCModel.verts.length; i += 4) {
            Vertex5 vertex5 = cCModel.verts[i + 1];
            Vector3 vector3 = cCModel.normals[i + 1];
            cCModel.verts[i + 1] = cCModel.verts[i + 3];
            cCModel.normals[i + 1] = cCModel.normals[i + 3];
            cCModel.verts[i + 3] = vertex5;
            cCModel.normals[i + 3] = vector3;
        }
        return cCModel;
    }

    static {
        wireIcons = new ms[3];
        wireData = new Colour[3][];
        redstoneTorchIcons = new ms[2];
        taintedChipIcons = new ms[2];
        redstoneChipIcons = new ms[2];
        minusChipIcons = new ms[2];
        plusChipIcons = new ms[2];
        solarIcons = new ms[3];
    }

    public static class ExtendedCellBaseModel
    extends SimpleComponentModel {
        public ExtendedCellBaseModel() {
            super(extendedCellBase);
        }

        @Override
        public ms getIcon() {
            return cellIcon;
        }
    }

    public static class NullCellBaseModel
    extends SimpleComponentModel {
        public NullCellBaseModel() {
            super(nullCellBase);
        }

        @Override
        public ms getIcon() {
            return cellIcon;
        }
    }

    public static class CellPlateModel
    extends SimpleComponentModel {
        public CellPlateModel() {
            super(cellPlate);
        }

        @Override
        public ms getIcon() {
            return cellIcon;
        }
    }

    public static class CellFrameModel
    extends SimpleComponentModel {
        public CellFrameModel() {
            super(cellFrame);
        }

        @Override
        public ms getIcon() {
            return cellIcon;
        }
    }

    public static class CellBottomWireModel
    extends CellWireModel {
        public CCModel[] bottom = new CCModel[24];

        public CellBottomWireModel(CCModel cCModel) {
            for (int i = 0; i < 24; ++i) {
                this.bottom[i] = ComponentStore.bakeCopy(cCModel, i);
            }
        }

        @Override
        public void renderWire(Transformation transformation, int n, IVertexModifier iVertexModifier) {
            this.bottom[n].render(transformation, (IUVTransformation)new IconTransformation(cellIcon), iVertexModifier);
        }
    }

    public static class CellTopWireModel
    extends CellWireModel {
        public static CCModel[] left = new CCModel[24];
        public static CCModel[] right = new CCModel[24];
        public CCModel[] top = new CCModel[24];
        public byte conn;

        public CellTopWireModel(CCModel cCModel) {
            for (int i = 0; i < 24; ++i) {
                this.top[i] = ComponentStore.bakeCopy(cCModel, i);
            }
        }

        @Override
        public void renderWire(Transformation transformation, int n, IVertexModifier iVertexModifier) {
            IconTransformation iconTransformation = new IconTransformation(cellIcon);
            this.top[n].render(transformation, (IUVTransformation)iconTransformation, iVertexModifier);
            if ((this.conn & 2) == 0) {
                right[n].render(transformation, (IUVTransformation)iconTransformation, iVertexModifier);
            }
            if ((this.conn & 8) == 0) {
                left[n].render(transformation, (IUVTransformation)iconTransformation, iVertexModifier);
            }
        }

        static {
            CCModel cCModel = cellWireSide.copy().apply((Transformation)new Translation(-0.4375625, 0.0, 0.0));
            CCModel cCModel2 = cellWireSide.copy().apply((Transformation)new Translation(0.4375625, 0.0, 0.0));
            for (int i = 0; i < 24; ++i) {
                CellTopWireModel.left[i] = ComponentStore.bakeCopy(cCModel, i);
                CellTopWireModel.right[i] = ComponentStore.bakeCopy(cCModel2, i);
            }
        }
    }

    public static abstract class CellWireModel
    extends ComponentModel {
        public byte signal;
        public boolean invColour;

        public static int signalColour(byte by2) {
            return (by2 & 0xFF) / 2 + 60 << 24 | 0xFF;
        }

        @Override
        public final void renderModel(Transformation transformation, int n) {
            if (this.invColour) {
                CCRenderState.setColour((int)CellWireModel.signalColour((byte)0));
                this.renderWire(transformation, n, null);
                CCRenderState.setColour((int)-1);
            } else {
                this.renderWire(transformation, n, (IVertexModifier)new ColourMultiplier(CellWireModel.signalColour(this.signal)));
            }
        }

        public abstract void renderWire(Transformation var1, int var2, IVertexModifier var3);
    }

    public static class BusXcvrPanelModel
    extends ComponentModel {
        public static CCModel[] displayModels = new CCModel[16];
        public CCModel[] models;
        public Vector3 pos;
        public boolean flip;
        public int signal;

        public BusXcvrPanelModel(double d, double d2, boolean bl) {
            this.flip = bl;
            this.pos = new Vector3(d, 0.0, d2).multiply(0.0625);
            CCModel cCModel = busXcvrPanel.copy();
            if (bl) {
                cCModel.apply(Rotation.quarterRotations[2]);
            }
            cCModel.apply((Transformation)this.pos.translation());
            this.models = new CCModel[48];
            for (int i = 0; i < 48; ++i) {
                this.models[i] = ComponentStore.bakeCopy(cCModel, i);
            }
        }

        @Override
        public void renderModel(Transformation transformation, int n) {
            IconTransformation iconTransformation = new IconTransformation(busXcvrIcon);
            this.models[n].render(transformation, (IUVTransformation)iconTransformation);
            Vector3 vector3 = this.pos.copy();
            if (n >= 24) {
                vector3.x = 1.0 - vector3.x;
            }
            RedundantTransformation redundantTransformation = this.flip ? new RedundantTransformation() : Rotation.quarterRotations[2];
            redundantTransformation = redundantTransformation.with((Transformation)vector3.translation()).with(ComponentStore.orientT(n % 24)).with(transformation);
            for (int i = 0; i < 16; ++i) {
                if ((this.signal & 1 << i) == 0) continue;
                displayModels[i].render((Transformation)redundantTransformation, (IUVTransformation)iconTransformation, (IVertexModifier)PlanarLightModel.standardLightModel);
            }
        }

        static {
            for (int i = 0; i < 16; ++i) {
                CCModel cCModel = CCModel.quadModel((int)4);
                int n = i % 4;
                int n2 = i / 4;
                double d = 0.3126;
                cCModel.verts[0] = new Vertex5((double)n, d, (double)(n2 + 1), (double)n, (double)n2);
                cCModel.verts[1] = new Vertex5((double)(n + 1), d, (double)(n2 + 1), (double)(n + 1), (double)n2);
                cCModel.verts[2] = new Vertex5((double)(n + 1), d, (double)n2, (double)(n + 1), (double)(n2 + 1));
                cCModel.verts[3] = new Vertex5((double)n, d, (double)n2, (double)n, (double)(n2 + 1));
                cCModel.apply((Transformation)new Scale(0.0625, 1.0, 0.0625).with((Transformation)new Translation(-0.125, 0.0, -0.125)));
                cCModel.apply((IUVTransformation)new UVTranslation(22.0, 0.0));
                cCModel.apply((IUVTransformation)new UVScale(0.03125));
                cCModel.computeNormals();
                cCModel.shrinkUVs(5.0E-4);
                BusXcvrPanelModel.displayModels[i] = cCModel;
            }
        }
    }

    public static class BusXcvrCableModel
    extends BundledCableModel {
        public BusXcvrCableModel() {
            super(busXcvr, new Vector3(8.0, 0.0, 8.0), 0.3125, 0.4375);
        }

        @Override
        public IUVTransformation getUVT() {
            return new IconTransformation(busXcvrIcon);
        }
    }

    public static abstract class BundledCableModel
    extends SingleComponentModel {
        public BundledCableModel(CCModel cCModel, Vector3 vector3, double d, double d2) {
            super(cCModel, vector3);
            for (int i = 0; i < 48; ++i) {
                int n = i % 24 >> 2;
                int n2 = i & 3;
                boolean bl = i >= 24;
                boolean bl2 = (n2 + RenderWire.reorientSide[n]) % 4 >= 2;
                RedundantTransformation redundantTransformation = new RedundantTransformation();
                if (bl) {
                    redundantTransformation = redundantTransformation.with((Transformation)new Scale(-1.0, 0.0, 1.0));
                }
                if (bl2) {
                    redundantTransformation = redundantTransformation.with(Rotation.quarterRotations[2]);
                }
                if (redundantTransformation instanceof RedundantTransformation) continue;
                this.models[i].apply((IUVTransformation)new RenderWire.UVT(redundantTransformation.at(new Vector3(d, 0.0, d2))));
            }
        }
    }

    public static class PointerModel
    extends ComponentModel {
        public CCModel[] models;
        public double angle;
        public Vector3 pos;

        public PointerModel(double d, double d2, double d3) {
            this.models = ComponentStore.bakeDynamic(pointer);
            this.pos = new Vector3(d, d2 - 1.0, d3).multiply(0.0625);
        }

        public PointerModel(double d, double d2, double d3, double d4) {
            this.models = ComponentStore.bakeDynamic(pointer.copy().apply((Transformation)new Scale(d4, 1.0, d4)));
            this.pos = new Vector3(d, d2 - 1.0, d3).multiply(0.0625);
        }

        @Override
        public void renderModel(Transformation transformation, int n) {
            this.models[n].render((Transformation)new Rotation(-this.angle + Math.PI, 0.0, 1.0, 0.0).with((Transformation)this.pos.translation()).with(ComponentStore.dynamicT(n)).with(transformation), (IUVTransformation)new IconTransformation(pointerIcon), (IVertexModifier)LightModel.standardLightModel);
        }
    }

    public static class RainSensorModel
    extends SimpleComponentModel {
        public RainSensorModel(double d, double d2) {
            super(rainSensor, new Vector3(d, 0.0, d2));
        }

        @Override
        public ms getIcon() {
            return rainIcon;
        }
    }

    public static class SolarModel
    extends StateIconModel {
        public SolarModel(double d, double d2) {
            super(solarArray, new Vector3(d, 0.0, d2));
        }

        @Override
        public ms[] getIcons() {
            return solarIcons;
        }
    }

    public static class PlusChipModel
    extends OnOffModel {
        public PlusChipModel(double d, double d2) {
            super(lightChip, new Vector3(d, 0.0, d2));
        }

        @Override
        public ms[] getIcons() {
            return plusChipIcons;
        }
    }

    public static class MinusChipModel
    extends OnOffModel {
        public MinusChipModel(double d, double d2) {
            super(lightChip, new Vector3(d, 0.0, d2));
        }

        @Override
        public ms[] getIcons() {
            return minusChipIcons;
        }
    }

    public static class RedChipModel
    extends OnOffModel {
        public RedChipModel(double d, double d2) {
            super(lightChip, new Vector3(d, 0.0, d2));
        }

        @Override
        public ms[] getIcons() {
            return redstoneChipIcons;
        }
    }

    public static class YellowChipModel
    extends OnOffModel {
        public YellowChipModel(double d, double d2) {
            super(lightChip, new Vector3(d, 0.0, d2));
        }

        @Override
        public ms[] getIcons() {
            return taintedChipIcons;
        }
    }

    public static class FlippedRSTorchModel
    extends RedstoneTorchModel {
        public FlippedRSTorchModel(double d, double d2) {
            super(FlippedRSTorchModel.genModel(4, d, d2).apply((Transformation)new Rotation(3.1415926535897403, 0.0, 0.0, 1.0).at(Vector3.center).with((Transformation)new Translation(new Vector3(0.0, -6.0, 0.0).multiply(0.0625)))));
            this.lightPos = new Vector3(d, 3.0, d2).multiply(0.0625);
        }
    }

    public static class RedstoneTorchModel
    extends OnOffModel {
        public Vector3 lightPos;

        public RedstoneTorchModel(double d, double d2, int n) {
            super(RedstoneTorchModel.genModel(n, d, d2));
            this.lightPos = new Vector3(d, (double)(n - 1), d2).multiply(0.0625);
        }

        public RedstoneTorchModel(CCModel cCModel) {
            super(cCModel);
        }

        public static CCModel genModel(int n, double d, double d2) {
            CCModel cCModel = CCModel.quadModel((int)20);
            cCModel.verts[0] = new Vertex5(0.4375, 0.625, 0.5625, 0.4375, 0.5);
            cCModel.verts[1] = new Vertex5(0.5625, 0.625, 0.5625, 0.5625, 0.5);
            cCModel.verts[2] = new Vertex5(0.5625, 0.625, 0.4375, 0.5625, 0.375);
            cCModel.verts[3] = new Vertex5(0.4375, 0.625, 0.4375, 0.4375, 0.375);
            cCModel.generateBlock(4, 0.375, (double)(10 - n) / 16.0, 0.4375, 0.625, 0.6875, 0.5625, 51);
            cCModel.generateBlock(12, 0.4375, (double)(10 - n) / 16.0, 0.375, 0.5625, 0.6875, 0.625, 15);
            cCModel.apply((Transformation)new Translation(-0.5 + d / 16.0, (double)(n - 10) / 16.0, -0.5 + d2 / 16.0));
            cCModel.computeNormals();
            cCModel.shrinkUVs(5.0E-4);
            cCModel.apply((Transformation)new Scale(1.0005));
            return cCModel;
        }

        @Override
        public ms[] getIcons() {
            return redstoneTorchIcons;
        }
    }

    public static class WireModel2D
    extends ComponentModel {
        public static CCModel[] models = new CCModel[48];
        private static int iconCounter = 0;
        private WireComponentModel parent;
        public TextureSpecial[] icons;
        public Colour[] wireMask;
        private final int iconIndex = iconCounter++;

        public WireModel2D(Colour[] colourArray) {
            this.wireMask = colourArray;
        }

        public void bind(WireComponentModel wireComponentModel) {
            this.parent = wireComponentModel;
            wireComponentModel.bind(this);
        }

        @Override
        public void renderModel(Transformation transformation, int n) {
            models[n].render(transformation, (IUVTransformation)new IconTransformation((ms)this.icons[this.parent.disabled ? 0 : (this.parent.on ? 2 : 1)]));
        }

        @Override
        public void registerTextures(mt mt2) {
            List<Rectangle4i> list = WireComponentModel.rectangulate(this.wireMask);
            this.icons = new TextureSpecial[wireData.length];
            for (int i = 0; i < this.icons.length; ++i) {
                int[] nArray = new int[1024];
                for (Rectangle4i rectangle4i : list) {
                    this.fillMask(nArray, rectangle4i, 2);
                    this.fillMask(nArray, WireComponentModel.border(rectangle4i), 1);
                }
                int n = (int)Math.sqrt(wireData[0].length);
                int n2 = Math.max(32, n);
                int n3 = n2 / 32;
                int n4 = n2 / n;
                int[] nArray2 = new int[n2 * n2];
                for (int j = 0; j < nArray2.length; ++j) {
                    int n5 = j / n2;
                    int n6 = j % n2;
                    int n7 = nArray[n5 / n3 * 32 + n6 / n3];
                    if (n7 == 0) continue;
                    nArray2[j] = wireData[n7 == 1 ? 0 : i][n5 / n4 * n + n6 / n4].argb();
                }
                this.icons[i] = TextureUtils.getTextureSpecial((mt)mt2, (String)("projectred:gates/wire2d_" + this.iconIndex + "_" + i)).addTexture(new TextureDataHolder(nArray2, n2));
            }
        }

        private void fillMask(int[] nArray, Rectangle4i rectangle4i, int n) {
            for (int i = rectangle4i.x; i < rectangle4i.x + rectangle4i.w; ++i) {
                for (int j = rectangle4i.y; j < rectangle4i.y + rectangle4i.h; ++j) {
                    if (nArray[j * 32 + i] >= n) continue;
                    nArray[j * 32 + i] = n;
                }
            }
        }

        static {
            CCModel cCModel = CCModel.quadModel((int)4).generateBlock(0, 0.0, 0.0, 0.0, 1.0, 0.127, 1.0, -3).computeNormals();
            cCModel.shrinkUVs(5.0E-4);
            for (int i = 0; i < 48; ++i) {
                WireModel2D.models[i] = ComponentStore.bakeCopy(cCModel, i);
            }
        }
    }

    public static class WireModel3D
    extends SingleComponentModel {
        private WireComponentModel parent;

        public WireModel3D(Colour[] colourArray) {
            super(WireModel3D.generateModel(colourArray));
        }

        public void bind(WireComponentModel wireComponentModel) {
            this.parent = wireComponentModel;
            wireComponentModel.bind(this);
        }

        private static CCModel generateModel(Colour[] colourArray) {
            List<Rectangle4i> list = WireComponentModel.rectangulate(colourArray);
            CCModel cCModel = CCModel.quadModel((int)(list.size() * 40));
            int n = 0;
            for (Rectangle4i rectangle4i : list) {
                WireModel3D.generateWireSegment(cCModel, n, rectangle4i);
                n += 40;
            }
            cCModel.computeNormals();
            cCModel.shrinkUVs(5.0E-4);
            return cCModel;
        }

        private static void generateWireSegment(CCModel cCModel, int n, Rectangle4i rectangle4i) {
            WireModel3D.generateWireSegment(cCModel, n, WireComponentModel.border(rectangle4i), 0.01, 0);
            WireModel3D.generateWireSegment(cCModel, n + 20, rectangle4i, 0.02, 1);
        }

        private static void generateWireSegment(CCModel cCModel, int n, Rectangle4i rectangle4i, double d, int n2) {
            double d2 = (double)rectangle4i.x / 32.0;
            double d3 = (double)(rectangle4i.x + rectangle4i.w) / 32.0;
            double d4 = (double)rectangle4i.y / 32.0;
            double d5 = (double)(rectangle4i.y + rectangle4i.h) / 32.0;
            double d6 = 5.0E-4 - d / 50.0;
            cCModel.generateBlock(n, d2 + d6, 0.125, d4 + d6, d3 - d6, 0.125 + d, d5 - d6, 1);
            MultiIconTransformation.setIconIndex((CCModel)cCModel, (int)n, (int)(n + 20), (int)n2);
        }

        @Override
        public IUVTransformation getUVT() {
            if (this.parent.disabled) {
                return new IconTransformation(wireIcons[0]);
            }
            if (this.parent.on) {
                return new MultiIconTransformation(new ms[]{wireIcons[0], wireIcons[2]});
            }
            return new MultiIconTransformation(new ms[]{wireIcons[0], wireIcons[1]});
        }
    }

    public static class WireComponentModel
    extends ComponentModel {
        public boolean on;
        public boolean disabled;
        private ComponentModel model;

        public WireComponentModel bind(ComponentModel componentModel) {
            this.model = componentModel;
            return this;
        }

        protected static List<Rectangle4i> rectangulate(Colour[] colourArray) {
            int n;
            boolean[] blArray = new boolean[1024];
            for (int i = 0; i <= 30; ++i) {
                for (n = 0; n <= 30; ++n) {
                    if (colourArray[i * 32 + n].rgba() != -1 || WireComponentModel.overlap(blArray, n, i)) continue;
                    if (!WireComponentModel.segment2x2(colourArray, n, i)) {
                        throw new RuntimeException("Wire segment not 2x2 at (" + n + ", " + i + ")");
                    }
                    blArray[i * 32 + n] = true;
                }
            }
            LinkedList<Rectangle4i> linkedList = new LinkedList<Rectangle4i>();
            for (n = 0; n < 1024; ++n) {
                int n2;
                int n3;
                int n4;
                int n5;
                if (!blArray[n]) continue;
                Rectangle4i rectangle4i = new Rectangle4i(n % 32, n / 32, 0, 0);
                for (n5 = rectangle4i.x + 2; n5 < 30 && blArray[rectangle4i.y * 32 + n5]; n5 += 2) {
                }
                rectangle4i.w = n5 - rectangle4i.x;
                for (n4 = rectangle4i.y + 2; n4 < 30; n4 += 2) {
                    n3 = 1;
                    for (n2 = rectangle4i.x; n2 < rectangle4i.x + rectangle4i.w && n3 != 0; n2 += 2) {
                        if (blArray[n4 * 32 + n2]) continue;
                        n3 = 0;
                    }
                    if (n3 == 0) break;
                }
                rectangle4i.h = n4 - rectangle4i.y;
                for (n3 = rectangle4i.y; n3 < rectangle4i.y + rectangle4i.h; n3 += 2) {
                    for (n2 = rectangle4i.x; n2 < rectangle4i.x + rectangle4i.w; n2 += 2) {
                        blArray[n3 * 32 + n2] = false;
                    }
                }
                linkedList.add(rectangle4i);
            }
            return linkedList;
        }

        private static boolean overlap(boolean[] blArray, int n, int n2) {
            return blArray[n2 * 32 + n - 1] || blArray[(n2 - 1) * 32 + n] || blArray[(n2 - 1) * 32 + n - 1];
        }

        private static boolean segment2x2(Colour[] colourArray, int n, int n2) {
            return colourArray[n2 * 32 + n + 1].rgba() == -1 && colourArray[(n2 + 1) * 32 + n].rgba() == -1 && colourArray[(n2 + 1) * 32 + n + 1].rgba() == -1;
        }

        public static Rectangle4i border(Rectangle4i rectangle4i) {
            Rectangle4i rectangle4i2 = new Rectangle4i(rectangle4i.x - 2, rectangle4i.y - 2, rectangle4i.w + 4, rectangle4i.h + 4);
            if (rectangle4i2.x < 0) {
                rectangle4i2.w += rectangle4i2.x;
                rectangle4i2.x = 0;
            }
            if (rectangle4i2.y < 0) {
                rectangle4i2.h += rectangle4i2.y;
                rectangle4i2.y = 0;
            }
            if (rectangle4i2.x + rectangle4i2.w >= 32) {
                rectangle4i2.w -= rectangle4i2.x + rectangle4i2.w - 32;
            }
            if (rectangle4i2.y + rectangle4i2.h >= 32) {
                rectangle4i2.h -= rectangle4i2.y + rectangle4i2.h - 32;
            }
            return rectangle4i2;
        }

        @Override
        public void renderModel(Transformation transformation, int n) {
            this.model.renderModel(transformation, n);
        }

        @Override
        public void registerTextures(mt mt2) {
            this.model.registerTextures(mt2);
        }
    }

    public static abstract class StateIconModel
    extends SingleComponentModel {
        public int state;

        public StateIconModel(CCModel cCModel) {
            super(cCModel);
        }

        public StateIconModel(CCModel cCModel, Vector3 vector3) {
            super(cCModel, vector3);
        }

        public abstract ms[] getIcons();

        @Override
        public IUVTransformation getUVT() {
            return new IconTransformation(this.getIcons()[this.state]);
        }
    }

    public static abstract class OnOffModel
    extends SingleComponentModel {
        public boolean on;

        public OnOffModel(CCModel cCModel) {
            super(cCModel);
        }

        public OnOffModel(CCModel cCModel, Vector3 vector3) {
            super(cCModel, vector3);
        }

        public abstract ms[] getIcons();

        @Override
        public IUVTransformation getUVT() {
            return new IconTransformation(this.getIcons()[this.on ? 1 : 0]);
        }
    }

    public static abstract class SimpleComponentModel
    extends SingleComponentModel {
        public SimpleComponentModel(CCModel cCModel) {
            super(cCModel);
        }

        public SimpleComponentModel(CCModel cCModel, Vector3 vector3) {
            super(cCModel, vector3);
        }

        @Override
        public IUVTransformation getUVT() {
            return new IconTransformation(this.getIcon());
        }

        public abstract ms getIcon();
    }

    public static class LeverModel
    extends MultiComponentModel {
        public LeverModel(double d, double d2) {
            super(new Vector3(d, 2.0, d2), leverOn, leverOff);
        }

        @Override
        public IUVTransformation getUVT() {
            return new IconTransformation(leverIcon);
        }
    }

    public static abstract class MultiComponentModel
    extends ComponentModel {
        public CCModel[][] models;
        public int state;

        public MultiComponentModel(CCModel ... cCModelArray) {
            this(new Vector3(0.0, 0.0, 0.0), cCModelArray);
        }

        public MultiComponentModel(Vector3 vector3, CCModel ... cCModelArray) {
            this.models = new CCModel[cCModelArray.length][48];
            for (int i = 0; i < cCModelArray.length; ++i) {
                for (int j = 0; j < 48; ++j) {
                    this.models[i][j] = ComponentStore.bakeCopy(cCModelArray[i].copy().apply((Transformation)vector3.copy().multiply(0.0625).translation()), j);
                }
            }
        }

        public abstract IUVTransformation getUVT();

        @Override
        public void renderModel(Transformation transformation, int n) {
            this.models[this.state][n].render(transformation, this.getUVT());
        }
    }

    public static abstract class SingleComponentModel
    extends ComponentModel {
        public CCModel[] models = new CCModel[48];

        public SingleComponentModel(CCModel cCModel) {
            for (int i = 0; i < 48; ++i) {
                this.models[i] = ComponentStore.bakeCopy(cCModel, i);
            }
        }

        public SingleComponentModel(CCModel cCModel, Vector3 vector3) {
            this(cCModel.copy().apply((Transformation)vector3.multiply(0.0625).translation()));
        }

        public abstract IUVTransformation getUVT();

        @Override
        public void renderModel(Transformation transformation, int n) {
            this.models[n].render(transformation, this.getUVT());
        }
    }

    public static class BaseComponentModel
    extends ComponentModel {
        public static CCModel[] models = new CCModel[24];

        @Override
        public void renderModel(Transformation transformation, int n) {
            models[n % 24].render(transformation, (IUVTransformation)new IconTransformation(baseIcon));
        }

        static {
            for (int i = 0; i < 24; ++i) {
                BaseComponentModel.models[i] = ComponentStore.bakeCopy(base, i);
            }
        }
    }

    public static abstract class ComponentModel {
        public abstract void renderModel(Transformation var1, int var2);

        public void registerTextures(mt mt2) {
        }
    }
}

