/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.integration;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import mrtjp.projectred.api.IBundledEmitter;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.integration.BundledGatePart;
import mrtjp.projectred.integration.GatePart;
import mrtjp.projectred.integration.RedstoneGateLogic;
import mrtjp.projectred.transmission.BundledCableCommons;

public abstract class BundledGateLogic
extends RedstoneGateLogic<BundledGatePart> {
    public BundledGatePart gate;

    public static BundledGateLogic create(BundledGatePart bundledGatePart, int n) {
        if (n == 22) {
            return new BusTransceiver(bundledGatePart);
        }
        return null;
    }

    public BundledGateLogic(BundledGatePart bundledGatePart) {
        this.gate = bundledGatePart;
    }

    @Override
    public boolean canConnectTo(BundledGatePart bundledGatePart, IConnectable iConnectable, int n) {
        if (super.canConnectTo(bundledGatePart, iConnectable, n)) {
            return true;
        }
        if (iConnectable instanceof IBundledEmitter) {
            return this.canConnectBundled(bundledGatePart, n);
        }
        return false;
    }

    public boolean canConnectBundled(BundledGatePart bundledGatePart, int n) {
        return this.canConnectBundled(bundledGatePart.shape(), n);
    }

    public boolean canConnectBundled(int n, int n2) {
        return ((this.bundledInputMask(n) | this.bundledOutputMask(n)) & 1 << n2) != 0;
    }

    public int bundledInputMask(int n) {
        return 0;
    }

    public int bundledOutputMask(int n) {
        return 0;
    }

    @Override
    public int getOutput(BundledGatePart bundledGatePart, int n) {
        return (bundledGatePart.state & 16 << n) != 0 ? 15 : 0;
    }

    public byte[] getBundledOutput(BundledGatePart bundledGatePart, int n) {
        return null;
    }

    @Override
    public void onChange(BundledGatePart bundledGatePart) {
    }

    @Override
    public void scheduledTick(BundledGatePart bundledGatePart) {
    }

    public void save(by by2) {
    }

    public void load(by by2) {
    }

    public void readDesc(MCDataInput mCDataInput) {
    }

    public void writeDesc(MCDataOutput mCDataOutput) {
    }

    public void read(MCDataInput mCDataInput, int n) {
    }

    public static class BusTransceiver
    extends BundledGateLogic {
        public byte[] input0;
        public byte[] output0;
        public byte[] input2;
        public byte[] output2;

        public BusTransceiver(BundledGatePart bundledGatePart) {
            super(bundledGatePart);
        }

        @Override
        public void save(by by2) {
            BundledCableCommons.saveSignal(by2, "in0", this.input0);
            BundledCableCommons.saveSignal(by2, "out0", this.output0);
            BundledCableCommons.saveSignal(by2, "in2", this.input2);
            BundledCableCommons.saveSignal(by2, "out2", this.output2);
        }

        @Override
        public void load(by by2) {
            this.input0 = BundledCableCommons.loadSignal(by2, "in0");
            this.input2 = BundledCableCommons.loadSignal(by2, "in2");
            this.output0 = BundledCableCommons.loadSignal(by2, "out0");
            this.output2 = BundledCableCommons.loadSignal(by2, "out2");
        }

        @Override
        public void readDesc(MCDataInput mCDataInput) {
            this.unpackClientData(mCDataInput.readInt());
        }

        @Override
        public void writeDesc(MCDataOutput mCDataOutput) {
            mCDataOutput.writeInt(this.packClientData());
        }

        @Override
        public void read(MCDataInput mCDataInput, int n) {
            if (n == 11) {
                this.unpackClientData(mCDataInput.readInt());
            }
        }

        public void sendClientUpdate() {
            this.gate.getWriteStream(11).writeInt(this.packClientData());
        }

        public int packClientData() {
            return BundledCableCommons.packDigital(this.output0) | BundledCableCommons.packDigital(this.output2) << 16;
        }

        public void unpackClientData(int n) {
            this.output0 = BundledCableCommons.unpackDigital(this.output0, n & 0xFFFF);
            this.output2 = BundledCableCommons.unpackDigital(this.output2, n >>> 16);
        }

        @Override
        public int bundledInputMask(int n) {
            return 5;
        }

        @Override
        public int bundledOutputMask(int n) {
            return 5;
        }

        @Override
        public int inputMask(int n) {
            return 10;
        }

        @Override
        public int outputMask(int n) {
            return 0;
        }

        @Override
        public byte[] getBundledOutput(BundledGatePart bundledGatePart, int n) {
            return n == 0 ? this.output0 : this.output2;
        }

        public byte[] getBundledInput(int n) {
            return BundledCableCommons.raiseSignal(BundledCableCommons.copySignal(this.gate.getBundledInput(n)), this.getBundledOutput(this.gate, n));
        }

        @Override
        public void onChange(BundledGatePart bundledGatePart) {
            byte[] byArray;
            byte[] byArray2;
            int n;
            int n2 = bundledGatePart.state() & 0xF;
            if (n2 != (n = this.getInput(bundledGatePart, 10))) {
                bundledGatePart.setState(bundledGatePart.state() & 0xF0 | n);
                bundledGatePart.onInputChange();
            }
            if (!BundledCableCommons.signalsEqual(this.input0, byArray2 = this.getBundledInput(0))) {
                this.input0 = byArray2;
                bundledGatePart.onInputChange();
            }
            if (!BundledCableCommons.signalsEqual(this.input2, byArray = this.getBundledInput(2))) {
                this.input2 = byArray;
                bundledGatePart.onInputChange();
            }
            if (bundledGatePart.shape() == 1) {
                n = GatePart.flipMaskZ(n);
            }
            if (!BundledCableCommons.signalsEqual(this.output0, this.calcBundledOutput(0)) || !BundledCableCommons.signalsEqual(this.output2, this.calcBundledOutput(2))) {
                bundledGatePart.scheduleTick(2);
            }
        }

        public byte[] calcBundledOutput(int n) {
            int n2 = this.gate.state() & 0xF;
            if (this.gate.shape() == 1) {
                n2 = GatePart.flipMaskZ(n2);
            }
            if (n == 0) {
                return (n2 & 2) != 0 ? this.input2 : null;
            }
            if (n == 2) {
                return (n2 & 8) != 0 ? this.input0 : null;
            }
            return null;
        }

        @Override
        public void scheduledTick(BundledGatePart bundledGatePart) {
            this.output0 = this.calcBundledOutput(0);
            this.output2 = this.calcBundledOutput(2);
            this.onChange(bundledGatePart);
            bundledGatePart.onOutputChange(5);
            this.sendClientUpdate();
        }

        @Override
        public boolean cycleShape(BundledGatePart bundledGatePart) {
            bundledGatePart.setShape(bundledGatePart.shape() == 0 ? 1 : 0);
            return true;
        }

        @Override
        public int lightLevel() {
            return 0;
        }
    }
}

