/*
 * Decompiled with CFR 0.152.
 */
package openblocks.rubbish;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import openmods.words.IGenerator;
import openmods.words.Words;
import org.apache.commons.lang3.StringUtils;

public class LoreGenerator {
    private static final IGenerator heroGenerator = LoreGenerator.createHeroGenerator();
    private static final IGenerator loreGenerator = LoreGenerator.createLoreGenerator();
    private static final Random random = new Random();

    public static String generateLore(String playerName, String itemName) {
        HashMap params = Maps.newHashMap();
        params.put("player", playerName);
        params.put("item", itemName);
        return LoreGenerator.generate(loreGenerator, params);
    }

    public static String generateName() {
        HashMap params = Maps.newHashMap();
        return LoreGenerator.generate(heroGenerator, params);
    }

    private static String generate(IGenerator generator, Map<String, String> params) {
        return StringUtils.capitalize((String)generator.generate(random, params)).replaceAll("\\s+", " ");
    }

    private static IGenerator createHeroGenerator() {
        IGenerator heroesPrefix = Words.alt((Object[])new Object[]{"Grunnar", "Hermann", "Sven", "Grarg", "Blarf", "Hans", "Nathan", "Oglaf", "Eric", "Bob", "Banan", "Alaric"});
        IGenerator heroesPostfix = Words.alt((Object[])new Object[]{"ish", "ilde", "monkeybutt", "son", "shvili", "berg", "bert", "us"});
        IGenerator heroName = Words.word((Object[])new Object[]{heroesPrefix, Words.opt((float)0.6f, (IGenerator)heroesPostfix)});
        IGenerator heroOptional = Words.alt((Object[])new Object[]{"slightly", "sometimes", "mistakenly", "somehow", "part-time"});
        IGenerator heroAdj = Words.alt((Object[])new Object[]{"insane", "brave", "smelly", "philosophical", "jumping", "toothless", "burning", "heroic", "shy", "narcoleptic", "manly", "girly", "non-euclidian", "euphoric", "misanthropic", "ambivalent", "fictional", "fetishist"});
        IGenerator heroClass = Words.alt((Object[])new Object[]{"babycrusher", "wrestler", "nitpicker", "barber", "anesthesiologist", "sharpshooter", "plumber", "insurance salesman", "clown", "empiricist", "defenestrator", "visigoth"});
        IGenerator classicHeroes = Words.capitalizeFully((IGenerator)Words.seq((Object[])new Object[]{heroName, "the", Words.seq((Object[])new Object[]{Words.opt((float)0.2f, (IGenerator)heroOptional), heroAdj, heroClass, Words.opt((float)0.2f, (IGenerator)Words.word((Object[])new Object[]{"(lvl. ", Words.range((int)1, (int)11), ")"}))})}));
        IGenerator firstName = Words.alt((Object[])new Object[]{"Bill", "Juliet", "Nigel", "Steve", "Parsnip", "Cucumber", "Ludwig", "Markus", "Sven", "Clark", "Carl", "Throatwobbler", "Raymond", "Nancy", "Brian", "Brunhilda", "Richard", "Rupert"});
        IGenerator lastNameComponent = Words.alt((Object[])new Object[]{"Smith", "Weston", "Banana", "Drum", "Forklift", "Ampersand", "Fruitbat", "Fhtagn", "Svenson", "Stein", "Gutenabend", "Mangrove", "Bigglesworth", "Larch", "Semicolon", "Wurst", "Nixon", "Baden", "Priapus"});
        IGenerator lastName = Words.alt((Object[])new Object[]{lastNameComponent, Words.word((Object[])new Object[]{lastNameComponent, "-", lastNameComponent})});
        IGenerator pseudonym = Words.alt((Object[])new Object[]{"Duckie", "Nosepicker", "Snort", "Bomber", "Ouch", "Anvil", "Halfslab", "Radiator", "Barbie", "Biggles", "Income Tax", "Not In Face", "Tea Time", "Twerk", "Mutalisk", "Bueno", "Sixpack", "Yellow Snow"});
        IGenerator namePrefix = Words.alt((Object[])new Object[]{"Dr.", "Rev.", "Ms", "Mr", "Prof.", "Hon.", "Sgt.", "Cmdr.", "Sir", "Lady", "Comrade", "His Magnificence", "Her Holiness", "The Right Honourable"});
        IGenerator middleName = Words.alt((Object[])new Object[]{"W.", "T.", "F."});
        IGenerator nameSuffix = Words.alt((Object[])new Object[]{"M.Sc", "Ph.D", "OBE", "Jr.", "Sr.", "III", "II", "Esq."});
        IGenerator middleStuff = Words.seq((Object[])new Object[]{Words.opt((float)0.1f, (IGenerator)middleName), Words.opt((float)0.6f, (IGenerator)Words.word((Object[])new Object[]{"\"", pseudonym, "\""}))});
        IGenerator modernHeroes = Words.seq((Object[])new Object[]{Words.opt((float)0.4f, (IGenerator)namePrefix), firstName, middleStuff, Words.opt((float)0.3f, (IGenerator)Words.alt((Object[])new Object[]{"von", "de", "van", "van de", "de la"})), lastName, Words.opt((float)0.2f, (IGenerator)Words.word((Object[])new Object[]{" ", nameSuffix}))});
        return Words.alt((Object[])new Object[]{classicHeroes, modernHeroes});
    }

    private static IGenerator createLoreGenerator() {
        IGenerator adj1 = Words.alt((Object[])new Object[]{"overpowered", "misspelled", "store-brand", "unsettling", "unremarkable", "sleazy", "boring", "golden", "junky", "ergonomic", "low voltage", "many-angled"});
        IGenerator adj2 = Words.alt((Object[])new Object[]{"cursed", "legendary", "unique", "penultimate", "awesome", "suboptimal", "mighty", "ridiculously", "slightly"});
        IGenerator adjs = Words.seq((Object[])new Object[]{Words.opt((float)0.7f, (IGenerator)adj2), adj1});
        IGenerator parts = Words.alt((Object[])new Object[]{"codpiece", "loincloth", "tootbrush", "dental floss", "eggbeater", "rubber chicken with a pulley in the middle", "shovel", "hammoc", "panties", "spatula", "fedora"});
        IGenerator placeAdj = Words.alt((Object[])new Object[]{"deadly", "dreadful", "boring", "cheap", "backwater", "tax-free", "gluten-free", "dark", "evil", "misunderstood"});
        IGenerator kingdomAdjective = Words.alt((Object[])new Object[]{"loathing", "meat", "potatoes", "hydrocarbonates", "sweden", "slighlty unpleasant things", "herpaderp", "sobbing", "knitting"});
        IGenerator kingdomish = Words.seq((Object[])new Object[]{Words.opt((float)0.4f, (IGenerator)placeAdj), Words.alt((Object[])new Object[]{"kingdom", "cave", "gorge", "convention", "pit", "bazaar", "land"})});
        IGenerator placeWithAdj = Words.seq((Object[])new Object[]{kingdomish, "of", kingdomAdjective, Words.opt((float)0.2f, (IGenerator)Words.seq((Object[])new Object[]{"and", kingdomAdjective}))});
        IGenerator mountainName = Words.alt((Object[])new Object[]{"lard", "butter", "rotten eggs", "brimstone", "newts", "doom", "croc", "flipflop"});
        IGenerator mountain = Words.seq((Object[])new Object[]{Words.opt((float)0.6f, (IGenerator)placeAdj), "Mt.", mountainName});
        IGenerator hardcodedPlaces = Words.alt((Object[])new Object[]{"dalania", "prussia", "foobaria", "hot dog stand", "abyssinia", "zanzibar", "eastasia", "freedonia", "latveria", "woolloomooloo", "breslau", "uzbekistan", "north korea", "lower intestine", "hyperborea"});
        IGenerator places = Words.capitalizeFully((IGenerator)Words.alt((Object[])new Object[]{placeWithAdj, mountain, hardcodedPlaces}));
        IGenerator otherPeople = Words.alt((Object[])new Object[]{"youtube personalities", "dwarves", "villagers", "elves", "tax collectors", "quality testers", "boring people"});
        IGenerator actor = Words.seq((Object[])new Object[]{Words.alt((Object[])new Object[]{heroGenerator, Words.seq((Object[])new Object[]{otherPeople, "of", places})})});
        IGenerator story = Words.alt((Object[])new Object[]{"that nobody cares about", Words.seq((Object[])new Object[]{"that previously belonged to", actor})});
        IGenerator epicLoot = Words.seq((Object[])new Object[]{Words.opt((float)0.5f, (IGenerator)adjs), parts, story});
        IGenerator created = Words.seq((Object[])new Object[]{Words.alt((Object[])new Object[]{"repurposed from", "originally bundled with ", "forged from", "not to be mistaken with"}), epicLoot});
        IGenerator loaned = Words.seq((Object[])new Object[]{"loaned to", actor});
        IGenerator forgotten = Words.seq((Object[])new Object[]{"forgotten in", Words.alt((Object[])new Object[]{"post office", "loo", "deep hole", "hurry"})});
        IGenerator origin = Words.alt((Object[])new Object[]{created, Words.seq((Object[])new Object[]{Words.alt((Object[])new Object[]{"stolen", loaned, "imagined", forgotten, "found behind couch"}), "by", heroGenerator})});
        IGenerator itemModifier = Words.alt((Object[])new Object[]{"replica of"});
        IGenerator itemAction = Words.alt((Object[])new Object[]{"beating", "bleeding", "winds", "things", Words.word((Object[])new Object[]{Words.sub((String)"item", (String)"thing"), "ing"}), "cooking", "looting", "scrubing", "backpain", "hernia"});
        IGenerator itemType = Words.alt((Object[])new Object[]{Words.sub((String)"item", (String)"stuff"), Words.alt((Object[])new Object[]{"gizmo", "thingmajig", "doodad", "tat", "thingie"})});
        IGenerator item = Words.capitalize((IGenerator)Words.seq((Object[])new Object[]{Words.opt((float)0.9f, (IGenerator)adjs), itemType, Words.opt((float)0.9f, (IGenerator)Words.seq((Object[])new Object[]{"of", itemAction}))}));
        IGenerator fullItem = Words.seq((Object[])new Object[]{Words.opt((float)0.1f, (IGenerator)itemModifier), item, Words.opt((float)0.05f, (IGenerator)Words.seq((Object[])new Object[]{"(TM)"}))});
        IGenerator taunt = Words.alt((Object[])new Object[]{"wimp", "noob", "git", "fool", "that scoundrel", "scumbag"});
        IGenerator playerGet = Words.seq((Object[])new Object[]{Words.alt((Object[])new Object[]{"stolen from", "found in", "bought in", "dug out in", "smuggled from"}), places});
        IGenerator ownerInfo = Words.seq((Object[])new Object[]{playerGet, "by", Words.opt((float)0.3f, (IGenerator)Words.seq((Object[])new Object[]{taunt, "named"})), Words.sub((String)"player", (String)"Frank")});
        IGenerator randomItems = Words.alt((Object[])new Object[]{"bananas", "grapes", "hairpins", "corks", "shuffling", "squash", "penguins"});
        IGenerator organizationSpeciality = Words.alt((Object[])new Object[]{randomItems, Words.seq((Object[])new Object[]{randomItems, "and", randomItems})});
        IGenerator university = Words.capitalizeFully((IGenerator)Words.seq((Object[])new Object[]{"university of", Words.alt((Object[])new Object[]{hardcodedPlaces, organizationSpeciality})}));
        IGenerator institutish = Words.alt((Object[])new Object[]{"institute", "council", "committee"});
        IGenerator institute = Words.capitalizeFully((IGenerator)Words.seq((Object[])new Object[]{institutish, "of", organizationSpeciality}));
        IGenerator foundationFirst = Words.alt((Object[])new Object[]{"lick", "pick", "poke", "prod", "smell", "ring", "steal", "hug", "kick", "fwap"});
        IGenerator foundationSecond = Words.alt((Object[])new Object[]{"fish", "sauce", "leopard", "pick", "smell", "mayonaise", "steal", "grave", "derp"});
        IGenerator foundation = Words.seq((Object[])new Object[]{Words.word((Object[])new Object[]{Words.capitalizeFully((IGenerator)foundationFirst), "-a-", Words.capitalizeFully((IGenerator)foundationSecond)}), "foundation"});
        IGenerator organization = Words.alt((Object[])new Object[]{university, foundation, institute});
        IGenerator restoredInfo = Words.seq((Object[])new Object[]{"restored by", organization});
        IGenerator recent = Words.seq((Object[])new Object[]{"Recently", Words.alt((Object[])new Object[]{ownerInfo, restoredInfo})});
        IGenerator extra = Words.alt((Object[])new Object[]{"$1.99 each", "5 quids in plain wrapper", "Accept no substitues", "Made in China", "Batteries not included", "Patent pending"});
        return Words.word((Object[])new Object[]{fullItem, Words.opt((float)0.5f, (IGenerator)Words.seq((Object[])new Object[]{",", origin})), Words.opt((float)0.5f, (IGenerator)Words.seq((Object[])new Object[]{".", recent})), Words.opt((float)0.2f, (IGenerator)Words.seq((Object[])new Object[]{".", extra}))});
    }

    public static void main(String[] argv) {
        int i;
        System.out.println("Combination count: " + loreGenerator.count().doubleValue());
        for (i = 0; i < 50; ++i) {
            System.out.println(LoreGenerator.generateLore("xxx", "yyy"));
        }
        for (i = 0; i < 50; ++i) {
            System.out.println(LoreGenerator.generateName());
        }
    }
}

