/*
 * Decompiled with CFR 0.152.
 */
package openblocks.enchantments.flimflams;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import openblocks.api.IFlimFlamAction;
import openblocks.rubbish.LoreGenerator;
import openmods.utils.ItemUtils;

public class LoreFlimFlam
implements IFlimFlamAction {
    @Override
    public boolean execute(EntityPlayerMP target) {
        ArrayList slots = Lists.newArrayList((Object[])new Integer[]{0, 1, 2, 3, 4});
        Collections.shuffle(slots);
        Iterator i$ = slots.iterator();
        while (i$.hasNext()) {
            int slot = (Integer)i$.next();
            if (!LoreFlimFlam.tryAddLore((EntityPlayer)target, slot)) continue;
            return true;
        }
        return false;
    }

    private static boolean tryAddLore(EntityPlayer target, int slot) {
        ItemStack item = slot == 4 ? target.func_70694_bm() : target.field_71071_by.field_70460_b[slot];
        if (item == null) {
            return false;
        }
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)item);
        NBTTagCompound display = tag.func_74775_l("display");
        if (!tag.func_74764_b("display")) {
            tag.func_74782_a("display", (NBTBase)display);
        }
        String lore = LoreGenerator.generateLore(target.field_71092_bJ, LoreFlimFlam.identityType(item));
        NBTTagList loreList = new NBTTagList();
        for (String line : LoreFlimFlam.splitText(lore, 30)) {
            loreList.func_74742_a((NBTBase)new NBTTagString("lies", line));
        }
        display.func_74782_a("Lore", (NBTBase)loreList);
        return true;
    }

    private static List<String> splitText(String lore, int maxSize) {
        ArrayList result = Lists.newArrayList();
        Joiner joiner = Joiner.on((String)" ");
        Iterable words = Splitter.on((String)" ").omitEmptyStrings().split((CharSequence)lore);
        ArrayList buffer = Lists.newArrayList();
        int length = 0;
        for (String word : words) {
            int newLength = length + word.length();
            if (newLength > maxSize) {
                result.add(joiner.join((Iterable)buffer));
                length = 0;
                buffer.clear();
            }
            buffer.add(word);
            length += word.length() + 1;
        }
        if (!buffer.isEmpty()) {
            result.add(joiner.join((Iterable)buffer));
        }
        return result;
    }

    private static String identityType(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemArmor) {
            switch (((ItemArmor)item).field_77881_a) {
                case 0: {
                    return "helmet";
                }
                case 1: {
                    return "chestplate";
                }
                case 2: {
                    return "leggings";
                }
                case 3: {
                    return "boots";
                }
            }
        } else {
            if (item instanceof ItemPickaxe) {
                return "pickaxe";
            }
            if (item instanceof ItemShears) {
                return "shears";
            }
            if (item instanceof ItemAxe) {
                return "axe";
            }
            if (item instanceof ItemSpade) {
                return "shovel";
            }
            if (item instanceof ItemBlock) {
                return "block";
            }
            if (item instanceof ItemBucket) {
                return "bucket";
            }
        }
        return "junk";
    }
}

