/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraftforge.fluids.FluidStack;
import openblocks.OpenBlocks;
import openblocks.common.entity.EntityXPOrbNoFly;
import openmods.OpenMods;
import openmods.api.INeighbourAwareTile;
import openmods.liquids.GenericTank;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncableBoolean;
import openmods.sync.SyncableFlags;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.EnchantmentUtils;

public class TileEntityXPShower
extends SyncedTileEntity
implements INeighbourAwareTile {
    private static final int DRAIN_PER_CYCLE = 50;
    private GenericTank bufferTank = new GenericTank(1000, new FluidStack[]{OpenBlocks.XP_FLUID});
    private SyncableFlags sides = new SyncableFlags();
    private int drainedCountdown = 0;
    private SyncableBoolean isOn;
    private boolean isPowered = false;

    protected void createSyncedFields() {
        this.isOn = new SyncableBoolean();
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K) {
            if (!this.isPowered && OpenMods.proxy.getTicks(this.field_70331_k) % 3L == 0L) {
                int xpInTank;
                int drainable;
                this.bufferTank.autoFillFromSides(OpenMods.proxy, 50, (TileEntity)this, this.sides);
                int amountInTank = this.bufferTank.getFluidAmount();
                if (amountInTank > 0 && (drainable = EnchantmentUtils.XPToLiquidRatio((int)(xpInTank = EnchantmentUtils.liquidToXPRatio((int)amountInTank)))) > 0) {
                    this.bufferTank.drain(drainable, true);
                    this.drainedCountdown = 10;
                    while (xpInTank > 0) {
                        int xpAmount = EntityXPOrb.func_70527_a((int)xpInTank);
                        xpInTank -= xpAmount;
                        this.field_70331_k.func_72838_d((Entity)new EntityXPOrbNoFly(this.field_70331_k, (double)this.field_70329_l + 0.5, this.field_70330_m, (double)this.field_70327_n + 0.5, xpAmount));
                    }
                }
            }
            this.isOn.setValue(this.drainedCountdown-- > 0 && !this.isPowered);
            this.sync();
        } else if (this.isOn.getValue()) {
            Vec3 vec = this.field_70331_k.func_82732_R().func_72345_a((this.field_70331_k.field_73012_v.nextDouble() - 0.5) * 0.05, 0.0, (this.field_70331_k.field_73012_v.nextDouble() - 0.5) * 0.05);
            OpenBlocks.proxy.spawnLiquidSpray(this.field_70331_k, OpenBlocks.XP_FLUID, (double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.4, (double)this.field_70327_n + 0.5, 0.4f, 0.7f, vec);
        }
    }

    protected void initialize() {
        if (!this.field_70331_k.field_72995_K) {
            this.updateState();
        }
    }

    public void onNeighbourChanged(int blockId) {
        if (!this.field_70331_k.field_72995_K) {
            this.updateState();
        }
    }

    public void updateState() {
        this.isPowered = this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.sides.set((Enum)this.getRotation(), true);
    }

    public void func_70307_a(NBTTagCompound nbt) {
        this.bufferTank.readFromNBT(nbt);
    }

    public void func_70310_b(NBTTagCompound nbt) {
        this.bufferTank.writeToNBT(nbt);
    }

    public void onSynced(Set<ISyncableObject> changes) {
    }
}

