/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import openblocks.OpenBlocks;
import openmods.OpenMods;
import openmods.tileentity.OpenTileEntity;
import openmods.utils.EnchantmentUtils;

public class TileEntityXPDrain
extends OpenTileEntity {
    private WeakReference<TileEntity> targetTank;

    public void func_70316_g() {
        super.func_70316_g();
        if (OpenMods.proxy.getTicks(this.field_70331_k) % 100L == 0L) {
            this.searchForTank();
        }
        if (this.targetTank != null) {
            TileEntity tile = (TileEntity)this.targetTank.get();
            if (!(tile instanceof IFluidHandler) || tile.func_70320_p()) {
                this.targetTank = null;
            } else if (!this.field_70331_k.field_72995_K) {
                FluidStack xpStack;
                IFluidHandler tank = (IFluidHandler)tile;
                for (EntityXPOrb orb : this.getXPOrbsOnGrid()) {
                    if (orb.field_70128_L) continue;
                    xpStack = OpenBlocks.XP_FLUID.copy();
                    xpStack.amount = EnchantmentUtils.XPToLiquidRatio((int)orb.func_70526_d());
                    int filled = tank.fill(ForgeDirection.UP, xpStack, false);
                    if (filled != xpStack.amount) continue;
                    tank.fill(ForgeDirection.UP, xpStack, true);
                    orb.func_70106_y();
                }
                for (EntityPlayer player : this.getPlayersOnGrid()) {
                    xpStack = OpenBlocks.XP_FLUID.copy();
                    int experience = EnchantmentUtils.getPlayerXP((EntityPlayer)player);
                    int xpToDrain = Math.min(4, experience);
                    xpStack.amount = EnchantmentUtils.XPToLiquidRatio((int)xpToDrain);
                    int filled = tank.fill(ForgeDirection.UP, xpStack, false);
                    int theoreticalDrain = EnchantmentUtils.liquidToXPRatio((int)filled);
                    if (theoreticalDrain <= 0 && filled > 0 || filled <= 0 && theoreticalDrain > 0) {
                        return;
                    }
                    xpStack.amount = filled;
                    filled = tank.fill(ForgeDirection.UP, xpStack, true);
                    if (filled <= 0) continue;
                    if (OpenMods.proxy.getTicks(this.field_70331_k) % 4L == 0L) {
                        this.field_70331_k.func_72908_a((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5, "random.orb", 0.1f, 0.5f * ((this.field_70331_k.field_73012_v.nextFloat() - this.field_70331_k.field_73012_v.nextFloat()) * 0.7f + 1.8f));
                    }
                    int xpDrained = EnchantmentUtils.liquidToXPRatio((int)filled);
                    EnchantmentUtils.drainPlayerXP((EntityPlayer)player, (int)xpDrained);
                }
            }
        }
    }

    public void searchForTank() {
        this.targetTank = null;
        for (int y = this.field_70330_m - 1; y > 0; --y) {
            boolean isAir = this.field_70331_k.func_72799_c(this.field_70329_l, y, this.field_70327_n);
            if (isAir) continue;
            TileEntity te = this.field_70331_k.func_72796_p(this.field_70329_l, y, this.field_70327_n);
            if (!(te instanceof IFluidHandler) && te != null) {
                Block block = te.func_70311_o();
                if (!block.func_71926_d()) continue;
                return;
            }
            this.targetTank = new WeakReference<TileEntity>(te);
            return;
        }
    }

    protected List<EntityPlayer> getPlayersOnGrid() {
        AxisAlignedBB bb = AxisAlignedBB.func_72332_a().func_72299_a((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (double)(this.field_70329_l + 1), (double)(this.field_70330_m + 1), (double)(this.field_70327_n + 1));
        return this.field_70331_k.func_72872_a(EntityPlayer.class, bb);
    }

    protected List<EntityXPOrb> getXPOrbsOnGrid() {
        AxisAlignedBB bb = AxisAlignedBB.func_72332_a().func_72299_a((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (double)(this.field_70329_l + 1), (double)this.field_70330_m + 0.3, (double)(this.field_70327_n + 1));
        return this.field_70331_k.func_72872_a(EntityXPOrb.class, bb);
    }
}

