/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import openblocks.Config;
import openblocks.OpenBlocks;
import openmods.api.IActivateAwareTile;
import openmods.api.IPlaceAwareTile;
import openmods.include.IExtendable;
import openmods.include.IncludeInterface;
import openmods.include.IncludeOverride;
import openmods.liquids.GenericFluidHandler;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncableTank;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.Coord;
import openmods.utils.EnchantmentUtils;
import openmods.utils.ItemUtils;

public class TileEntityTank
extends SyncedTileEntity
implements IActivateAwareTile,
IPlaceAwareTile,
IExtendable {
    private SyncableTank tank;
    private double flowTimer = Math.random() * 100.0;
    private int previousFluidId = 0;
    @IncludeInterface(value=IFluidHandler.class)
    private final GenericFluidHandler tankWrapper = new GenericFluidHandler((IFluidTank)this.tank);
    public static final ForgeDirection[] horizontalDirections = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST};
    private static final Comparator<TileEntityTank> sortBySpace = new Comparator<TileEntityTank>(){

        @Override
        public int compare(TileEntityTank c1, TileEntityTank c2) {
            return c2.getSpace() - c1.getSpace();
        }
    };
    private static final Comparator<TileEntityTank> sortByAmount = new Comparator<TileEntityTank>(){

        @Override
        public int compare(TileEntityTank c1, TileEntityTank c2) {
            return c2.getAmount() - c1.getAmount();
        }
    };

    protected void createSyncedFields() {
        this.tank = new SyncableTank(TileEntityTank.getTankCapacity(), new FluidStack[0]);
    }

    public static int getTankCapacity() {
        return 1000 * Config.bucketsPerTank;
    }

    private TileEntityTank getTankInDirection(ForgeDirection direction) {
        TileEntity neighbor = this.getTileInDirection(direction);
        if (neighbor instanceof TileEntityTank && !neighbor.func_70320_p()) {
            return (TileEntityTank)neighbor;
        }
        return null;
    }

    private List<TileEntityTank> getHorizontalTanks(Set<Coord> except) {
        ArrayList horizontalTanks = Lists.newArrayList();
        Coord self = new Coord(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        for (ForgeDirection direction : horizontalDirections) {
            TileEntityTank te;
            Coord neigbor = self.getAdjacentCoord(direction);
            if (except.contains(neigbor) || !((te = this.getTankInDirection(direction)) instanceof TileEntityTank)) continue;
            horizontalTanks.add(te);
        }
        return horizontalTanks;
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K) {
            HashSet except = Sets.newHashSet((Object[])new Coord[]{this.getPosition()});
            if (this.tank.getFluidAmount() > 0) {
                this.updateTankBelow(except);
            }
            if (this.tank.getFluidAmount() > 0) {
                this.updateHorizontalNeighbors(except);
            }
            this.sync();
        } else {
            this.flowTimer += (double)0.1f;
        }
    }

    private void updateHorizontalNeighbors(Set<Coord> except) {
        List<TileEntityTank> horizontals = this.getHorizontalTanks(except);
        Collections.sort(horizontals, sortBySpace);
        for (TileEntityTank horizontal : horizontals) {
            int difference;
            FluidStack liquid;
            if (!horizontal.canReceiveLiquid(liquid = this.tank.getFluid()) || liquid == null || (difference = this.tank.getFluidAmount() - horizontal.getTank().getFluidAmount()) <= 1) continue;
            FluidStack liquidCopy = liquid.copy();
            liquidCopy.amount = Math.min(difference / 2, 500);
            int filled = horizontal.fill(liquidCopy, true, except);
            this.tank.drain(filled, true);
        }
    }

    private void updateTankBelow(Set<Coord> except) {
        FluidStack myLiquid;
        TileEntityTank below = this.getTankInDirection(ForgeDirection.DOWN);
        if (below != null && below.getSpace() > 0 && below.canReceiveLiquid(myLiquid = this.tank.getFluid().copy())) {
            int toFill;
            myLiquid.amount = toFill = Math.min(below.getSpace(), myLiquid.amount);
            int filled = below.fill(myLiquid, true, except);
            this.tank.drain(filled, true);
        }
    }

    private boolean canReceiveLiquid(FluidStack liquid) {
        if (liquid == null) {
            return true;
        }
        FluidStack otherLiquid = this.tank.getFluid();
        return otherLiquid == null || otherLiquid.isFluidEqual(liquid);
    }

    public IFluidTank getTank() {
        return this.tank;
    }

    private int getSpace() {
        return this.tank.getSpace();
    }

    private int getAmount() {
        return this.tank.getFluidAmount();
    }

    private int fill(FluidStack resource, boolean doFill, Set<Coord> except) {
        Coord pos;
        if (resource == null) {
            return 0;
        }
        if (except == null) {
            except = Sets.newHashSet();
        }
        if (except.contains(pos = this.getPosition())) {
            return 0;
        }
        except.add(pos);
        if (!this.canReceiveLiquid(resource)) {
            return 0;
        }
        resource = resource.copy();
        int startAmount = resource.amount;
        this.tryFillTankBelow(resource, doFill, except);
        if (resource.amount <= 0) {
            return startAmount;
        }
        int filled = this.tank.fill(resource, doFill);
        resource.amount -= filled;
        if (resource.amount <= 0) {
            return startAmount;
        }
        this.tryFillHorizontals(resource, doFill, except);
        if (resource.amount <= 0) {
            return startAmount;
        }
        this.tryFillTankAbove(resource, doFill, except);
        return startAmount - resource.amount;
    }

    private void tryFillHorizontals(FluidStack resource, boolean doFill, Set<Coord> except) {
        List<TileEntityTank> horizontals = this.getHorizontalTanks(except);
        int count = horizontals.size();
        if (count != 0) {
            int amountPerSide = resource.amount / count;
            int lastAmount = resource.amount - amountPerSide * (count - 1);
            if (lastAmount != amountPerSide) {
                Collections.sort(horizontals, sortByAmount);
            }
            for (int i = 0; i < count; ++i) {
                FluidStack copy = resource.copy();
                copy.amount = i == count - 1 ? lastAmount : amountPerSide;
                int filled = horizontals.get(i).fill(copy, doFill, except);
                resource.amount -= filled;
            }
        }
    }

    private void tryFillTankAbove(FluidStack resource, boolean doFill, Set<Coord> except) {
        TileEntityTank above = this.getTankInDirection(ForgeDirection.UP);
        if (above != null) {
            int filled = above.fill(resource, doFill, except);
            resource.amount -= filled;
        }
    }

    private void tryFillTankBelow(FluidStack resource, boolean doFill, Set<Coord> except) {
        TileEntityTank below = this.getTankInDirection(ForgeDirection.DOWN);
        if (below != null) {
            int filled = below.fill(resource, doFill, except);
            resource.amount -= filled;
        }
    }

    public void onSynced(Set<ISyncableObject> changes) {
        int newFluidId;
        int n = newFluidId = this.tank.getFluid() == null ? 0 : this.tank.getFluid().fluidID;
        if (newFluidId != this.previousFluidId) {
            this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
        this.previousFluidId = newFluidId;
    }

    public void onBlockPlacedBy(EntityPlayer player, ForgeDirection side, ItemStack stack, float hitX, float hitY, float hitZ) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("tank")) {
            NBTTagCompound tankTag = stack.func_77978_p().func_74775_l("tank");
            this.tank.readFromNBT(tankTag);
        }
    }

    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        int currentXP;
        int currentLevel;
        int nextXP;
        int requiredXP;
        int requiredXPJuice;
        FluidStack drained;
        ForgeDirection direction = ForgeDirection.getOrientation((int)side);
        ItemStack current = player.field_71071_by.func_70448_g();
        if (current != null) {
            ItemStack filled;
            FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)current);
            if (liquid != null) {
                int qty = this.fill(direction, liquid, true);
                if (qty != 0 && !player.field_71075_bZ.field_75098_d) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemUtils.consumeItem((ItemStack)current));
                }
                return true;
            }
            FluidStack available = this.tank.getFluid();
            if (this.field_70331_k.field_72995_K && this.getTank().getFluidAmount() > 0) {
                return true;
            }
            if (available != null && (liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)(filled = FluidContainerRegistry.fillFluidContainer((FluidStack)available, (ItemStack)current)))) != null) {
                if (!player.field_71075_bZ.field_75098_d) {
                    if (current.field_77994_a > 1) {
                        if (!player.field_71071_by.func_70441_a(filled)) {
                            return false;
                        }
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemUtils.consumeItem((ItemStack)current));
                    } else {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemUtils.consumeItem((ItemStack)current));
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, filled);
                    }
                }
                this.tank.drain(liquid.amount, true);
                return true;
            }
        } else if (this.tank.getFluid() != null && this.tank.getFluid().isFluidEqual(OpenBlocks.XP_FLUID) && (drained = this.tank.drain(requiredXPJuice = EnchantmentUtils.XPToLiquidRatio((int)(requiredXP = (nextXP = EnchantmentUtils.getExperienceForLevel((int)((currentLevel = EnchantmentUtils.getLevelForExperience((int)(currentXP = EnchantmentUtils.getPlayerXP((EntityPlayer)player)))) + 1))) - currentXP)), true)) != null) {
            EnchantmentUtils.addPlayerXP((EntityPlayer)player, (int)EnchantmentUtils.liquidToXPRatio((int)drained.amount));
        }
        return false;
    }

    public double getHeightForRender() {
        return (double)this.tank.getFluidAmount() / (double)this.tank.getCapacity();
    }

    public double getPercentFull() {
        return this.tank.getPercentFull();
    }

    public double getFlowOffset() {
        return Math.sin(this.flowTimer) / 35.0;
    }

    public NBTTagCompound getItemNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.tank.writeToNBT(nbt);
        return nbt;
    }

    @IncludeOverride
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.fill(resource, doFill, null);
    }

    public int getFluidLightLevel() {
        FluidStack fluid = this.tank.getFluid();
        if (fluid != null) {
            try {
                return fluid.getFluid().getLuminosity();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public RenderContext createRenderContext() {
        return new RenderContext();
    }

    public class RenderContext {
        public EnumMap<ForgeDirection, TileEntityTank> neighbors = Maps.newEnumMap(ForgeDirection.class);

        public RenderContext() {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                TileEntityTank tank = TileEntityTank.this.getTankInDirection(dir);
                if (tank == null) continue;
                this.neighbors.put(dir, tank);
            }
        }

        public double getLiquidHeightForSide(ForgeDirection ... sides) {
            double renderHeight = TileEntityTank.this.getHeightForRender();
            if (renderHeight <= 0.0) {
                return 0.0;
            }
            if (renderHeight > 0.98) {
                return 1.0;
            }
            double fullness = renderHeight + TileEntityTank.this.getFlowOffset();
            int count = 1;
            FluidStack fluid = TileEntityTank.this.tank.getFluid();
            for (ForgeDirection side : sides) {
                TileEntityTank sideTank = this.neighbors.get(side);
                if (sideTank == null || !sideTank.canReceiveLiquid(fluid)) continue;
                fullness += sideTank.getHeightForRender() + sideTank.getFlowOffset();
                ++count;
            }
            return Math.max(0.0, Math.min(1.0, fullness / (double)count));
        }

        public boolean hasNeighbor(ForgeDirection side) {
            return this.neighbors.containsKey(side);
        }
    }
}

