/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import com.google.common.base.Strings;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import openblocks.client.radio.RadioManager;
import openblocks.common.item.ItemTunedCrystal;
import openmods.GenericInventory;
import openmods.OpenMods;
import openmods.api.IActivateAwareTile;
import openmods.api.IBreakAwareTile;
import openmods.api.IInventoryCallback;
import openmods.api.INeighbourAwareTile;
import openmods.include.IExtendable;
import openmods.include.IncludeInterface;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncableBoolean;
import openmods.sync.SyncableByte;
import openmods.sync.SyncableFloat;
import openmods.sync.SyncableString;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.ColorUtils;
import openmods.utils.ItemUtils;

public class TileEntityRadio
extends SyncedTileEntity
implements IActivateAwareTile,
IBreakAwareTile,
INeighbourAwareTile,
IInventoryCallback,
IExtendable {
    private static final byte NO_CRYSTAL = -1;
    private SyncableString url;
    private SyncableString streamName;
    private SyncableByte crystalColor;
    private SyncableBoolean isPowered;
    private SyncableFloat volume;
    private String soundId;
    @IncludeInterface(value=IInventory.class)
    private final GenericInventory inventory = new GenericInventory("openblocks.radio", false, 1){

        public boolean func_94041_b(int i, ItemStack itemstack) {
            if (itemstack == null) {
                return true;
            }
            Item item = itemstack.func_77973_b();
            return item instanceof ItemTunedCrystal;
        }
    };

    public TileEntityRadio() {
        this.inventory.addCallback((IInventoryCallback)this);
    }

    protected void createSyncedFields() {
        this.url = new SyncableString();
        this.crystalColor = new SyncableByte(-1);
        this.isPowered = new SyncableBoolean();
        this.streamName = new SyncableString();
        this.volume = new SyncableFloat(1.0f);
    }

    protected void initialize() {
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        this.onNeighbourChanged(0);
    }

    private void updateURL(ItemStack stack) {
        if (stack == null) {
            this.url.clear();
            this.crystalColor.setValue((byte)-1);
        } else {
            NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
            this.url.setValue(tag.func_74779_i("URL"));
            this.streamName.setValue(stack.func_82833_r());
            this.crystalColor.setValue((byte)stack.func_77960_j());
        }
        this.sync();
    }

    public void onInventoryChanged(IInventory inventory, int slotNumber) {
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        this.updateURL(inventory.func_70301_a(0));
    }

    private void killMusic() {
        if (this.soundId != null) {
            RadioManager.instance.stopPlaying(this.soundId);
            this.soundId = null;
        }
    }

    public void onSynced(Set<ISyncableObject> changes) {
        this.syncCommon(changes);
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public void onServerSync(Set<ISyncableObject> changed) {
        this.syncCommon(changed);
    }

    protected void syncCommon(Set<ISyncableObject> changes) {
        boolean canPlay;
        if (changes.isEmpty()) {
            return;
        }
        boolean hasPower = this.isPowered.getValue();
        String urlValue = this.url.getValue();
        boolean hasUrl = !Strings.isNullOrEmpty((String)urlValue);
        boolean bl = canPlay = hasUrl && hasPower;
        if (changes.contains(this.isPowered) || changes.contains(this.url)) {
            if (this.field_70331_k.field_72995_K) {
                if (canPlay) {
                    try {
                        this.soundId = RadioManager.instance.startPlaying(this.soundId, urlValue, (float)this.field_70329_l + 0.5f, (float)this.field_70330_m + 0.5f, (float)this.field_70327_n + 0.5f, 0.5f * this.volume.getValue());
                        OpenMods.proxy.setNowPlayingTitle(this.streamName.getValue());
                    }
                    catch (RadioManager.RadioException e) {
                        Minecraft.func_71410_x().field_71439_g.func_71035_c(e.getMessage());
                        this.soundId = null;
                    }
                } else {
                    this.killMusic();
                }
            } else if (canPlay) {
                this.playStatic();
            }
        } else if (this.field_70331_k.field_72995_K && changes.contains(this.volume) && this.soundId != null) {
            RadioManager.instance.setVolume(this.soundId, this.volume.getValue());
        }
    }

    private void playStatic() {
        this.field_70331_k.func_72908_a((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5, "openblocks:radio", 1.0f, 2.0f);
    }

    public void onNeighbourChanged(int blockId) {
        if (!this.field_70331_k.field_72995_K) {
            boolean isPowered = this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            this.isPowered.setValue(isPowered);
            this.volume.setValue((float)this.field_70331_k.func_94572_D(this.field_70329_l, this.field_70330_m, this.field_70327_n) / 15.0f);
            this.sync();
        }
    }

    public void func_70313_j() {
        super.func_70313_j();
        this.killMusic();
    }

    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (!this.field_70331_k.field_72995_K) {
            Item heldItem;
            ItemStack held = player.func_70694_bm();
            ItemStack current = this.inventory.func_70301_a(0);
            if (held == null && current != null) {
                player.func_70062_b(0, current.func_77946_l());
                this.inventory.func_70299_a(0, null);
                this.func_70296_d();
                this.updateURL(null);
                return true;
            }
            if (held != null && (heldItem = held.func_77973_b()) instanceof ItemTunedCrystal) {
                this.inventory.func_70299_a(0, held.func_77946_l());
                player.func_70062_b(0, current);
                this.func_70296_d();
                this.updateURL(held);
                return true;
            }
        }
        return false;
    }

    public void onChunkUnload() {
        this.killMusic();
    }

    public void onBlockBroken() {
        this.killMusic();
    }

    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        this.inventory.writeToNBT(tag);
    }

    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.inventory.readFromNBT(tag);
    }

    public Integer getCrystalColor() {
        if (Strings.isNullOrEmpty((String)this.url.getValue())) {
            return null;
        }
        ColorUtils.ColorMeta color = ColorUtils.vanillaToColor((int)this.crystalColor.getValue());
        return color != null ? Integer.valueOf(color.rgb) : null;
    }
}

