/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.ForgeDirection;
import openblocks.api.IShapeProvider;
import openblocks.shapes.GuideShape;
import openmods.Log;
import openmods.api.IActivateAwareTile;
import openmods.shapes.IShapeable;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncableInt;
import openmods.tileentity.SyncedTileEntity;

public class TileEntityGuide
extends SyncedTileEntity
implements IShapeable,
IShapeProvider,
IActivateAwareTile {
    private boolean[][][] shape;
    private boolean[][][] previousShape;
    private float timeSinceChange = 0.0f;
    protected SyncableInt width;
    protected SyncableInt height;
    protected SyncableInt depth;
    protected SyncableInt mode;

    protected void createSyncedFields() {
        this.width = new SyncableInt(8);
        this.height = new SyncableInt(8);
        this.depth = new SyncableInt(8);
        this.mode = new SyncableInt(0);
    }

    public int getWidth() {
        return this.width.getValue();
    }

    public int getHeight() {
        return this.height.getValue();
    }

    public int getDepth() {
        return this.depth.getValue();
    }

    public void setWidth(int w) {
        this.width.setValue(w);
    }

    public void setDepth(int d) {
        this.depth.setValue(d);
    }

    public void setHeight(int h) {
        this.height.setValue(h);
    }

    public GuideShape getCurrentMode() {
        return GuideShape.values()[this.mode.getValue()];
    }

    public void func_70316_g() {
        if (this.field_70331_k.field_72995_K && (double)this.timeSinceChange < 1.0) {
            this.timeSinceChange = (float)Math.min(1.0, (double)this.timeSinceChange + 0.1);
        }
    }

    public float getTimeSinceChange() {
        return this.timeSinceChange;
    }

    private void recreateShape() {
        this.previousShape = this.shape;
        this.shape = new boolean[this.getHeight() * 2 + 1][this.getWidth() * 2 + 1][this.getDepth() * 2 + 1];
        this.getCurrentMode().generator.generateShape(this.getWidth(), this.getHeight(), this.getDepth(), (IShapeable)this);
        this.timeSinceChange = 0.0f;
    }

    public void setBlock(int x, int y, int z) {
        try {
            this.shape[this.getHeight() + y][this.getWidth() + x][this.getDepth() + z] = true;
        }
        catch (IndexOutOfBoundsException iobe) {
            Log.warn((Throwable)iobe, (String)"Index out of bounds setting block at %d,%d,%d", (Object[])new Object[]{x, y, z});
        }
    }

    public boolean[][][] getShape() {
        return this.shape;
    }

    public boolean[][][] getPreviousShape() {
        return this.previousShape;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB box = super.getRenderBoundingBox();
        return box.func_72314_b((double)this.getWidth(), (double)this.getHeight(), (double)this.getDepth());
    }

    private void switchMode(EntityPlayer player) {
        this.switchMode();
        player.func_70006_a(ChatMessageComponent.func_111082_b((String)"openblocks.misc.change_mode", (Object[])new Object[]{this.getCurrentMode().getLocalizedName()}));
    }

    private void switchMode() {
        int nextMode = this.mode.getValue() + 1;
        if (nextMode >= GuideShape.values().length) {
            nextMode = 0;
        }
        this.mode.setValue(nextMode);
        if (this.getCurrentMode().fixedRatio) {
            this.setHeight(this.getWidth());
            this.setDepth(this.getWidth());
        }
        this.recreateShape();
        this.sync();
    }

    private void changeDimensions(EntityPlayer player, ForgeDirection orientation) {
        this.changeDimensions(orientation);
        player.func_70006_a(ChatMessageComponent.func_111082_b((String)"openblocks.misc.change_size", (Object[])new Object[]{this.width.getValue(), this.height.getValue(), this.depth.getValue()}));
    }

    private void changeDimensions(ForgeDirection orientation) {
        if (this.width.getValue() > 0 && orientation == ForgeDirection.EAST) {
            this.width.modify(-1);
        } else if (orientation == ForgeDirection.WEST) {
            this.width.modify(1);
        } else if (orientation == ForgeDirection.NORTH) {
            this.depth.modify(1);
        } else if (this.depth.getValue() > 0 && orientation == ForgeDirection.SOUTH) {
            this.depth.modify(-1);
        } else if (orientation == ForgeDirection.UP) {
            this.height.modify(1);
        } else if (this.height.getValue() > 0 && orientation == ForgeDirection.DOWN) {
            this.height.modify(-1);
        }
        if (this.getCurrentMode().fixedRatio) {
            int h = this.getHeight();
            int w = this.getWidth();
            int d = this.getDepth();
            if (w != h && w != d) {
                this.setHeight(w);
                this.setDepth(w);
            } else if (h != w && h != d) {
                this.depth.setValue(h);
                this.width.setValue(h);
            } else if (d != w && d != h) {
                this.width.setValue(d);
                this.height.setValue(d);
            }
        }
        this.recreateShape();
        if (!this.field_70331_k.field_72995_K) {
            this.sync();
        }
    }

    @Override
    public ChunkCoordinates[] getShapeCoordinates() {
        if (this.shape == null) {
            this.recreateShape();
        }
        ArrayList<ChunkCoordinates> coords = new ArrayList<ChunkCoordinates>();
        if (this.shape != null) {
            for (int y2 = 0; y2 < this.shape.length; ++y2) {
                for (int x2 = 0; x2 < this.shape[y2].length; ++x2) {
                    for (int z2 = 0; z2 < this.shape[y2][x2].length; ++z2) {
                        if (!this.shape[y2][x2][z2]) continue;
                        coords.add(new ChunkCoordinates(this.field_70329_l + x2 - this.getWidth(), this.field_70330_m + y2 - this.getHeight(), this.field_70327_n + z2 - this.getDepth()));
                    }
                }
            }
        }
        return coords.toArray(new ChunkCoordinates[coords.size()]);
    }

    public void onSynced(Set<ISyncableObject> changes) {
        this.recreateShape();
    }

    private void fill(EntityPlayer player, int side) {
        ItemStack held = player.func_70694_bm();
        if (held == null) {
            return;
        }
        Item heldItem = held.func_77973_b();
        if (!(heldItem instanceof ItemBlock)) {
            return;
        }
        ItemBlock itemBlock = (ItemBlock)heldItem;
        for (ChunkCoordinates coord : this.getShapeCoordinates()) {
            this.field_70331_k.func_72832_d(coord.field_71574_a, coord.field_71572_b, coord.field_71573_c, itemBlock.func_77883_f(), itemBlock.func_77647_b(held.func_77960_j()), 3);
        }
    }

    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (this.field_70331_k.field_72995_K) {
            return true;
        }
        if (player.func_70093_af()) {
            this.switchMode(player);
        } else if (player.field_71075_bZ.field_75098_d && this.isInFillMode()) {
            this.fill(player, side);
        } else {
            this.changeDimensions(player, ForgeDirection.getOrientation((int)side));
        }
        return true;
    }

    private boolean isInFillMode() {
        return this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n) == Block.field_72089_ap.field_71990_ca;
    }
}

