/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.world.BlockEvent;
import openmods.GenericInventory;
import openmods.IInventoryProvider;
import openmods.api.INeighbourAwareTile;
import openmods.include.IExtendable;
import openmods.include.IncludeInterface;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncableBoolean;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.BlockUtils;
import openmods.utils.InventoryUtils;
import openmods.utils.OpenModsFakePlayer;

public class TileEntityBlockBreaker
extends SyncedTileEntity
implements INeighbourAwareTile,
IExtendable,
IInventoryProvider {
    private static final int SLOT_BUFFER = 0;
    private int redstoneAnimTimer;
    private SyncableBoolean activated;
    private final GenericInventory inventory = new GenericInventory("blockbreaker", true, 1){

        public boolean func_94041_b(int i, ItemStack itemstack) {
            return false;
        }
    };

    protected void createSyncedFields() {
        this.activated = new SyncableBoolean(false);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isActivated() {
        return this.activated.getValue();
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K && this.activated.getValue()) {
            if (this.redstoneAnimTimer <= 0) {
                this.activated.setValue(false);
                this.sync();
            } else {
                --this.redstoneAnimTimer;
            }
        }
    }

    private void setRedstoneSignal(boolean redstoneSignal) {
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        if (redstoneSignal && !this.activated.getValue()) {
            this.redstoneAnimTimer = 5;
            this.activated.setValue(true);
            this.sync();
            this.breakBlock();
        }
    }

    private void breakBlock() {
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        ForgeDirection direction = this.getRotation();
        int x = this.field_70329_l + direction.offsetX;
        int y = this.field_70330_m + direction.offsetY;
        int z = this.field_70327_n + direction.offsetZ;
        if (this.field_70331_k.func_72899_e(x, y, z)) {
            int blockId = this.field_70331_k.func_72798_a(x, y, z);
            Block block = Block.field_71973_m[blockId];
            if (block != null) {
                int metadata = this.field_70331_k.func_72805_g(x, y, z);
                if (block != Block.field_71986_z && block.func_71934_m(this.field_70331_k, z, y, z) > -1.0f) {
                    ArrayList items;
                    OpenModsFakePlayer fakePlayer = new OpenModsFakePlayer(this.field_70331_k);
                    fakePlayer.field_71071_by.field_70461_c = 0;
                    fakePlayer.field_71071_by.func_70299_a(0, new ItemStack(Item.field_77674_B, 0, 0));
                    BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(x, y, z, this.field_70331_k, block, this.field_70325_p, (EntityPlayer)fakePlayer);
                    if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                        return;
                    }
                    if (ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)fakePlayer, (int)metadata) && (items = block.getBlockDropped(this.field_70331_k, x, y, z, metadata, 0)) != null) {
                        ForgeDirection back = direction.getOpposite();
                        this.ejectAt(this.field_70331_k, this.field_70329_l + back.offsetX, this.field_70330_m + back.offsetY, this.field_70327_n + back.offsetZ, back, items);
                    }
                    fakePlayer.func_70106_y();
                    this.field_70331_k.func_72926_e(2001, x, y, z, blockId + (metadata << 12));
                    this.field_70331_k.func_94571_i(x, y, z);
                }
            }
            this.field_70331_k.func_72908_a((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5, "tile.piston.in", 0.5f, this.field_70331_k.field_73012_v.nextFloat() * 0.15f + 0.6f);
        }
    }

    private void ejectAt(World world, int x, int y, int z, ForgeDirection direction, List<ItemStack> itemStacks) {
        TileEntity targetInventory = this.getTileInDirection(direction);
        ItemStack currentStack = this.inventory.func_70301_a(0);
        if (currentStack != null) {
            BlockUtils.ejectItemInDirection((World)world, (double)x, (double)y, (double)z, (ForgeDirection)direction, (ItemStack)currentStack);
        }
        for (ItemStack stack : itemStacks) {
            if (stack == null) continue;
            if (targetInventory != null) {
                this.inventory.func_70299_a(0, stack);
                int amount = InventoryUtils.moveItemInto((IInventory)this.inventory, (int)0, (Object)targetInventory, (int)-1, (int)64, (ForgeDirection)direction, (boolean)true);
                this.inventory.func_70299_a(0, null);
                stack.field_77994_a -= amount;
            }
            if (stack.field_77994_a <= 0) continue;
            BlockUtils.ejectItemInDirection((World)world, (double)x, (double)y, (double)z, (ForgeDirection)direction, (ItemStack)stack);
        }
    }

    public void onNeighbourChanged(int blockId) {
        if (!this.field_70331_k.field_72995_K) {
            this.setRedstoneSignal(this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n));
        }
    }

    public void onSynced(Set<ISyncableObject> changes) {
        if (changes.contains(this.activated)) {
            this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    @IncludeInterface
    public IInventory getInventory() {
        return this.inventory;
    }

    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        this.inventory.writeToNBT(tag);
    }

    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.inventory.readFromNBT(tag);
    }
}

