/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import openblocks.OpenBlocks;
import openblocks.client.gui.GuiAutoAnvil;
import openblocks.common.container.ContainerAutoAnvil;
import openmods.GenericInventory;
import openmods.IInventoryProvider;
import openmods.OpenMods;
import openmods.api.IHasGui;
import openmods.include.IExtendable;
import openmods.include.IncludeInterface;
import openmods.include.IncludeOverride;
import openmods.liquids.SidedFluidHandler;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncableFlags;
import openmods.sync.SyncableTank;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.EnchantmentUtils;
import openmods.utils.InventoryUtils;
import openmods.utils.SidedInventoryAdapter;

public class TileEntityAutoAnvil
extends SyncedTileEntity
implements IHasGui,
IInventoryProvider,
IExtendable {
    protected static final int TOTAL_COOLDOWN = 40;
    protected static final int TANK_CAPACITY = EnchantmentUtils.getLiquidForLevel((int)45);
    protected int cooldown = 0;
    private SyncableFlags toolSides;
    private SyncableFlags modifierSides;
    private SyncableFlags outputSides;
    private SyncableFlags xpSides;
    private SyncableTank tank;
    private SyncableFlags automaticSlots;
    private final GenericInventory inventory = new GenericInventory("autoanvil", true, 3){

        public boolean func_94041_b(int i, ItemStack itemstack) {
            if (i == 0 && !itemstack.func_77973_b().func_77616_k(itemstack) && itemstack.func_77973_b() != Item.field_92105_bW) {
                return false;
            }
            if (i == 2) {
                return false;
            }
            return super.func_94041_b(i, itemstack);
        }
    };
    @IncludeInterface(value=ISidedInventory.class)
    private final SidedInventoryAdapter slotSides = new SidedInventoryAdapter((IInventory)this.inventory);
    @IncludeInterface
    private final IFluidHandler tankWrapper = new SidedFluidHandler.Drain(this.xpSides, (IFluidTank)this.tank);

    public TileEntityAutoAnvil() {
        this.slotSides.registerSlot((Enum)Slots.tool, this.toolSides, true, false);
        this.slotSides.registerSlot((Enum)Slots.modifier, this.modifierSides, true, false);
        this.slotSides.registerSlot((Enum)Slots.output, this.outputSides, false, true);
    }

    protected void createSyncedFields() {
        this.toolSides = new SyncableFlags();
        this.modifierSides = new SyncableFlags();
        this.outputSides = new SyncableFlags();
        this.xpSides = new SyncableFlags();
        this.tank = new SyncableTank(TANK_CAPACITY, new FluidStack[]{OpenBlocks.XP_FLUID});
        this.automaticSlots = new SyncableFlags();
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K) {
            if (this.automaticSlots.get((Enum)AutoSlots.xp)) {
                this.tank.autoFillFromSides(OpenMods.proxy, 100, (TileEntity)this, this.xpSides);
            }
            if (this.shouldAutoOutput() && this.hasOutput()) {
                InventoryUtils.moveItemsToOneOfSides((TileEntity)this, (Enum)Slots.output, (int)1, (SyncableFlags)this.outputSides);
            }
            if (this.shouldAutoInputTool() && !this.hasTool()) {
                InventoryUtils.moveItemsFromOneOfSides((TileEntity)this, null, (int)1, (Enum)Slots.tool, (SyncableFlags)this.toolSides);
            }
            if (this.shouldAutoInputModifier()) {
                InventoryUtils.moveItemsFromOneOfSides((TileEntity)this, null, (int)1, (Enum)Slots.modifier, (SyncableFlags)this.modifierSides);
            }
            if (this.cooldown == 0) {
                int liquidRequired = this.updateRepairOutput(false);
                if (liquidRequired > 0 && this.tank.getFluidAmount() >= liquidRequired) {
                    liquidRequired = this.updateRepairOutput(true);
                    this.field_70331_k.func_72908_a((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5, "random.anvil_use", 0.3f, 1.0f);
                    this.cooldown = 40;
                }
            } else if (this.cooldown > 0) {
                --this.cooldown;
            }
        }
    }

    public boolean canOpenGui(EntityPlayer player) {
        return true;
    }

    public Object getServerGui(EntityPlayer player) {
        return new ContainerAutoAnvil((IInventory)player.field_71071_by, this);
    }

    public Object getClientGui(EntityPlayer player) {
        return new GuiAutoAnvil(new ContainerAutoAnvil((IInventory)player.field_71071_by, this));
    }

    public SyncableFlags getToolSides() {
        return this.toolSides;
    }

    public SyncableFlags getModifierSides() {
        return this.modifierSides;
    }

    public SyncableFlags getOutputSides() {
        return this.outputSides;
    }

    public SyncableFlags getXPSides() {
        return this.xpSides;
    }

    public SyncableFlags getAutomaticSlots() {
        return this.automaticSlots;
    }

    private boolean shouldAutoInputModifier() {
        return this.automaticSlots.get((Enum)AutoSlots.modifier);
    }

    public boolean shouldAutoOutput() {
        return this.automaticSlots.get((Enum)AutoSlots.output);
    }

    private boolean hasTool() {
        return this.inventory.func_70301_a(0) != null;
    }

    private boolean shouldAutoInputTool() {
        return this.automaticSlots.get((Enum)AutoSlots.tool);
    }

    private boolean hasOutput() {
        return this.inventory.func_70301_a(2) != null;
    }

    public int updateRepairOutput(boolean doIt) {
        Enchantment enchantment;
        int enchLevel;
        int enchId;
        int l;
        boolean isEnchantedBook;
        ItemStack modifierStack = this.inventory.func_70301_a(1);
        ItemStack inputStack = this.inventory.func_70301_a(0);
        if (inputStack == null || modifierStack == null) {
            return 0;
        }
        int maximumCost = 0;
        int i = 0;
        int b0 = 0;
        ItemStack inputStackCopy = inputStack.func_77946_l();
        Map inputStackEnchantments = EnchantmentHelper.func_82781_a((ItemStack)inputStackCopy);
        int k = b0 + inputStack.func_82838_A() + modifierStack.func_82838_A();
        int stackSizeToBeUsedInRepair = 0;
        boolean bl = isEnchantedBook = modifierStack.field_77993_c == Item.field_92105_bW.field_77779_bT && Item.field_92105_bW.func_92110_g(modifierStack).func_74745_c() > 0;
        if (inputStackCopy.func_77984_f() && Item.field_77698_e[inputStackCopy.field_77993_c].func_82789_a(inputStack, modifierStack)) {
            int i1;
            l = Math.min(inputStackCopy.func_77952_i(), inputStackCopy.func_77958_k() / 4);
            if (l <= 0) {
                return 0;
            }
            for (i1 = 0; l > 0 && i1 < modifierStack.field_77994_a; ++i1) {
                int j1 = inputStackCopy.func_77952_i() - l;
                inputStackCopy.func_77964_b(j1);
                i += Math.max(1, l / 100) + inputStackEnchantments.size();
                l = Math.min(inputStackCopy.func_77952_i(), inputStackCopy.func_77958_k() / 4);
            }
            stackSizeToBeUsedInRepair = i1;
        } else {
            if (!(isEnchantedBook || inputStackCopy.field_77993_c == modifierStack.field_77993_c && inputStackCopy.func_77984_f())) {
                return 0;
            }
            if (inputStackCopy.func_77984_f() && !isEnchantedBook) {
                int l2 = inputStack.func_77958_k() - inputStack.func_77952_i();
                int i1 = modifierStack.func_77958_k() - modifierStack.func_77952_i();
                int j1 = i1 + inputStackCopy.func_77958_k() * 12 / 100;
                int i2 = l2 + j1;
                int k1 = inputStackCopy.func_77958_k() - i2;
                if (k1 < 0) {
                    k1 = 0;
                }
                if (k1 < inputStackCopy.func_77960_j()) {
                    inputStackCopy.func_77964_b(k1);
                    i += Math.max(1, j1 / 100);
                }
            }
            Map stackEnch = EnchantmentHelper.func_82781_a((ItemStack)modifierStack);
            for (Map.Entry e : stackEnch.entrySet()) {
                enchId = (Integer)e.getKey();
                enchLevel = (Integer)e.getValue();
                enchantment = Enchantment.field_77331_b[enchId];
                int k1 = inputStackEnchantments.containsKey(enchId) ? (Integer)inputStackEnchantments.get(enchId) : 0;
                int j2 = k1 == enchLevel ? ++enchLevel : Math.max(enchLevel, k1);
                int l1 = j2;
                int k2 = l1 - k1;
                boolean flag1 = enchantment.func_92089_a(inputStack);
                Iterator iterator1 = inputStackEnchantments.keySet().iterator();
                while (iterator1.hasNext()) {
                    int l2 = (Integer)iterator1.next();
                    if (l2 == enchId || enchantment.func_77326_a(Enchantment.field_77331_b[l2])) continue;
                    flag1 = false;
                    i += k2;
                }
                if (!flag1) continue;
                if (l1 > enchantment.func_77325_b()) {
                    l1 = enchantment.func_77325_b();
                }
                inputStackEnchantments.put(enchId, l1);
                int i3 = 0;
                switch (enchantment.func_77324_c()) {
                    case 1: {
                        i3 = 8;
                        break;
                    }
                    case 2: {
                        i3 = 4;
                    }
                    default: {
                        break;
                    }
                    case 5: {
                        i3 = 2;
                        break;
                    }
                    case 10: {
                        i3 = 1;
                    }
                }
                if (isEnchantedBook) {
                    i3 = Math.max(1, i3 / 2);
                }
                i += i3 * k2;
            }
        }
        l = 0;
        for (Map.Entry e : inputStackEnchantments.entrySet()) {
            enchId = (Integer)e.getKey();
            enchLevel = (Integer)e.getValue();
            enchantment = Enchantment.field_77331_b[enchId];
            int extra = 0;
            ++l;
            switch (enchantment.func_77324_c()) {
                case 1: {
                    extra = 8;
                    break;
                }
                case 2: {
                    extra = 4;
                }
                default: {
                    break;
                }
                case 5: {
                    extra = 2;
                    break;
                }
                case 10: {
                    extra = 1;
                }
            }
            if (isEnchantedBook) {
                extra = Math.max(1, extra / 2);
            }
            k += l + enchLevel * extra;
        }
        if (isEnchantedBook) {
            k = Math.max(1, k / 2);
        }
        if (isEnchantedBook && !Item.field_77698_e[inputStackCopy.field_77993_c].isBookEnchantable(inputStackCopy, modifierStack)) {
            inputStackCopy = null;
        }
        maximumCost = k + i;
        if (i <= 0) {
            inputStackCopy = null;
        }
        if (inputStackCopy != null) {
            int cost = Math.max(inputStackCopy.func_82838_A(), modifierStack.func_82838_A());
            if (inputStackCopy.func_82837_s()) {
                cost -= 9;
            }
            if (cost < 0) {
                cost = 0;
            }
            inputStackCopy.func_82841_c(cost += 2);
            EnchantmentHelper.func_82782_a((Map)inputStackEnchantments, (ItemStack)inputStackCopy);
            int requiredXP = EnchantmentUtils.getExperienceForLevel((int)maximumCost);
            int requiredLiquid = EnchantmentUtils.XPToLiquidRatio((int)requiredXP);
            if (this.tank.getFluidAmount() >= requiredLiquid && doIt) {
                this.tank.drain(requiredLiquid, true);
                this.inventory.func_70299_a(0, null);
                if (isEnchantedBook) {
                    stackSizeToBeUsedInRepair = 1;
                }
                this.inventory.func_70298_a(1, Math.max(1, stackSizeToBeUsedInRepair));
                this.inventory.func_70299_a(2, inputStackCopy);
                return 0;
            }
            return requiredLiquid;
        }
        return 0;
    }

    @IncludeOverride
    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public void onSynced(Set<ISyncableObject> changes) {
    }

    public IFluidTank getTank() {
        return this.tank;
    }

    public IInventory getInventory() {
        return this.slotSides;
    }

    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        this.inventory.writeToNBT(tag);
    }

    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.inventory.readFromNBT(tag);
    }

    public static enum AutoSlots {
        tool,
        modifier,
        output,
        xp;

    }

    public static enum Slots {
        tool,
        modifier,
        output;

    }
}

