/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import com.google.common.base.Strings;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraft.util.StatCollector;
import openblocks.Config;
import openblocks.OpenBlocks;
import openblocks.client.radio.RadioManager;
import openmods.utils.ColorUtils;
import openmods.utils.ItemUtils;
import org.apache.commons.lang3.StringUtils;

public class ItemTunedCrystal
extends Item {
    private static final String TAG_HIDDEN = "Hidden";
    public static final String TAG_URL = "URL";
    private Icon crystal;

    public ItemTunedCrystal() {
        super(Config.itemTunedCrystalId);
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77637_a(OpenBlocks.tabOpenBlocks);
    }

    public ItemStack createStack(RadioManager.RadioStation station) {
        ColorUtils.ColorMeta color = ColorUtils.vanillaToColor((int)15);
        boolean hidden = false;
        for (String attribute : station.attributes) {
            ColorUtils.ColorMeta possibleColor = ColorUtils.nameToColor((String)(attribute = StringUtils.strip((String)attribute)));
            if (possibleColor != null) {
                color = possibleColor;
                continue;
            }
            if ("hidden".equals(attribute = attribute.toLowerCase())) {
                hidden = true;
                continue;
            }
            throw new IllegalArgumentException("Unknown tuned crystal attribute: " + attribute);
        }
        ItemStack result = new ItemStack((Item)this, 1, color.vanillaId);
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)result);
        tag.func_74778_a(TAG_URL, station.url);
        if (!Strings.isNullOrEmpty((String)station.name)) {
            result.func_82834_c(station.name);
        }
        if (hidden) {
            tag.func_74757_a(TAG_HIDDEN, true);
        }
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int renderPass) {
        if (renderPass == 1) {
            return 0xFFFFFF;
        }
        int damage = stack.func_77960_j();
        ColorUtils.ColorMeta color = ColorUtils.vanillaToColor((int)damage);
        return color != null ? color.rgb : 0xFFFFFF;
    }

    public int getRenderPasses(int metadata) {
        return 2;
    }

    public Icon getIcon(ItemStack stack, int pass) {
        return pass == 1 ? this.field_77791_bV : this.crystal;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List result, boolean extended) {
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
        boolean hidden = tag.func_74767_n(TAG_HIDDEN);
        if (!hidden || player.field_71075_bZ.field_75098_d) {
            String url = tag.func_74779_i(TAG_URL);
            result.add(StatCollector.func_74837_a((String)"openblocks.misc.url", (Object[])new Object[]{url}));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister iconRegistry) {
        this.field_77791_bV = iconRegistry.func_94245_a("openblocks:tuned_crystal_2");
        this.crystal = iconRegistry.func_94245_a("openblocks:tuned_crystal_1");
    }

    public void func_77633_a(int itemId, CreativeTabs tab, List result) {
        for (RadioManager.RadioStation station : RadioManager.instance.getRadioStations()) {
            result.add(station.getStack());
        }
    }
}

