/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EnumStatus;
import net.minecraft.item.EnumArmorMaterial;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import openblocks.Config;
import openblocks.OpenBlocks;
import openblocks.client.model.ModelSleepingBag;
import openmods.utils.BlockUtils;

public class ItemSleepingBag
extends ItemArmor {
    private static final int ARMOR_CHESTPIECE = 1;
    public static final String TEXTURE_SLEEPINGBAG = "openblocks:textures/models/sleepingbag.png";

    public ItemSleepingBag() {
        super(Config.itemSleepingBagId, EnumArmorMaterial.IRON, 2, 1);
        this.func_77637_a(OpenBlocks.tabOpenBlocks);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, int layer) {
        return TEXTURE_SLEEPINGBAG;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister registry) {
        this.field_77791_bV = registry.func_94245_a("openblocks:sleepingbag");
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        return armorSlot == 1 ? ModelSleepingBag.instance : null;
    }

    public ItemStack func_77659_a(ItemStack sleepingBagStack, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            return sleepingBagStack;
        }
        ChunkCoordinates spawn = player.getBedLocation(world.field_73011_w.field_76574_g);
        EnumStatus status = player.func_71018_a((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        if (status == EnumStatus.OK) {
            int i = EntityLiving.func_82159_b((ItemStack)sleepingBagStack) - 1;
            ItemStack currentArmor = player.func_82169_q(i);
            if (currentArmor != null) {
                currentArmor = currentArmor.func_77946_l();
            }
            ItemSleepingBag.saveOriginalSpawn(spawn, sleepingBagStack);
            player.func_70062_b(i + 1, sleepingBagStack.func_77946_l());
            if (currentArmor != null) {
                return currentArmor;
            }
            --sleepingBagStack.field_77994_a;
            return sleepingBagStack;
        }
        return sleepingBagStack;
    }

    public boolean isValidArmor(ItemStack stack, int armorType, Entity entity) {
        return armorType == 1;
    }

    public void onArmorTickUpdate(World world, EntityPlayer player, ItemStack itemStack) {
        if (!world.field_72995_K) {
            NBTTagCompound tag = ItemSleepingBag.getOrCreateTag(itemStack);
            if (!player.func_70608_bn()) {
                if (tag != null && tag.func_74764_b("sleeping") && tag.func_74767_n("sleeping")) {
                    ItemSleepingBag.ejectSleepingBagFromPlayer(player, itemStack);
                } else {
                    ChunkCoordinates spawn = player.getBedLocation(world.field_73011_w.field_76574_g);
                    EnumStatus status = player.func_71018_a((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                    if (status == EnumStatus.OK) {
                        ItemSleepingBag.saveOriginalSpawn(spawn, itemStack);
                    } else {
                        ItemSleepingBag.ejectSleepingBagFromPlayer(player, itemStack);
                    }
                }
            } else {
                tag.func_74757_a("sleeping", true);
            }
        }
    }

    private static void ejectSleepingBagFromPlayer(EntityPlayer player, ItemStack itemStack) {
        NBTTagCompound tag = ItemSleepingBag.getOrCreateTag(itemStack);
        player.func_70062_b(3, null);
        ItemSleepingBag.revertSpawnFromItem(player, itemStack);
        tag.func_74757_a("sleeping", false);
        BlockUtils.dropItemStackInWorld((World)player.field_70170_p, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (ItemStack)itemStack);
    }

    private static NBTTagCompound getOrCreateTag(ItemStack itemStack) {
        NBTTagCompound tag = itemStack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            itemStack.func_77982_d(tag);
        }
        return tag;
    }

    private static void revertSpawnFromItem(EntityPlayer player, ItemStack itemStack) {
        NBTTagCompound tag = itemStack.func_77978_p();
        if (tag != null && tag.func_74764_b("spawnx") && tag.func_74764_b("spawny") && tag.func_74764_b("spawnz")) {
            ChunkCoordinates coords = new ChunkCoordinates(tag.func_74762_e("spawnx"), tag.func_74762_e("spawny"), tag.func_74762_e("spawnz"));
            player.setSpawnChunk(coords, false, player.field_70170_p.field_73011_w.field_76574_g);
        }
    }

    private static void saveOriginalSpawn(ChunkCoordinates spawn, ItemStack stack) {
        if (spawn != null) {
            NBTTagCompound tag = ItemSleepingBag.getOrCreateTag(stack);
            tag.func_74768_a("spawnx", spawn.field_71574_a);
            tag.func_74768_a("spawny", spawn.field_71572_b);
            tag.func_74768_a("spawnz", spawn.field_71573_c);
        }
    }

    public static boolean isWearingSleepingBag(EntityPlayer player) {
        ItemStack armor = player.func_82169_q(2);
        return armor != null && armor.func_77973_b() instanceof ItemSleepingBag;
    }
}

