/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.mutant;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import openblocks.api.IMutant;
import openblocks.api.IMutantRenderer;
import openblocks.utils.MutantUtils;

public class MutantRendererSpider
implements IMutantRenderer {
    private static final ResourceLocation texture = new ResourceLocation("textures/entity/spider/spider.png");
    public ModelRenderer head;
    public ModelRenderer neck;
    public ModelRenderer body;
    public ModelRenderer leg1;
    public ModelRenderer leg2;
    public ModelRenderer leg3;
    public ModelRenderer leg4;
    public ModelRenderer leg5;
    public ModelRenderer leg6;
    public ModelRenderer leg7;
    public ModelRenderer leg8;

    @Override
    public void initialize(ModelBase base) {
        base.field_78090_t = 64;
        base.field_78089_u = 32;
        this.head = new ModelRenderer(base, 32, 4);
        this.head.func_78789_a(-4.0f, -4.0f, -8.0f, 8, 8, 8);
        this.neck = new ModelRenderer(base, 0, 0);
        this.neck.func_78789_a(-3.0f, 3.0f, 3.0f, 6, 6, 6);
        this.body = new ModelRenderer(base, 0, 12);
        this.body.func_78789_a(-5.0f, 0.0f, -6.0f, 10, 8, 12);
        this.leg1 = new ModelRenderer(base, 18, 0);
        this.leg1.func_78789_a(-15.0f, -1.0f, -1.0f, 16, 2, 2);
        this.leg2 = new ModelRenderer(base, 18, 0);
        this.leg2.func_78789_a(-1.0f, -1.0f, -1.0f, 16, 2, 2);
        this.leg3 = new ModelRenderer(base, 18, 0);
        this.leg3.func_78789_a(-15.0f, -1.0f, -1.0f, 16, 2, 2);
        this.leg4 = new ModelRenderer(base, 18, 0);
        this.leg4.func_78789_a(-1.0f, -1.0f, -1.0f, 16, 2, 2);
        this.leg5 = new ModelRenderer(base, 18, 0);
        this.leg5.func_78789_a(-15.0f, -1.0f, -1.0f, 16, 2, 2);
        this.leg6 = new ModelRenderer(base, 18, 0);
        this.leg6.func_78789_a(-1.0f, -1.0f, -1.0f, 16, 2, 2);
        this.leg7 = new ModelRenderer(base, 18, 0);
        this.leg7.func_78789_a(-15.0f, -1.0f, -1.0f, 16, 2, 2);
        this.leg8 = new ModelRenderer(base, 18, 0);
        this.leg8.func_78789_a(-1.0f, -1.0f, -1.0f, 16, 2, 2);
    }

    @Override
    public void renderHead(IMutant mutant, float scale, float yaw, float pitch) {
        MutantRendererSpider.bindTexture();
        MutantUtils.bindToAttachmentPoint(mutant, this.head, mutant.getBody().getHeadAttachmentPoint());
        this.head.field_78795_f = pitch / 57.295776f;
        this.head.field_78796_g = yaw / 57.295776f;
        this.head.func_78785_a(scale);
    }

    @Override
    public void renderLegs(IMutant mutant, float scale, float legSwing, float prevLegSwing) {
        MutantRendererSpider.bindTexture();
        float var8 = 0.7853982f;
        this.leg1.field_78808_h = -var8;
        this.leg2.field_78808_h = var8;
        this.leg3.field_78808_h = -var8 * 0.74f;
        this.leg4.field_78808_h = var8 * 0.74f;
        this.leg5.field_78808_h = -var8 * 0.74f;
        this.leg6.field_78808_h = var8 * 0.74f;
        this.leg7.field_78808_h = -var8;
        this.leg8.field_78808_h = var8;
        float var9 = -0.0f;
        float var10 = 0.3926991f;
        this.leg1.field_78796_g = var10 * 2.0f + var9;
        this.leg2.field_78796_g = -var10 * 2.0f - var9;
        this.leg3.field_78796_g = var10 * 1.0f + var9;
        this.leg4.field_78796_g = -var10 * 1.0f - var9;
        this.leg5.field_78796_g = -var10 * 1.0f + var9;
        this.leg6.field_78796_g = var10 * 1.0f - var9;
        this.leg7.field_78796_g = -var10 * 2.0f + var9;
        this.leg8.field_78796_g = var10 * 2.0f - var9;
        float var11 = -(MathHelper.func_76134_b((float)(legSwing * 0.6662f * 2.0f + 0.0f)) * 0.4f) * prevLegSwing;
        float var12 = -(MathHelper.func_76134_b((float)(legSwing * 0.6662f * 2.0f + (float)Math.PI)) * 0.4f) * prevLegSwing;
        float var13 = -(MathHelper.func_76134_b((float)(legSwing * 0.6662f * 2.0f + 1.5707964f)) * 0.4f) * prevLegSwing;
        float var14 = -(MathHelper.func_76134_b((float)(legSwing * 0.6662f * 2.0f + 4.712389f)) * 0.4f) * prevLegSwing;
        float var15 = Math.abs(MathHelper.func_76126_a((float)(legSwing * 0.6662f + 0.0f)) * 0.4f) * prevLegSwing;
        float var16 = Math.abs(MathHelper.func_76126_a((float)(legSwing * 0.6662f + (float)Math.PI)) * 0.4f) * prevLegSwing;
        float var17 = Math.abs(MathHelper.func_76126_a((float)(legSwing * 0.6662f + 1.5707964f)) * 0.4f) * prevLegSwing;
        float var18 = Math.abs(MathHelper.func_76126_a((float)(legSwing * 0.6662f + 4.712389f)) * 0.4f) * prevLegSwing;
        this.leg1.field_78796_g += var11;
        this.leg2.field_78796_g += -var11;
        this.leg3.field_78796_g += var12;
        this.leg4.field_78796_g += -var12;
        this.leg5.field_78796_g += var13;
        this.leg6.field_78796_g += -var13;
        this.leg7.field_78796_g += var14;
        this.leg8.field_78796_g += -var14;
        this.leg1.field_78808_h += var15;
        this.leg2.field_78808_h += -var15;
        this.leg3.field_78808_h += var16;
        this.leg4.field_78808_h += -var16;
        this.leg5.field_78808_h += var17;
        this.leg6.field_78808_h += -var17;
        this.leg7.field_78808_h += var18;
        this.leg8.field_78808_h += -var18;
        Vec3[] legAttachmentPoints = mutant.getBody().getLegAttachmentPoints(mutant.getLegs().getNumberOfLegs());
        MutantUtils.bindToAttachmentPoint(mutant, this.leg1, legAttachmentPoints[0]);
        MutantUtils.bindToAttachmentPoint(mutant, this.leg2, legAttachmentPoints[1]);
        MutantUtils.bindToAttachmentPoint(mutant, this.leg3, legAttachmentPoints[2]);
        MutantUtils.bindToAttachmentPoint(mutant, this.leg4, legAttachmentPoints[3]);
        MutantUtils.bindToAttachmentPoint(mutant, this.leg5, legAttachmentPoints[4]);
        MutantUtils.bindToAttachmentPoint(mutant, this.leg6, legAttachmentPoints[5]);
        MutantUtils.bindToAttachmentPoint(mutant, this.leg7, legAttachmentPoints[6]);
        MutantUtils.bindToAttachmentPoint(mutant, this.leg8, legAttachmentPoints[7]);
        this.leg1.func_78785_a(scale);
        this.leg2.func_78785_a(scale);
        this.leg3.func_78785_a(scale);
        this.leg4.func_78785_a(scale);
        this.leg5.func_78785_a(scale);
        this.leg6.func_78785_a(scale);
        this.leg7.func_78785_a(scale);
        this.leg8.func_78785_a(scale);
    }

    @Override
    public void renderBody(IMutant mutant, float scale) {
        float h = 24.0f - (float)mutant.getLegHeight() - (float)mutant.getBodyHeight();
        this.body.func_78793_a(0.0f, h, 6.0f);
        this.neck.func_78793_a(0.0f, h - 1.0f, -9.0f);
        MutantRendererSpider.bindTexture();
        this.body.func_78785_a(scale);
        this.neck.func_78785_a(scale);
    }

    @Override
    public void renderWings(IMutant mutant, float scale, float wingSwing) {
    }

    @Override
    public void renderArms(IMutant mutant, float scale, float legSwing, float prevLegSwing) {
    }

    @Override
    public void renderTail(IMutant mutant, float scale, float legSwing, float prevLegSwing) {
    }

    private static void bindTexture() {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
    }
}

