/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.mutant;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import openblocks.api.IMutant;
import openblocks.api.IMutantRenderer;
import openblocks.client.model.ModelMutant;
import openblocks.utils.MutantUtils;

public class MutantRendererOcelot
implements IMutantRenderer {
    private static final ResourceLocation ocelotTextures = new ResourceLocation("textures/entity/cat/ocelot.png");
    private ModelRenderer tail1;
    private ModelRenderer tail2;
    private ModelRenderer head;
    private ModelRenderer body;
    private ModelRenderer leg1;
    private ModelRenderer leg2;
    private ModelRenderer leg3;
    private ModelRenderer leg4;

    @Override
    public void initialize(ModelBase base) {
        ModelMutant mutantModel = (ModelMutant)base;
        mutantModel._setTextureOffset("head.main", 0, 0);
        mutantModel._setTextureOffset("head.nose", 0, 24);
        mutantModel._setTextureOffset("head.ear1", 0, 10);
        mutantModel._setTextureOffset("head.ear2", 6, 10);
        this.head = new ModelRenderer(base, "head");
        this.head.func_78786_a("main", -2.5f, -2.0f, -3.0f, 5, 4, 5);
        this.head.func_78786_a("nose", -1.5f, 0.0f, -4.0f, 3, 2, 2);
        this.head.func_78786_a("ear1", -2.0f, -3.0f, 0.0f, 1, 1, 2);
        this.head.func_78786_a("ear2", 1.0f, -3.0f, 0.0f, 1, 1, 2);
        this.tail1 = new ModelRenderer(base, 0, 15);
        this.tail1.func_78789_a(-0.5f, 0.0f, 0.0f, 1, 8, 1);
        this.tail1.field_78795_f = 0.9f;
        this.tail2 = new ModelRenderer(base, 4, 15);
        this.tail2.func_78789_a(-0.5f, 0.0f, 0.0f, 1, 8, 1);
        this.body = new ModelRenderer(base, 20, 0);
        this.body.func_78789_a(-2.0f, -8.0f, -6.0f, 4, 16, 6);
        this.leg1 = new ModelRenderer(base, 8, 13);
        this.leg1.func_78789_a(-1.0f, 0.0f, -1.0f, 2, 6, 2);
        this.leg2 = new ModelRenderer(base, 8, 13);
        this.leg2.func_78789_a(-1.0f, 0.0f, -1.0f, 2, 6, 2);
        this.leg3 = new ModelRenderer(base, 8, 13);
        this.leg3.func_78789_a(-1.0f, 0.0f, -0.0f, 2, 6, 2);
        this.leg4 = new ModelRenderer(base, 8, 13);
        this.leg4.func_78789_a(-1.0f, 0.0f, -0.0f, 2, 6, 2);
    }

    @Override
    public void renderHead(IMutant mutant, float scale, float yaw, float pitch) {
        MutantRendererOcelot.bindTexture(ocelotTextures);
        MutantUtils.bindToAttachmentPoint(mutant, this.head, mutant.getBody().getHeadAttachmentPoint());
        this.head.field_78795_f = pitch / 57.295776f;
        this.head.field_78796_g = yaw / 57.295776f;
        this.head.func_78785_a(scale);
    }

    @Override
    public void renderLegs(IMutant mutant, float scale, float legSwing, float prevLegSwing) {
        MutantRendererOcelot.bindTexture(ocelotTextures);
        Vec3[] attachmentPoints = mutant.getBody().getLegAttachmentPoints(mutant.getNumberOfLegs());
        MutantUtils.bindToAttachmentPoint(mutant, this.leg1, attachmentPoints[0]);
        MutantUtils.bindToAttachmentPoint(mutant, this.leg2, attachmentPoints[1]);
        MutantUtils.bindToAttachmentPoint(mutant, this.leg3, attachmentPoints[2]);
        MutantUtils.bindToAttachmentPoint(mutant, this.leg4, attachmentPoints[3]);
        this.leg1.field_78795_f = MathHelper.func_76134_b((float)(legSwing * 0.6662f)) * 1.4f * prevLegSwing;
        this.leg2.field_78795_f = MathHelper.func_76134_b((float)(legSwing * 0.6662f + (float)Math.PI)) * 1.4f * prevLegSwing;
        this.leg3.field_78795_f = MathHelper.func_76134_b((float)(legSwing * 0.6662f + (float)Math.PI)) * 1.4f * prevLegSwing;
        this.leg4.field_78795_f = MathHelper.func_76134_b((float)(legSwing * 0.6662f)) * 1.4f * prevLegSwing;
        this.leg1.func_78785_a(scale);
        this.leg2.func_78785_a(scale);
        this.leg3.func_78785_a(scale);
        this.leg4.func_78785_a(scale);
    }

    @Override
    public void renderBody(IMutant mutant, float scale) {
        MutantRendererOcelot.bindTexture(ocelotTextures);
        this.body.func_78793_a(0.0f, 24.0f - (float)mutant.getLegHeight() - (float)mutant.getBodyHeight(), 1.0f);
        this.body.field_78795_f = 1.5707964f;
        this.body.func_78785_a(scale);
    }

    @Override
    public void renderWings(IMutant mutant, float scale, float wingSwing) {
    }

    @Override
    public void renderArms(IMutant mutant, float scale, float legSwing, float prevLegSwing) {
    }

    @Override
    public void renderTail(IMutant mutant, float scale, float legSwing, float prevLegSwing) {
        MutantRendererOcelot.bindTexture(ocelotTextures);
        Vec3 attachmentPoint = mutant.getBody().getTailAttachmentPoint();
        this.tail2.func_78793_a((float)attachmentPoint.field_72450_a, (float)((double)(24 - mutant.getLegHeight() - mutant.getBodyHeight()) - attachmentPoint.field_72448_b) + 5.0f, (float)attachmentPoint.field_72449_c + 6.0f);
        MutantUtils.bindToAttachmentPoint(mutant, this.tail1, attachmentPoint);
        this.tail2.field_78795_f = 1.7278761f + 0.7853982f * MathHelper.func_76134_b((float)legSwing) * prevLegSwing;
        this.tail1.func_78785_a(scale);
        this.tail2.func_78785_a(scale);
    }

    private static void bindTexture(ResourceLocation res) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(res);
    }
}

