/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.radio;

import com.google.common.base.Splitter;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Scanner;
import openblocks.client.radio.IcyConnectionHandler;
import openmods.Log;

public class UrlMeta {
    private static final String MIME_M3U_APP = "application/x-mpegurl";
    private static final String MIME_M3U_AUDIO = "audio/x-mpegurl";
    private static final String MIME_PLS = "audio/x-scpls";
    private Status status = Status.NOT_YET_RESOLVED;
    private String url;
    private String contentType;

    public UrlMeta(String url) {
        this.url = url;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getUrl() {
        return this.url;
    }

    public String getContentType() {
        return this.contentType;
    }

    public synchronized void markAsFailed() {
        this.status = Status.UNKOWN_ERROR;
    }

    public synchronized void resolve() {
        if (this.status == Status.NOT_YET_RESOLVED) {
            this.status = this.resolveImpl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Status resolveImpl() {
        Log.info((String)"Resolving URL %s", (Object[])new Object[]{this.url});
        HttpURLConnection connection = null;
        try {
            int responseCode;
            Status status;
            URL url;
            block18: while (true) {
                try {
                    url = new URL(null, this.url, new IcyConnectionHandler());
                }
                catch (MalformedURLException e) {
                    status = Status.INVALID_URL;
                    if (connection != null) {
                        connection.disconnect();
                    }
                    return status;
                }
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestProperty("User-Agent", "OpenMods/0.0 Minecraft/1.6.4");
                connection.setRequestProperty("Host", url.getHost() + ":" + url.getPort());
                try {
                    connection.connect();
                }
                catch (ConnectException e) {
                    Log.warn((Throwable)e, (String)"Can't connect to %s", (Object[])new Object[]{url});
                    status = Status.CANT_CONNECT;
                    if (connection != null) {
                        connection.disconnect();
                    }
                    return status;
                }
                responseCode = connection.getResponseCode();
                switch (responseCode) {
                    case 200: {
                        status = this.processStream(connection);
                        return status;
                    }
                    case 301: 
                    case 302: 
                    case 303: 
                    case 307: {
                        String redirectedUrl = connection.getHeaderField("location");
                        Log.fine((String)"Redirection to URL %s (code: %d)", (Object[])new Object[]{redirectedUrl, responseCode});
                        connection.disconnect();
                        this.url = redirectedUrl;
                        continue block18;
                    }
                    case 404: {
                        status = Status.NOT_FOUND;
                        return status;
                    }
                }
                break;
            }
            Log.warn((String)"Invalid status code from url %s: %d", (Object[])new Object[]{url, responseCode});
            status = Status.UNKOWN_ERROR;
            return status;
        }
        catch (Throwable t) {
            Log.warn((Throwable)t, (String)"Exception during opening url %s", (Object[])new Object[]{this.url});
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return Status.UNKOWN_ERROR;
    }

    private Status processStream(HttpURLConnection connection) {
        String contentType = connection.getContentType();
        Log.fine((String)"URL %s has content type %s", (Object[])new Object[]{this.url, contentType});
        if (contentType.equals(MIME_PLS)) {
            return this.parsePLS(connection);
        }
        if (contentType.equals(MIME_M3U_APP) || contentType.equals(MIME_M3U_AUDIO)) {
            return this.parseM3U(connection);
        }
        this.contentType = contentType;
        return Status.OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Status parsePLS(HttpURLConnection connection) {
        Log.fine((String)"Parsing PLS file at URL %s", (Object[])new Object[]{this.url});
        Scanner scanner = null;
        try {
            InputStreamReader reader = new InputStreamReader(connection.getInputStream());
            scanner = new Scanner(reader);
            String header = scanner.nextLine();
            if (!header.equals("[playlist]")) {
                Log.warn((String)"Invalid header '%s' in pls file %s", (Object[])new Object[]{header, this.url});
                Status status = Status.MALFORMED_DATA;
                return status;
            }
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                Iterable split = Splitter.on((char)'=').split((CharSequence)line);
                Iterator it = split.iterator();
                String name = (String)it.next();
                if (!name.startsWith("File")) continue;
                String value = (String)it.next();
                Log.fine((String)"Trying playlist %s entry %s = %s)", (Object[])new Object[]{this.url, name, value});
                this.url = value;
                Status result = this.resolveImpl();
                if (!result.valid) continue;
                Status status = result;
                return status;
            }
        }
        catch (Throwable t) {
            Log.warn((Throwable)t, (String)"Can't parse playlist file %s", (Object[])new Object[]{this.url});
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
        return Status.UNKOWN_ERROR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Status parseM3U(HttpURLConnection connection) {
        Log.info((String)"Parsing M3U file at URL %s", (Object[])new Object[]{this.url});
        Scanner scanner = null;
        try {
            InputStreamReader reader = new InputStreamReader(connection.getInputStream());
            scanner = new Scanner(reader);
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (line.startsWith("#")) continue;
                Log.fine((String)"Trying playlist %s entry %s)", (Object[])new Object[]{this.url, line});
                this.url = line;
                Status result = this.resolveImpl();
                if (!result.valid) continue;
                Status status = result;
                return status;
            }
        }
        catch (Throwable t) {
            Log.warn((Throwable)t, (String)"Can't parse playlist file %s", (Object[])new Object[]{this.url});
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
        return Status.UNKOWN_ERROR;
    }

    public static enum Status {
        NOT_YET_RESOLVED(false, "not_ready"),
        UNKOWN_ERROR(false, "unknown_error"),
        CANT_CONNECT(false, "cant_connect"),
        INVALID_URL(false, "invalid_url"),
        NOT_FOUND(false, "url_not_found"),
        MALFORMED_DATA(false, "malformed_data"),
        OK(true, "");

        public final boolean valid;
        public final String message;

        private Status(boolean valid, String message) {
            this.valid = valid;
            this.message = "openblocks.misc.radio." + message;
        }
    }
}

