/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.standalone;

import java.util.Iterator;
import org.dynmap.nbt.ByteArrayTag;
import org.dynmap.nbt.ByteTag;
import org.dynmap.nbt.CompoundMap;
import org.dynmap.nbt.CompoundTag;
import org.dynmap.nbt.IntArrayTag;
import org.dynmap.nbt.IntTag;
import org.dynmap.nbt.ListTag;
import org.dynmap.nbt.LongTag;

public class StandaloneChunkSnapshot {
    private static final int NUM_SECTIONS = 16;
    private static final int BLKS_PER_SECTION = 4096;
    private int x;
    private int z;
    private byte[] biomes;
    private long lastUpdate;
    private boolean populated;
    private int[] heightMap;
    private short[][] blockid = new short[16][];
    private byte[][] blockdata = new byte[16][];
    private byte[][] skylight = new byte[16][];
    private byte[][] emitlight = new byte[16][];
    private boolean[] notempty = new boolean[16];
    private static final short[] EMPTY_SECTION = new short[4096];
    private static final byte[] EMPTY_DATA = new byte[2048];
    private static final byte[] EMPTY_SKY = new byte[2048];

    public StandaloneChunkSnapshot() {
        for (int i = 0; i < 16; ++i) {
            this.blockid[i] = EMPTY_SECTION;
            this.blockdata[i] = EMPTY_DATA;
            this.skylight[i] = EMPTY_SKY;
            this.emitlight[i] = EMPTY_DATA;
        }
    }

    public StandaloneChunkSnapshot(CompoundTag tag) {
        this();
        CompoundMap map = tag.getValue();
        map = ((CompoundTag)map.get("Level")).getValue();
        this.x = ((IntTag)map.get("xPos")).getValue();
        this.z = ((IntTag)map.get("zPos")).getValue();
        this.biomes = ((ByteArrayTag)map.get("Biomes")).getValue();
        this.lastUpdate = ((LongTag)map.get("LastUpdate")).getValue();
        this.populated = ((ByteTag)map.get("TerrainPopulated")).getValue() != 0;
        this.heightMap = ((IntArrayTag)map.get("HeightMap")).getValue();
        Object sections = ((ListTag)map.get("Sections")).getValue();
        Iterator i$ = sections.iterator();
        while (i$.hasNext()) {
            CompoundTag stag = (CompoundTag)i$.next();
            CompoundMap smap = stag.getValue();
            byte y = ((ByteTag)smap.get("Y")).getValue();
            if (y < 0 || y >= 16) continue;
            byte[] blks = ((ByteArrayTag)smap.get("Blocks")).getValue();
            byte[] data = ((ByteArrayTag)smap.get("Data")).getValue();
            byte[] sky = ((ByteArrayTag)smap.get("SkyLight")).getValue();
            byte[] emit = ((ByteArrayTag)smap.get("BlockLight")).getValue();
            this.blockid[y] = new short[4096];
            short[] blkids = this.blockid[y];
            for (int i = 0; i < 4096; ++i) {
                blkids[i] = (short)(0xFF & blks[i]);
            }
            ByteArrayTag extblkid = (ByteArrayTag)smap.get("Add");
            if (extblkid != null) {
                byte[] v = extblkid.getValue();
                for (int j = 0; j < 2048; ++j) {
                    short b = (short)(v[j] & 0xFF);
                    if (b == 0) continue;
                    int n = j << 1;
                    blkids[n] = (short)(blkids[n] | (b & 0xF) << 8);
                    int n2 = (j << 1) + 1;
                    blkids[n2] = (short)(blkids[n2] | (b & 0xF0) << 4);
                }
            }
            this.blockdata[y] = data;
            this.skylight[y] = sky;
            this.emitlight[y] = emit;
            this.notempty[y] = true;
        }
    }

    public int getBlockTypeId(int x, int y, int z) {
        return this.blockid[y >> 4][(y & 0xF) << 8 | z << 4 | x];
    }

    public int getBlockData(int x, int y, int z) {
        int off = (y & 0xF) << 7 | z << 3 | x >> 1;
        return this.blockdata[y >> 4][off] >> ((x & 1) << 2) & 0xF;
    }

    public int getBlockSkyLight(int x, int y, int z) {
        int off = (y & 0xF) << 7 | z << 3 | x >> 1;
        return this.skylight[y >> 4][off] >> ((x & 1) << 2) & 0xF;
    }

    public int getBlockEmittedLight(int x, int y, int z) {
        int off = (y & 0xF) << 7 | z << 3 | x >> 1;
        return this.emitlight[y >> 4][off] >> ((x & 1) << 2) & 0xF;
    }

    public int getBiomeID(int x, int z) {
        return this.biomes[z << 4 | x];
    }

    public final boolean isSectionEmpty(int sy) {
        return !this.notempty[sy];
    }

    static {
        for (int i = 0; i < EMPTY_SKY.length; ++i) {
            StandaloneChunkSnapshot.EMPTY_SKY[i] = -1;
        }
    }
}

