/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.modsupport.impl;

import org.dynmap.modsupport.TextureFile;
import org.dynmap.modsupport.TextureFileType;

public abstract class TextureFileImpl
implements TextureFile {
    private final String txtID;
    private final String txtFileName;
    private final int xCount;
    private final int yCount;
    private final TextureFileType type;

    protected TextureFileImpl(String txtID, String txtFileName, TextureFileType type, int xCount, int yCount) {
        this.txtID = txtID;
        this.txtFileName = txtFileName;
        this.xCount = xCount;
        this.yCount = yCount;
        this.type = type;
    }

    public boolean equals(TextureFileImpl tfi) {
        return this.txtID.equals(tfi.txtID) && this.txtFileName.equals(tfi.txtFileName) && this.xCount == tfi.xCount && this.yCount == tfi.yCount && this.type == tfi.type;
    }

    @Override
    public String getTextureID() {
        return this.txtID;
    }

    @Override
    public String getTextureFile() {
        return this.txtFileName;
    }

    @Override
    public int getXCount() {
        return this.xCount;
    }

    @Override
    public int getYCount() {
        return this.yCount;
    }

    @Override
    public TextureFileType getFileType() {
        return this.type;
    }

    @Override
    public int getPatchCount() {
        return this.xCount * this.yCount;
    }

    public String getLine() {
        String s = "texture:id=" + this.txtID + ",filename=" + this.txtFileName;
        if (this.xCount > 1) {
            s = s + ",xcount=" + this.xCount;
        }
        if (this.yCount > 1) {
            s = s + ",ycount=" + this.yCount;
        }
        return s;
    }
}

