/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.modsupport.impl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.dynmap.hdmap.HDBlockModels;
import org.dynmap.modsupport.BoxBlockModel;
import org.dynmap.modsupport.CuboidBlockModel;
import org.dynmap.modsupport.ModModelDefinition;
import org.dynmap.modsupport.ModTextureDefinition;
import org.dynmap.modsupport.PaneBlockModel;
import org.dynmap.modsupport.PatchBlockModel;
import org.dynmap.modsupport.PlantBlockModel;
import org.dynmap.modsupport.StairBlockModel;
import org.dynmap.modsupport.VolumetricBlockModel;
import org.dynmap.modsupport.WallFenceBlockModel;
import org.dynmap.modsupport.impl.BlockModelImpl;
import org.dynmap.modsupport.impl.BoxBlockModelImpl;
import org.dynmap.modsupport.impl.CuboidBlockModelImpl;
import org.dynmap.modsupport.impl.ModTextureDefinitionImpl;
import org.dynmap.modsupport.impl.PaneBlockModelImpl;
import org.dynmap.modsupport.impl.PatchBlockModelImpl;
import org.dynmap.modsupport.impl.PlantBlockModelImpl;
import org.dynmap.modsupport.impl.StairBlockModelImpl;
import org.dynmap.modsupport.impl.VolumetricBlockModelImpl;
import org.dynmap.modsupport.impl.WallFenceBlockModelImpl;
import org.dynmap.renderer.RenderPatchFactory;
import org.dynmap.utils.PatchDefinition;
import org.dynmap.utils.PatchDefinitionFactory;

public class ModModelDefinitionImpl
implements ModModelDefinition {
    private final ModTextureDefinitionImpl txtDef;
    private boolean published = false;
    private ArrayList<BlockModelImpl> blkModel = new ArrayList();
    private ArrayList<PatchDefinition> blkPatch = new ArrayList();
    private HashMap<String, PatchDefinition> blkPatchMap = new HashMap();
    private PatchDefinitionFactory pdf;

    public ModModelDefinitionImpl(ModTextureDefinitionImpl txtDef) {
        this.txtDef = txtDef;
        this.pdf = HDBlockModels.getPatchDefinitionFactory();
    }

    @Override
    public String getModID() {
        return this.txtDef.getModID();
    }

    @Override
    public String getModVersion() {
        return this.txtDef.getModVersion();
    }

    @Override
    public ModTextureDefinition getTextureDefinition() {
        return this.txtDef;
    }

    @Override
    public boolean publishDefinition() {
        this.published = true;
        return true;
    }

    @Override
    public VolumetricBlockModel addVolumetricModel(int blockid, int scale) {
        VolumetricBlockModelImpl mod = new VolumetricBlockModelImpl(blockid, this, scale);
        this.blkModel.add(mod);
        return null;
    }

    @Override
    public StairBlockModel addStairModel(int blockid) {
        StairBlockModelImpl mod = new StairBlockModelImpl(blockid, this);
        this.blkModel.add(mod);
        return mod;
    }

    @Override
    public WallFenceBlockModel addWallFenceModel(int blockid, WallFenceBlockModel.FenceType type) {
        WallFenceBlockModelImpl mod = new WallFenceBlockModelImpl(blockid, this, type);
        this.blkModel.add(mod);
        return mod;
    }

    @Override
    public CuboidBlockModel addCuboidModel(int blockid) {
        CuboidBlockModelImpl mod = new CuboidBlockModelImpl(blockid, this);
        this.blkModel.add(mod);
        return mod;
    }

    @Override
    public PaneBlockModel addPaneModel(int blockid) {
        PaneBlockModelImpl mod = new PaneBlockModelImpl(blockid, this);
        this.blkModel.add(mod);
        return mod;
    }

    @Override
    public PlantBlockModel addPlantModel(int blockid) {
        PlantBlockModelImpl mod = new PlantBlockModelImpl(blockid, this);
        this.blkModel.add(mod);
        return mod;
    }

    @Override
    public BoxBlockModel addBoxModel(int blockid) {
        BoxBlockModelImpl mod = new BoxBlockModelImpl(blockid, this);
        this.blkModel.add(mod);
        return mod;
    }

    @Override
    public PatchBlockModel addPatchModel(int blockid) {
        PatchBlockModelImpl mod = new PatchBlockModelImpl(blockid, this);
        this.blkModel.add(mod);
        return mod;
    }

    @Override
    public PatchBlockModel addRotatedPatchModel(int blockid, PatchBlockModel model, int xrot, int yrot, int zrot) {
        PatchBlockModelImpl mod = new PatchBlockModelImpl(blockid, this, model, xrot, yrot, zrot);
        this.blkModel.add(mod);
        return mod;
    }

    public String getPatchID(double x0, double y0, double z0, double xu, double yu, double zu, double xv, double yv, double zv, double umin, double umax, double vmin, double vmax, double uplusvmax, RenderPatchFactory.SideVisible sidevis) {
        PatchDefinition pd = this.pdf.getPatch(x0, y0, z0, xu, yu, zu, xv, yv, zv, umin, umax, vmin, vmax, uplusvmax, sidevis, 0);
        for (int i = 0; i < this.blkPatch.size(); ++i) {
            if (this.blkPatch.get(i) != pd) continue;
            return "patch" + i;
        }
        this.blkPatch.add(pd);
        String id = "patch" + (this.blkPatch.size() - 1);
        this.blkPatchMap.put(id, pd);
        return id;
    }

    public String getRotatedPatchID(String patchid, int xrot, int yrot, int zrot) {
        PatchDefinition pd = this.blkPatchMap.get(patchid);
        if (pd == null) {
            return null;
        }
        PatchDefinition newpd = (PatchDefinition)this.pdf.getRotatedPatch(pd, xrot, yrot, zrot, 0);
        if (newpd != null) {
            for (int i = 0; i < this.blkPatch.size(); ++i) {
                if (this.blkPatch.get(i) != newpd) continue;
                return "patch" + i;
            }
            this.blkPatch.add(newpd);
            String id = "patch" + (this.blkPatch.size() - 1);
            this.blkPatchMap.put(id, newpd);
            return id;
        }
        return null;
    }

    public boolean isPublished() {
        return this.published;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToFile(File destdir) throws IOException {
        if (this.blkModel.isEmpty()) {
            return;
        }
        File f = new File(destdir, this.txtDef.getModID() + "-models.txt");
        FileWriter fw = null;
        try {
            String line;
            fw = new FileWriter(f);
            String s = "modname:" + this.txtDef.getModID();
            fw.write(s + "\n\n");
            for (int i = 0; i < this.blkPatch.size(); ++i) {
                PatchDefinition pd = this.blkPatch.get(i);
                line = String.format("patch:id=patch%d,Ox=%f,Oy=%f,Oz=%f,Ux=%f,Uy=%f,Uz=%f,Vx=%f,Vy=%f,Vz=%f,Umin=%f,Umax=%f,Vmin=%f,Vmax=%f,UplusVmax=%f", i, pd.x0, pd.y0, pd.z0, pd.xu, pd.yu, pd.zu, pd.xv, pd.yv, pd.zv, pd.umin, pd.umax, pd.vmin, pd.vmax, pd.uplusvmax);
                switch (pd.sidevis) {
                    case BOTTOM: {
                        line = line + ",visibility=bottom";
                        break;
                    }
                    case TOP: {
                        line = line + ",visibility=top";
                        break;
                    }
                    case FLIP: {
                        line = line + ",visibility=flip";
                        break;
                    }
                }
                if (line == null) continue;
                fw.write(line + "\n");
            }
            for (BlockModelImpl btr : this.blkModel) {
                line = btr.getLine();
                if (line == null) continue;
                fw.write(line + "\n");
            }
        }
        finally {
            if (fw != null) {
                fw.close();
            }
        }
    }
}

