/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.kzedmap;

import java.util.List;
import org.dynmap.DynmapChunk;
import org.dynmap.DynmapWorld;
import org.dynmap.MapTile;
import org.dynmap.kzedmap.KzedMapTile;
import org.dynmap.utils.MapChunkCache;

public class KzedZoomedMapTile
extends MapTile {
    private String fname;
    private String fname_day;
    public KzedMapTile originalTile;

    @Override
    public String getFilename() {
        if (this.fname == null) {
            this.fname = this.world.bigworld ? "z" + this.originalTile.renderer.getPrefix() + "/" + (this.getTileX() >> 12) + '_' + (this.getTileY() >> 12) + '/' + this.getTileX() + "_" + this.getTileY() + ".png" : "z" + this.originalTile.renderer.getPrefix() + "_" + this.getTileX() + "_" + this.getTileY() + ".png";
        }
        return this.fname;
    }

    @Override
    public String getDayFilename() {
        if (this.fname_day == null) {
            this.fname_day = this.world.bigworld ? "z" + this.originalTile.renderer.getPrefix() + "_day/" + (this.getTileX() >> 12) + '_' + (this.getTileY() >> 12) + '/' + this.getTileX() + "_" + this.getTileY() + ".png" : "z" + this.originalTile.renderer.getPrefix() + "_day_" + this.getTileX() + "_" + this.getTileY() + ".png";
        }
        return this.fname_day;
    }

    public KzedZoomedMapTile(DynmapWorld world, KzedMapTile original) {
        super(world);
        this.originalTile = original;
    }

    @Override
    protected String saveTileData() {
        return this.originalTile.saveTileData();
    }

    public int getTileX() {
        return KzedZoomedMapTile.ztilex(this.originalTile.px + 128);
    }

    public int getTileY() {
        return KzedZoomedMapTile.ztiley(this.originalTile.py);
    }

    private static int ztilex(int x) {
        if (x < 0) {
            return x + x % 256;
        }
        return x - x % 256;
    }

    private static int ztiley(int y) {
        if (y < 0) {
            return y + y % 256;
        }
        return y - y % 256;
    }

    @Override
    public int hashCode() {
        return this.getFilename().hashCode() ^ this.world.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof KzedZoomedMapTile) {
            return ((KzedZoomedMapTile)obj).originalTile.equals(this.originalTile);
        }
        return false;
    }

    @Override
    public String getKey(String prefix) {
        return this.world.getName() + ".z" + prefix;
    }

    @Override
    public boolean render(MapChunkCache cache, String mapname) {
        return false;
    }

    @Override
    public List<DynmapChunk> getRequiredChunks() {
        return null;
    }

    @Override
    public MapTile[] getAdjecentTiles() {
        return null;
    }

    @Override
    public boolean isBiomeDataNeeded() {
        return this.originalTile.isBiomeDataNeeded();
    }

    @Override
    public boolean isHightestBlockYDataNeeded() {
        return false;
    }

    @Override
    public boolean isRawBiomeDataNeeded() {
        return this.originalTile.isRawBiomeDataNeeded();
    }

    @Override
    public boolean isBlockTypeDataNeeded() {
        return true;
    }

    @Override
    public int tileOrdinalX() {
        return this.originalTile.px >> 8;
    }

    @Override
    public int tileOrdinalY() {
        return this.originalTile.py >> 8;
    }
}

