/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.kzedmap;

import java.io.File;
import java.util.List;
import org.dynmap.DynmapChunk;
import org.dynmap.DynmapWorld;
import org.dynmap.MapManager;
import org.dynmap.MapTile;
import org.dynmap.MapType;
import org.dynmap.kzedmap.KzedMap;
import org.dynmap.kzedmap.MapTileRenderer;
import org.dynmap.utils.MapChunkCache;

public class KzedMapTile
extends MapTile {
    public KzedMap map;
    public MapTileRenderer renderer;
    public int px;
    public int py;
    private String fname;
    private String fname_day;
    public File file = null;

    public KzedMapTile(DynmapWorld world, KzedMap map, MapTileRenderer renderer, int px, int py) {
        super(world);
        this.map = map;
        this.renderer = renderer;
        this.px = px;
        this.py = py;
    }

    public KzedMapTile(DynmapWorld world, String parm) throws Exception {
        super(world);
        String[] parms = parm.split(",");
        if (parms.length < 4) {
            throw new Exception("wrong parameter count");
        }
        this.px = Integer.parseInt(parms[0]);
        this.py = Integer.parseInt(parms[1]);
        for (MapType t : world.maps) {
            if (!t.getName().equals(parms[2]) || !(t instanceof KzedMap)) continue;
            this.map = (KzedMap)t;
            break;
        }
        if (this.map == null) {
            throw new Exception("invalid map");
        }
        for (MapTileRenderer r : this.map.renderers) {
            if (!r.getName().equals(parms[3])) continue;
            this.renderer = r;
            break;
        }
        if (this.renderer == null) {
            throw new Exception("invalid renderer");
        }
    }

    @Override
    protected String saveTileData() {
        return String.format("%d,%d,%s,%s", this.px, this.py, this.map.getName(), this.renderer.getName());
    }

    @Override
    public String getFilename() {
        if (this.fname == null) {
            this.fname = this.map.isBigWorldMap(this.world) ? this.renderer.getPrefix() + "/" + (this.px >> 12) + '_' + (this.py >> 12) + '/' + this.px + "_" + this.py + ".png" : this.renderer.getPrefix() + "_" + this.px + "_" + this.py + ".png";
        }
        return this.fname;
    }

    @Override
    public String getDayFilename() {
        if (this.fname_day == null) {
            this.fname_day = this.map.isBigWorldMap(this.world) ? this.renderer.getPrefix() + "_day/" + (this.px >> 12) + '_' + (this.py >> 12) + '/' + this.px + "_" + this.py + ".png" : this.renderer.getPrefix() + "_day_" + this.px + "_" + this.py + ".png";
        }
        return this.fname_day;
    }

    @Override
    public int hashCode() {
        return this.px ^ this.py ^ this.map.getName().hashCode() ^ this.world.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof KzedMapTile) {
            return this.equals((KzedMapTile)obj);
        }
        return false;
    }

    public boolean equals(KzedMapTile o) {
        return o.px == this.px && o.py == this.py && o.map == this.map && o.world == this.world;
    }

    @Override
    public String getKey(String prefix) {
        return this.world.getName() + "." + prefix;
    }

    public String toString() {
        return this.world.getName() + ":" + this.getFilename();
    }

    @Override
    public boolean render(MapChunkCache cache, String mapname) {
        boolean rslt = false;
        for (MapTileRenderer r : this.map.renderers) {
            if (mapname != null && !r.getName().equals(mapname)) continue;
            KzedMapTile t = new KzedMapTile(this.world, this.map, r, this.px, this.py);
            rslt |= this.map.render(cache, t, MapManager.mapman.getTileFile(t));
        }
        return rslt;
    }

    @Override
    public List<DynmapChunk> getRequiredChunks() {
        return this.map.getRequiredChunks(this);
    }

    @Override
    public MapTile[] getAdjecentTiles() {
        return this.map.getAdjecentTiles(this);
    }

    @Override
    public boolean isBiomeDataNeeded() {
        return this.map.isBiomeDataNeeded();
    }

    @Override
    public boolean isHightestBlockYDataNeeded() {
        return false;
    }

    @Override
    public boolean isRawBiomeDataNeeded() {
        return this.map.isRawBiomeDataNeeded();
    }

    @Override
    public boolean isBlockTypeDataNeeded() {
        return true;
    }

    @Override
    public int tileOrdinalX() {
        return this.px >> 7;
    }

    @Override
    public int tileOrdinalY() {
        return this.py >> 7;
    }
}

