/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.kzedmap;

import java.util.HashSet;
import java.util.List;
import org.dynmap.Color;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapCore;
import org.dynmap.DynmapWorld;
import org.dynmap.kzedmap.DefaultTileRenderer;
import org.dynmap.utils.BlockStep;
import org.dynmap.utils.MapIterator;

public class HighlightTileRenderer
extends DefaultTileRenderer {
    protected HashSet<Integer> highlightBlocks = new HashSet();

    public HighlightTileRenderer(DynmapCore core, ConfigurationNode configuration) {
        super(core, configuration);
        List highlight = configuration.getList("highlight");
        for (Integer i : highlight) {
            this.highlightBlocks.add(i);
        }
    }

    @Override
    protected void scan(DynmapWorld world, int seq, boolean isnether, Color result, Color result_day, MapIterator mapiter) {
        result.setTransparent();
        while (mapiter.getY() >= 0) {
            Color[] colors;
            int id = mapiter.getBlockTypeID();
            if (isnether) {
                if (id != 0) {
                    if (result.isTransparent() && this.colorScheme.colors[id] != null) {
                        result.setColor(this.colorScheme.colors[id][seq]);
                    }
                    id = 0;
                } else {
                    isnether = false;
                }
            }
            int data = 0;
            if (this.colorScheme.datacolors[id] != null) {
                data = mapiter.getBlockData();
            }
            switch (seq) {
                case 0: {
                    mapiter.stepPosition(BlockStep.X_MINUS);
                    break;
                }
                case 1: 
                case 3: {
                    mapiter.stepPosition(BlockStep.Y_MINUS);
                    break;
                }
                case 2: {
                    mapiter.stepPosition(BlockStep.Z_PLUS);
                }
            }
            seq = seq + 1 & 3;
            if (id == 0 || (colors = data != 0 ? this.colorScheme.datacolors[id][data] : this.colorScheme.colors[id]) == null) continue;
            Color c = colors[seq];
            if (this.highlightBlocks.contains(id)) {
                result.setColor(c);
                return;
            }
            if (c.getAlpha() <= 0 || result.getAlpha() >= 255) continue;
            int cr = result.getRed();
            int cg = result.getGreen();
            int cb = result.getBlue();
            int ca = result.getAlpha();
            int na = 255 - ca;
            result.setRGBA(c.getRed() * na + (cr *= ca) >> 8, c.getGreen() * na + (cg *= ca) >> 8, c.getBlue() * na + (cb *= ca) >> 8, Math.min(255, c.getAlpha() + ca));
        }
    }
}

