/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap;

import java.util.HashMap;
import java.util.TreeSet;
import org.dynmap.Color;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapCore;
import org.dynmap.JSONUtils;
import org.dynmap.Log;
import org.dynmap.MapManager;
import org.dynmap.hdmap.HDLighting;
import org.dynmap.hdmap.HDMap;
import org.dynmap.hdmap.HDPerspectiveState;
import org.dynmap.hdmap.HDShader;
import org.dynmap.hdmap.HDShaderState;
import org.dynmap.json.simple.JSONObject;
import org.dynmap.utils.DynLongHashMap;
import org.dynmap.utils.MapChunkCache;
import org.dynmap.utils.MapIterator;

public class InhabitedHDShader
implements HDShader {
    private final String name;
    private final long[] filllevel;
    private final Color[] fillcolor;

    private Color readColor(String id, ConfigurationNode cfg) {
        String lclr = cfg.getString(id, null);
        if (lclr != null && lclr.startsWith("#")) {
            try {
                int c = Integer.parseInt(lclr.substring(1), 16);
                return new Color(c >> 16 & 0xFF, c >> 8 & 0xFF, c & 0xFF);
            }
            catch (NumberFormatException nfx) {
                Log.severe("Invalid color value: " + lclr + " for '" + id + "'");
            }
        }
        return null;
    }

    public InhabitedHDShader(DynmapCore core, ConfigurationNode configuration) {
        this.name = (String)configuration.get("name");
        HashMap<Long, Color> map = new HashMap<Long, Color>();
        for (String key : configuration.keySet()) {
            if (!key.startsWith("color")) continue;
            try {
                long val = Long.parseLong(key.substring(5));
                Color clr = this.readColor(key, configuration);
                map.put(val, clr);
            }
            catch (NumberFormatException nfx) {}
        }
        TreeSet keys = new TreeSet(map.keySet());
        this.filllevel = new long[keys.size()];
        this.fillcolor = new Color[keys.size()];
        int idx = 0;
        for (Long k : keys) {
            this.filllevel[idx] = k;
            this.fillcolor[idx] = (Color)map.get(k);
            ++idx;
        }
    }

    @Override
    public boolean isBiomeDataNeeded() {
        return false;
    }

    @Override
    public boolean isRawBiomeDataNeeded() {
        return false;
    }

    @Override
    public boolean isHightestBlockYDataNeeded() {
        return false;
    }

    @Override
    public boolean isBlockTypeDataNeeded() {
        return true;
    }

    @Override
    public boolean isSkyLightLevelNeeded() {
        return false;
    }

    @Override
    public boolean isEmittedLightLevelNeeded() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public HDShaderState getStateInstance(HDMap map, MapChunkCache cache, MapIterator mapiter, int scale) {
        return new OurShaderState(mapiter, map, cache, scale);
    }

    @Override
    public void addClientConfiguration(JSONObject mapObject) {
        JSONUtils.s(mapObject, "shader", this.name);
    }

    private class OurShaderState
    implements HDShaderState {
        private Color[] color;
        private Color c;
        protected HDMap map;
        private HDLighting lighting;
        final int[] lightingTable;

        private OurShaderState(MapIterator mapiter, HDMap map, MapChunkCache cache, int scale) {
            this.map = map;
            this.lighting = map.getLighting();
            this.color = this.lighting.isNightAndDayEnabled() ? new Color[]{new Color(), new Color()} : new Color[]{new Color()};
            this.c = new Color();
            this.lightingTable = (int[])(MapManager.mapman.useBrightnessTable() ? cache.getWorld().getBrightnessTable() : null);
        }

        @Override
        public HDShader getShader() {
            return InhabitedHDShader.this;
        }

        @Override
        public HDMap getMap() {
            return this.map;
        }

        @Override
        public HDLighting getLighting() {
            return this.lighting;
        }

        @Override
        public void reset(HDPerspectiveState ps) {
            for (int i = 0; i < this.color.length; ++i) {
                this.color[i].setTransparent();
            }
        }

        @Override
        public boolean processBlock(HDPerspectiveState ps) {
            if (ps.getBlockTypeID() == 0) {
                return false;
            }
            long ts = ps.getMapIterator().getInhabitedTicks() / 1200L;
            boolean match = false;
            for (int i = 0; i < InhabitedHDShader.this.filllevel.length; ++i) {
                if (ts >= InhabitedHDShader.this.filllevel[i]) continue;
                if (i > 0) {
                    int interp = (int)(256L * (ts - InhabitedHDShader.this.filllevel[i - 1]) / (InhabitedHDShader.this.filllevel[i] - InhabitedHDShader.this.filllevel[i - 1]));
                    int red = interp * InhabitedHDShader.this.fillcolor[i].getRed() + (256 - interp) * InhabitedHDShader.this.fillcolor[i - 1].getRed();
                    int green = interp * InhabitedHDShader.this.fillcolor[i].getGreen() + (256 - interp) * InhabitedHDShader.this.fillcolor[i - 1].getGreen();
                    int blue = interp * InhabitedHDShader.this.fillcolor[i].getBlue() + (256 - interp) * InhabitedHDShader.this.fillcolor[i - 1].getBlue();
                    this.c.setRGBA(red / 256, green / 256, blue / 256, 255);
                } else {
                    this.c.setColor(InhabitedHDShader.this.fillcolor[i]);
                }
                match = true;
                break;
            }
            if (!match) {
                this.c.setColor(InhabitedHDShader.this.fillcolor[InhabitedHDShader.this.fillcolor.length - 1]);
            }
            this.lighting.applyLighting(ps, this, this.c, this.color);
            return true;
        }

        @Override
        public void rayFinished(HDPerspectiveState ps) {
        }

        @Override
        public void getRayColor(Color c, int index) {
            c.setColor(this.color[index]);
        }

        @Override
        public void cleanup() {
        }

        @Override
        public DynLongHashMap getCTMTextureCache() {
            return null;
        }

        @Override
        public int[] getLightingTable() {
            return this.lightingTable;
        }
    }
}

