/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap;

import java.util.List;
import org.dynmap.Color;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapCore;
import org.dynmap.JSONUtils;
import org.dynmap.MapManager;
import org.dynmap.hdmap.HDLighting;
import org.dynmap.hdmap.HDMap;
import org.dynmap.hdmap.HDPerspectiveState;
import org.dynmap.hdmap.HDShader;
import org.dynmap.hdmap.HDShaderState;
import org.dynmap.json.simple.JSONObject;
import org.dynmap.utils.DynLongHashMap;
import org.dynmap.utils.MapChunkCache;
import org.dynmap.utils.MapIterator;

public class CaveHDShader
implements HDShader {
    private String name;
    private boolean iflit;
    private int[] hiddenids;

    private void setHidden(int id) {
        if (id >= 0 && id < 65535) {
            int n = id >> 5;
            this.hiddenids[n] = this.hiddenids[n] | 1 << (id & 0x1F);
        }
    }

    private boolean isHidden(int id) {
        return (this.hiddenids[id >> 5] & 1 << (id & 0x1F)) != 0;
    }

    public CaveHDShader(DynmapCore core, ConfigurationNode configuration) {
        this.name = (String)configuration.get("name");
        this.iflit = configuration.getBoolean("onlyiflit", false);
        this.hiddenids = new int[2048];
        this.setHidden(0);
        List hidden = configuration.getList("hiddenids");
        if (hidden != null) {
            for (Object o : hidden) {
                if (!(o instanceof Integer)) continue;
                int v = (Integer)o;
                this.setHidden(v);
            }
        } else {
            this.setHidden(17);
            this.setHidden(18);
            this.setHidden(20);
            this.setHidden(64);
            this.setHidden(71);
            this.setHidden(78);
            this.setHidden(79);
        }
    }

    @Override
    public boolean isBiomeDataNeeded() {
        return false;
    }

    @Override
    public boolean isRawBiomeDataNeeded() {
        return false;
    }

    @Override
    public boolean isHightestBlockYDataNeeded() {
        return false;
    }

    @Override
    public boolean isBlockTypeDataNeeded() {
        return true;
    }

    @Override
    public boolean isSkyLightLevelNeeded() {
        return false;
    }

    @Override
    public boolean isEmittedLightLevelNeeded() {
        return this.iflit;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public HDShaderState getStateInstance(HDMap map, MapChunkCache cache, MapIterator mapiter, int scale) {
        return new OurShaderState(mapiter, map, cache);
    }

    @Override
    public void addClientConfiguration(JSONObject mapObject) {
        JSONUtils.s(mapObject, "shader", this.name);
    }

    private class OurShaderState
    implements HDShaderState {
        private Color color;
        protected MapIterator mapiter;
        protected HDMap map;
        private boolean air;
        private int yshift;
        final int[] lightingTable;

        private OurShaderState(MapIterator mapiter, HDMap map, MapChunkCache cache) {
            this.mapiter = mapiter;
            this.map = map;
            this.color = new Color();
            int wheight = mapiter.getWorldHeight();
            this.yshift = 0;
            while (wheight > 128) {
                wheight >>= 1;
                ++this.yshift;
            }
            this.lightingTable = (int[])(MapManager.mapman.useBrightnessTable() ? cache.getWorld().getBrightnessTable() : null);
        }

        @Override
        public HDShader getShader() {
            return CaveHDShader.this;
        }

        @Override
        public HDMap getMap() {
            return this.map;
        }

        @Override
        public HDLighting getLighting() {
            return this.map.getLighting();
        }

        @Override
        public void reset(HDPerspectiveState ps) {
            this.color.setTransparent();
            this.air = true;
        }

        @Override
        public boolean processBlock(HDPerspectiveState ps) {
            int blocktype = ps.getBlockTypeID();
            if (!CaveHDShader.this.isHidden(blocktype)) {
                this.air = false;
                return false;
            }
            blocktype = 0;
            if (blocktype == 0 && !this.air) {
                int cb;
                int cg;
                int cr;
                if (CaveHDShader.this.iflit && ps.getMapIterator().getBlockEmittedLight() == 0) {
                    return false;
                }
                int mult = 256;
                int ys = this.mapiter.getY() >> this.yshift;
                if (ys < 64) {
                    cr = 0;
                    cg = 64 + ys * 3;
                    cb = 255 - ys * 4;
                } else {
                    cr = (ys - 64) * 4;
                    cg = 255;
                    cb = 0;
                }
                switch (ps.getLastBlockStep()) {
                    case X_PLUS: 
                    case X_MINUS: {
                        mult = 224;
                        break;
                    }
                    case Z_PLUS: 
                    case Z_MINUS: {
                        mult = 256;
                        break;
                    }
                    default: {
                        mult = 160;
                    }
                }
                cr = cr * mult / 256;
                cg = cg * mult / 256;
                cb = cb * mult / 256;
                this.color.setRGBA(cr, cg, cb, 255);
                return true;
            }
            return false;
        }

        @Override
        public void rayFinished(HDPerspectiveState ps) {
        }

        @Override
        public void getRayColor(Color c, int index) {
            c.setColor(this.color);
        }

        @Override
        public void cleanup() {
        }

        @Override
        public DynLongHashMap getCTMTextureCache() {
            return null;
        }

        @Override
        public int[] getLightingTable() {
            return this.lightingTable;
        }
    }
}

